/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.BinaryRule;
import edu.berkeley.nlp.PCFGLA.ConditionalTrainer;
import edu.berkeley.nlp.PCFGLA.ConstrainedTwoChartsParser;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.HierarchicalAdaptiveBinaryRule;
import edu.berkeley.nlp.PCFGLA.HierarchicalAdaptiveUnaryRule;
import edu.berkeley.nlp.PCFGLA.Lexicon;
import edu.berkeley.nlp.PCFGLA.SpanPredictor;
import edu.berkeley.nlp.PCFGLA.UnaryRule;
import edu.berkeley.nlp.discPCFG.Linearizer;
import edu.berkeley.nlp.math.DoubleArrays;
import edu.berkeley.nlp.math.SloppyMath;
import edu.berkeley.nlp.syntax.StateSet;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.util.ScalingTools;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstrainedHierarchicalTwoChartParser
extends ConstrainedTwoChartsParser {
    protected double[][][][][] h_iScorePreU;
    protected double[][][][][] h_iScorePostU;
    protected double[][][][][] h_oScorePreU;
    protected double[][][][][] h_oScorePostU;
    int finalLevel;
    int[] substatesToCover;

    public ConstrainedHierarchicalTwoChartParser(Grammar gr, Lexicon lex, SpanPredictor sp, int f) {
        super(gr, lex, sp);
        this.finalLevel = f;
        this.substatesToCover = new int[this.finalLevel + 1];
        for (int i = 0; i <= this.finalLevel; ++i) {
            this.substatesToCover[i] = (int)Math.pow(2.0, this.finalLevel - i);
        }
    }

    @Override
    void doConstrainedInsideScores(boolean viterbi) {
        this.doConstrainedInsideScores(viterbi, null);
    }

    @Override
    void doConstrainedInsideScores(boolean viterbi, double[][][] spanScores) {
        for (int diff = 1; diff <= this.length; ++diff) {
            for (int start = 0; start < this.length - diff + 1; ++start) {
                int np;
                int nParentStates;
                int pState;
                int end = start + diff;
                for (pState = 0; pState < this.numSubStatesArray.length; ++pState) {
                    double val;
                    if (diff == 1 || this.allowedSubStates[start][end][pState] == null) continue;
                    BinaryRule[] parentRules = this.grammar.splitRulesWithP(pState);
                    nParentStates = this.numSubStatesArray[pState];
                    boolean somethingChanged = false;
                    for (int i = 0; i < parentRules.length; ++i) {
                        int max;
                        int min;
                        boolean iPossibleR;
                        boolean iPossibleL;
                        HierarchicalAdaptiveBinaryRule r = (HierarchicalAdaptiveBinaryRule)parentRules[i];
                        short lState = r.leftChildState;
                        short rState = r.rightChildState;
                        int narrowR = this.narrowRExtent[start][lState];
                        boolean bl = iPossibleL = narrowR < end;
                        if (!iPossibleL) continue;
                        int narrowL = this.narrowLExtent[end][rState];
                        boolean bl2 = iPossibleR = narrowL >= narrowR;
                        if (!iPossibleR) continue;
                        int min1 = narrowR;
                        int min2 = this.wideLExtent[end][rState];
                        int n = min = min1 > min2 ? min1 : min2;
                        if (min > narrowL) continue;
                        int max1 = this.wideRExtent[start][lState];
                        int max2 = narrowL;
                        int n2 = max = max1 < max2 ? max1 : max2;
                        if (min > max) continue;
                        for (int split = min; split <= max; ++split) {
                            boolean changeThisRound = false;
                            if (this.allowedSubStates[start][split][lState] == null || this.allowedSubStates[split][end][rState] == null || !(changeThisRound = this.computeInsideScore(start, split, end, r, viterbi))) continue;
                            somethingChanged = true;
                            int parentScale = this.iScale[start][end][pState];
                            int currentScale = this.iScale[start][split][lState] + this.iScale[split][end][rState];
                            if (parentScale != (currentScale = ScalingTools.scaleArray(this.unscaledScoresToAdd, currentScale))) {
                                if (parentScale == Integer.MIN_VALUE) {
                                    this.iScale[start][end][pState] = currentScale;
                                } else {
                                    int newScale = Math.max(currentScale, parentScale);
                                    ScalingTools.scaleArrayToScale(this.unscaledScoresToAdd, currentScale, newScale);
                                    ScalingTools.scaleArrayToScale(this.h_iScorePreU[start][end][pState][this.finalLevel], parentScale, newScale);
                                    this.iScale[start][end][pState] = newScale;
                                }
                            }
                            for (int np2 = 0; np2 < nParentStates; ++np2) {
                                if (viterbi) {
                                    this.h_iScorePreU[start][end][pState][this.finalLevel][np2] = Math.max(this.h_iScorePreU[start][end][pState][this.finalLevel][np2], this.unscaledScoresToAdd[np2]);
                                    continue;
                                }
                                double[] dArray = this.h_iScorePreU[start][end][pState][this.finalLevel];
                                int n3 = np2;
                                dArray[n3] = dArray[n3] + this.unscaledScoresToAdd[np2];
                            }
                            Arrays.fill(this.unscaledScoresToAdd, 0.0);
                        }
                    }
                    if (!somethingChanged) continue;
                    if (spanScores != null && (val = spanScores[start][end][this.stateClass[pState]]) != 1.0) {
                        np = 0;
                        while (np < nParentStates) {
                            double[] dArray = this.h_iScorePreU[start][end][pState][this.finalLevel];
                            int n = np++;
                            dArray[n] = dArray[n] * val;
                        }
                    }
                    this.updateHierarchy(this.h_iScorePreU[start][end][pState]);
                    if (start > this.narrowLExtent[end][pState]) {
                        this.narrowLExtent[end][pState] = start;
                        this.wideLExtent[end][pState] = start;
                    } else if (start < this.wideLExtent[end][pState]) {
                        this.wideLExtent[end][pState] = start;
                    }
                    if (end < this.narrowRExtent[start][pState]) {
                        this.narrowRExtent[start][pState] = end;
                        this.wideRExtent[start][pState] = end;
                        continue;
                    }
                    if (end <= this.wideRExtent[start][pState]) continue;
                    this.wideRExtent[start][pState] = end;
                }
                for (pState = 0; pState < this.numSubStatesArray.length; ++pState) {
                    int parentScale;
                    if (diff == this.length && pState != 0 || this.allowedSubStates[start][end][pState] == null) continue;
                    UnaryRule[] unaries = this.grammar.getClosedSumUnaryRulesByParent(pState);
                    nParentStates = this.numSubStatesArray[pState];
                    int scaleBeforeUnaries = parentScale = this.iScale[start][end][pState];
                    boolean somethingChanged = false;
                    for (int r = 0; r < unaries.length; ++r) {
                        boolean changeThisRound;
                        HierarchicalAdaptiveUnaryRule ur = (HierarchicalAdaptiveUnaryRule)unaries[r];
                        short cState = ur.childState;
                        if (pState == cState || this.allowedSubStates[start][end][cState] == null || this.h_iScorePreU[start][end][cState] == null || !(changeThisRound = this.computeInsideScore(start, end, ur, viterbi))) continue;
                        somethingChanged = true;
                        int currentScale = this.iScale[start][end][cState];
                        if (parentScale != (currentScale = ScalingTools.scaleArray(this.unscaledScoresToAdd, currentScale))) {
                            if (parentScale == Integer.MIN_VALUE) {
                                parentScale = currentScale;
                            } else {
                                int newScale = Math.max(currentScale, parentScale);
                                ScalingTools.scaleArrayToScale(this.unscaledScoresToAdd, currentScale, newScale);
                                ScalingTools.scaleArrayToScale(this.h_iScorePostU[start][end][pState][this.finalLevel], parentScale, newScale);
                                parentScale = newScale;
                            }
                        }
                        for (int np3 = 0; np3 < nParentStates; ++np3) {
                            if (viterbi) {
                                this.h_iScorePostU[start][end][pState][this.finalLevel][np3] = Math.max(this.h_iScorePostU[start][end][pState][this.finalLevel][np3], this.unscaledScoresToAdd[np3]);
                                continue;
                            }
                            double[] dArray = this.h_iScorePostU[start][end][pState][this.finalLevel];
                            int n = np3;
                            dArray[n] = dArray[n] + this.unscaledScoresToAdd[np3];
                        }
                        Arrays.fill(this.unscaledScoresToAdd, 0.0);
                    }
                    if (somethingChanged) {
                        int newScale = Math.max(scaleBeforeUnaries, parentScale);
                        ScalingTools.scaleArrayToScale(this.h_iScorePreU[start][end][pState][this.finalLevel], scaleBeforeUnaries, newScale);
                        ScalingTools.scaleArrayToScale(this.h_iScorePostU[start][end][pState][this.finalLevel], parentScale, newScale);
                        this.iScale[start][end][pState] = newScale;
                        if (newScale != scaleBeforeUnaries && pState != 0) {
                            this.updateHierarchy(this.h_iScorePreU[start][end][pState]);
                        }
                        if (start > this.narrowLExtent[end][pState]) {
                            this.narrowLExtent[end][pState] = start;
                            this.wideLExtent[end][pState] = start;
                        } else if (start < this.wideLExtent[end][pState]) {
                            this.wideLExtent[end][pState] = start;
                        }
                        if (end < this.narrowRExtent[start][pState]) {
                            this.narrowRExtent[start][pState] = end;
                            this.wideRExtent[start][pState] = end;
                        } else if (end > this.wideRExtent[start][pState]) {
                            this.wideRExtent[start][pState] = end;
                        }
                    }
                    for (np = 0; np < nParentStates; ++np) {
                        double val = this.h_iScorePreU[start][end][pState][this.finalLevel][np];
                        if (!(val > 0.0)) continue;
                        if (viterbi) {
                            this.h_iScorePostU[start][end][pState][this.finalLevel][np] = Math.max(this.h_iScorePostU[start][end][pState][this.finalLevel][np], val);
                            continue;
                        }
                        double[] dArray = this.h_iScorePostU[start][end][pState][this.finalLevel];
                        int n = np;
                        dArray[n] = dArray[n] + val;
                    }
                    if (pState == 0) continue;
                    this.updateHierarchy(this.h_iScorePostU[start][end][pState]);
                }
            }
        }
    }

    private final void updateHierarchy(double[][] ds) {
        for (int level = this.finalLevel - 1; level >= 0; --level) {
            for (int i = 0; i < this.substatesToCover[this.finalLevel - level]; ++i) {
                ds[level][i] = ds[level + 1][2 * i] + ds[level + 1][2 * i + 1];
            }
        }
    }

    private final boolean computeInsideScore(int start, int split, int end, HierarchicalAdaptiveBinaryRule rule, boolean viterbi) {
        short pState = rule.parentState;
        short lState = rule.leftChildState;
        short rState = rule.rightChildState;
        boolean changeThisRound = false;
        for (HierarchicalAdaptiveBinaryRule.SubRule subRule : rule.subRuleList) {
            double rS;
            short level;
            double lS;
            if (subRule == null || (lS = this.h_iScorePostU[start][split][lState][level = subRule.level][subRule.lChild]) == 0.0 || (rS = this.h_iScorePostU[split][end][rState][level][subRule.rChild]) == 0.0) continue;
            double score = lS * rS * subRule.score;
            int k = this.substatesToCover[level] * subRule.parent;
            int l = k + this.substatesToCover[level];
            for (int np = k; np < l; ++np) {
                if (!this.allowedSubStates[start][end][pState][np]) continue;
                if (viterbi) {
                    this.unscaledScoresToAdd[np] = Math.max(this.unscaledScoresToAdd[np], score);
                } else {
                    int n = np;
                    this.unscaledScoresToAdd[n] = this.unscaledScoresToAdd[n] + score;
                }
                changeThisRound = true;
            }
        }
        return changeThisRound;
    }

    private final boolean computeInsideScore(int start, int end, HierarchicalAdaptiveUnaryRule rule, boolean viterbi) {
        short pState = rule.parentState;
        short cState = rule.childState;
        boolean changeThisRound = false;
        for (HierarchicalAdaptiveUnaryRule.SubRule subRule : rule.subRuleList) {
            short level;
            double cS;
            if (subRule == null || (cS = this.h_iScorePreU[start][end][cState][level = subRule.level][subRule.child]) == 0.0) continue;
            double score = cS * subRule.score;
            int k = this.substatesToCover[level] * subRule.parent;
            int l = k + this.substatesToCover[level];
            if (pState == 0) {
                l = 1;
            }
            for (int np = k; np < l; ++np) {
                if (!this.allowedSubStates[start][end][pState][np]) continue;
                if (viterbi) {
                    this.unscaledScoresToAdd[np] = Math.max(this.unscaledScoresToAdd[np], score);
                } else {
                    int n = np;
                    this.unscaledScoresToAdd[n] = this.unscaledScoresToAdd[n] + score;
                }
                changeThisRound = true;
            }
        }
        return changeThisRound;
    }

    @Override
    void doConstrainedOutsideScores(boolean viterbi) {
        this.doConstrainedOutsideScores(viterbi, null);
    }

    @Override
    void doConstrainedOutsideScores(boolean viterbi, double[][][] spanScores) {
        double initVal = 0.0;
        for (int diff = this.length; diff >= 1; --diff) {
            int start = 0;
            while (start + diff <= this.length) {
                int nChildStates;
                int pState;
                int end = start + diff;
                int nStates = diff == this.length ? 1 : this.numSubStatesArray.length;
                for (pState = 0; pState < nStates; ++pState) {
                    if (this.allowedSubStates[start][end][pState] == null) continue;
                    nChildStates = this.numSubStatesArray[pState];
                    if (spanScores == null) continue;
                    double val = spanScores[start][end][this.stateClass[pState]];
                    if (val != 1.0) {
                        int np = 0;
                        while (np < nChildStates) {
                            double[] dArray = this.h_oScorePreU[start][end][pState][this.finalLevel];
                            int n = np++;
                            dArray[n] = dArray[n] * val;
                        }
                    }
                    if (pState != 0) {
                        this.updateHierarchy(this.h_oScorePreU[start][end][pState]);
                        continue;
                    }
                    val = this.h_oScorePreU[start][end][0][this.finalLevel][0];
                    for (int level = this.finalLevel - 1; level >= 0; --level) {
                        this.h_oScorePreU[start][end][0][level][0] = val;
                    }
                }
                for (int cState = 0; cState < this.numSubStatesArray.length; ++cState) {
                    int childScale;
                    if (this.allowedSubStates[start][end][cState] == null) continue;
                    nChildStates = this.numSubStatesArray[cState];
                    UnaryRule[] rules = this.grammar.getClosedSumUnaryRulesByChild(cState);
                    boolean somethingChanged = false;
                    int scaleBeforeUnaries = childScale = this.oScale[start][end][cState];
                    for (int r = 0; r < rules.length; ++r) {
                        boolean changeThisRound;
                        HierarchicalAdaptiveUnaryRule ur = (HierarchicalAdaptiveUnaryRule)rules[r];
                        short pState2 = ur.parentState;
                        if (pState2 == cState || this.allowedSubStates[start][end][pState2] == null || !(changeThisRound = this.computeOutsideScore(start, end, ur, viterbi))) continue;
                        somethingChanged = true;
                        int currentScale = this.oScale[start][end][pState2];
                        if (childScale != (currentScale = ScalingTools.scaleArray(this.unscaledScoresToAdd, currentScale))) {
                            if (childScale == Integer.MIN_VALUE) {
                                childScale = currentScale;
                            } else {
                                int newScale = Math.max(currentScale, childScale);
                                ScalingTools.scaleArrayToScale(this.unscaledScoresToAdd, currentScale, newScale);
                                ScalingTools.scaleArrayToScale(this.h_oScorePostU[start][end][cState][this.finalLevel], childScale, newScale);
                                childScale = newScale;
                            }
                        }
                        for (int cp = 0; cp < nChildStates; ++cp) {
                            if (viterbi) {
                                this.h_oScorePostU[start][end][cState][this.finalLevel][cp] = Math.max(this.h_oScorePostU[start][end][cState][this.finalLevel][cp], this.unscaledScoresToAdd[cp]);
                                continue;
                            }
                            double[] dArray = this.h_oScorePostU[start][end][cState][this.finalLevel];
                            int n = cp;
                            dArray[n] = dArray[n] + this.unscaledScoresToAdd[cp];
                        }
                        Arrays.fill(this.unscaledScoresToAdd, initVal);
                    }
                    if (somethingChanged) {
                        int newScale = Math.max(scaleBeforeUnaries, childScale);
                        ScalingTools.scaleArrayToScale(this.h_oScorePreU[start][end][cState][this.finalLevel], scaleBeforeUnaries, newScale);
                        ScalingTools.scaleArrayToScale(this.h_oScorePostU[start][end][cState][this.finalLevel], childScale, newScale);
                        this.oScale[start][end][cState] = newScale;
                        if (newScale != scaleBeforeUnaries) {
                            this.updateHierarchy(this.h_oScorePreU[start][end][cState]);
                        }
                    }
                    for (int cp = 0; cp < nChildStates; ++cp) {
                        double val = this.h_oScorePreU[start][end][cState][this.finalLevel][cp];
                        if (!(val > 0.0)) continue;
                        if (viterbi) {
                            this.h_oScorePostU[start][end][cState][this.finalLevel][cp] = Math.max(this.h_oScorePostU[start][end][cState][this.finalLevel][cp], val);
                            continue;
                        }
                        double[] dArray = this.h_oScorePostU[start][end][cState][this.finalLevel];
                        int n = cp;
                        dArray[n] = dArray[n] + val;
                    }
                    if (cState != 0) {
                        this.updateHierarchy(this.h_oScorePostU[start][end][cState]);
                        continue;
                    }
                    double val = this.h_oScorePostU[start][end][0][this.finalLevel][0];
                    for (int level = this.finalLevel - 1; level >= 0; --level) {
                        this.h_oScorePostU[start][end][0][level][0] = val;
                    }
                }
                if (diff != 1) {
                    for (pState = 0; pState < this.numSubStatesArray.length; ++pState) {
                        if (this.allowedSubStates[start][end][pState] == null) continue;
                        BinaryRule[] rules = this.grammar.splitRulesWithP(pState);
                        for (int r = 0; r < rules.length; ++r) {
                            short rState;
                            int max1;
                            HierarchicalAdaptiveBinaryRule br = (HierarchicalAdaptiveBinaryRule)rules[r];
                            short lState = br.leftChildState;
                            int min1 = this.narrowRExtent[start][lState];
                            if (end < min1 || (max1 = this.narrowLExtent[end][rState = br.rightChildState]) < min1) continue;
                            int max = max1;
                            int min = min1;
                            if (max - min > 2) {
                                int min2 = this.wideLExtent[end][rState];
                                int n = min = min1 > min2 ? min1 : min2;
                                if (max1 < min) continue;
                                int max2 = this.wideRExtent[start][lState];
                                int n2 = max = max1 < max2 ? max1 : max2;
                                if (max < min) continue;
                            }
                            int nLeftChildStates = this.numSubStatesArray[lState];
                            short nRightChildStates = this.numSubStatesArray[rState];
                            for (int split = min; split <= max; ++split) {
                                int cp;
                                int newScale;
                                int currentScale;
                                boolean somethingChanged;
                                if (this.allowedSubStates[start][split][lState] == null || this.allowedSubStates[split][end][rState] == null || !(somethingChanged = this.computeOutsideScore(start, split, end, br, viterbi))) continue;
                                if (DoubleArrays.max(this.scoresToAdd) != 0.0) {
                                    int leftScale = this.oScale[start][split][lState];
                                    currentScale = this.oScale[start][end][pState] + this.iScale[split][end][rState];
                                    if (leftScale != (currentScale = ScalingTools.scaleArray(this.scoresToAdd, currentScale))) {
                                        if (leftScale == Integer.MIN_VALUE) {
                                            this.oScale[start][split][lState] = currentScale;
                                        } else {
                                            newScale = Math.max(currentScale, leftScale);
                                            ScalingTools.scaleArrayToScale(this.scoresToAdd, currentScale, newScale);
                                            ScalingTools.scaleArrayToScale(this.h_oScorePreU[start][split][lState][this.finalLevel], leftScale, newScale);
                                            this.oScale[start][split][lState] = newScale;
                                        }
                                    }
                                    for (cp = 0; cp < nLeftChildStates; ++cp) {
                                        if (!(this.scoresToAdd[cp] > initVal)) continue;
                                        if (viterbi) {
                                            this.h_oScorePreU[start][split][lState][this.finalLevel][cp] = Math.max(this.h_oScorePreU[start][split][lState][this.finalLevel][cp], this.scoresToAdd[cp]);
                                            continue;
                                        }
                                        double[] dArray = this.h_oScorePreU[start][split][lState][this.finalLevel];
                                        int n = cp;
                                        dArray[n] = dArray[n] + this.scoresToAdd[cp];
                                    }
                                    Arrays.fill(this.scoresToAdd, 0.0);
                                    this.updateHierarchy(this.h_oScorePreU[start][split][lState]);
                                }
                                if (DoubleArrays.max(this.unscaledScoresToAdd) == 0.0) continue;
                                int rightScale = this.oScale[split][end][rState];
                                currentScale = this.oScale[start][end][pState] + this.iScale[start][split][lState];
                                if (currentScale == Integer.MIN_VALUE) {
                                    System.out.println("shhaaa");
                                }
                                if (rightScale != (currentScale = ScalingTools.scaleArray(this.unscaledScoresToAdd, currentScale))) {
                                    if (rightScale == Integer.MIN_VALUE) {
                                        this.oScale[split][end][rState] = currentScale;
                                    } else {
                                        newScale = Math.max(currentScale, rightScale);
                                        ScalingTools.scaleArrayToScale(this.unscaledScoresToAdd, currentScale, newScale);
                                        ScalingTools.scaleArrayToScale(this.h_oScorePreU[split][end][rState][this.finalLevel], rightScale, newScale);
                                        this.oScale[split][end][rState] = newScale;
                                    }
                                }
                                for (cp = 0; cp < nRightChildStates; ++cp) {
                                    if (!(this.unscaledScoresToAdd[cp] > initVal)) continue;
                                    if (viterbi) {
                                        this.h_oScorePreU[split][end][rState][this.finalLevel][cp] = Math.max(this.h_oScorePreU[split][end][rState][this.finalLevel][cp], this.unscaledScoresToAdd[cp]);
                                        continue;
                                    }
                                    double[] dArray = this.h_oScorePreU[split][end][rState][this.finalLevel];
                                    int n = cp;
                                    dArray[n] = dArray[n] + this.unscaledScoresToAdd[cp];
                                }
                                Arrays.fill(this.unscaledScoresToAdd, 0.0);
                                this.updateHierarchy(this.h_oScorePreU[split][end][rState]);
                            }
                        }
                    }
                }
                ++start;
            }
        }
    }

    private final boolean computeOutsideScore(int start, int split, int end, HierarchicalAdaptiveBinaryRule rule, boolean viterbi) {
        short pState = rule.parentState;
        short lState = rule.leftChildState;
        short rState = rule.rightChildState;
        boolean changeThisRound = false;
        for (HierarchicalAdaptiveBinaryRule.SubRule subRule : rule.subRuleList) {
            int k;
            short level;
            double oS;
            if (subRule == null || (oS = this.h_oScorePostU[start][end][pState][level = subRule.level][subRule.parent]) == 0.0) continue;
            double lS = this.h_iScorePostU[start][split][lState][level][subRule.lChild];
            double rS = this.h_iScorePostU[split][end][rState][level][subRule.rChild];
            double pS = subRule.score;
            double thisRoundL = pS * rS * oS;
            double thisRoundR = pS * lS * oS;
            if (thisRoundL != 0.0) {
                k = this.substatesToCover[level] * subRule.lChild;
                int l = k + this.substatesToCover[level];
                for (int lp = k; lp < l; ++lp) {
                    if (!this.allowedSubStates[start][split][lState][lp]) continue;
                    if (viterbi) {
                        this.scoresToAdd[lp] = Math.max(this.scoresToAdd[lp], thisRoundL);
                    } else {
                        int n = lp;
                        this.scoresToAdd[n] = this.scoresToAdd[n] + thisRoundL;
                    }
                    changeThisRound = true;
                }
            }
            if (thisRoundR == 0.0) continue;
            k = this.substatesToCover[level] * subRule.rChild;
            int m = k + this.substatesToCover[level];
            for (int rp = k; rp < m; ++rp) {
                if (!this.allowedSubStates[split][end][rState][rp]) continue;
                if (viterbi) {
                    this.unscaledScoresToAdd[rp] = Math.max(this.unscaledScoresToAdd[rp], thisRoundR);
                } else {
                    int n = rp;
                    this.unscaledScoresToAdd[n] = this.unscaledScoresToAdd[n] + thisRoundR;
                }
                changeThisRound = true;
            }
        }
        return changeThisRound;
    }

    private final boolean computeOutsideScore(int start, int end, HierarchicalAdaptiveUnaryRule rule, boolean viterbi) {
        short pState = rule.parentState;
        short cState = rule.childState;
        boolean changeThisRound = false;
        for (HierarchicalAdaptiveUnaryRule.SubRule subRule : rule.subRuleList) {
            short level;
            double pS;
            if (subRule == null || (pS = this.h_oScorePreU[start][end][pState][level = subRule.level][subRule.parent]) == 0.0) continue;
            double score = pS * subRule.score;
            int k = this.substatesToCover[level] * subRule.child;
            int l = k + this.substatesToCover[level];
            for (int np = k; np < l; ++np) {
                if (!this.allowedSubStates[start][end][cState][np]) continue;
                if (viterbi) {
                    this.unscaledScoresToAdd[np] = Math.max(this.unscaledScoresToAdd[np], score);
                } else {
                    int n = np;
                    this.unscaledScoresToAdd[n] = this.unscaledScoresToAdd[n] + score;
                }
                changeThisRound = true;
            }
        }
        return changeThisRound;
    }

    @Override
    void initializeChart(List<StateSet> sentence, boolean noSmoothing, List<String> posTags) {
        boolean useGoldPOS = posTags != null;
        int start = 0;
        int end = start + 1;
        for (StateSet word : sentence) {
            end = start + 1;
            short goldTag = -1;
            if (useGoldPOS) {
                goldTag = this.tagNumberer.number(posTags.get(start));
            }
            for (short tag = 0; tag < this.numSubStatesArray.length; tag = (short)((short)(tag + 1))) {
                if (this.grammarTags[tag] || this.allowedSubStates[start][end][tag] == null || useGoldPOS && tag != goldTag) continue;
                this.narrowRExtent[start][tag] = end;
                this.narrowLExtent[end][tag] = start;
                this.wideRExtent[start][tag] = end;
                this.wideLExtent[end][tag] = start;
                double[] lexiconScores = this.lexicon.score(word, tag, noSmoothing, false);
                this.iScale[start][end][tag] = 0;
                for (int n = 0; n < lexiconScores.length; n = (int)((short)(n + 1))) {
                    double prob;
                    this.h_iScorePreU[start][end][tag][this.finalLevel][n] = prob = lexiconScores[n];
                }
                this.updateHierarchy(this.h_iScorePreU[start][end][tag]);
            }
            ++start;
        }
    }

    @Override
    protected void createArrays() {
        if (this.arraySize < this.length) {
            this.arraySize = this.length;
            this.h_iScorePreU = new double[this.length][this.length + 1][][][];
            this.h_iScorePostU = new double[this.length][this.length + 1][][][];
            this.h_oScorePreU = new double[this.length][this.length + 1][][][];
            this.h_oScorePostU = new double[this.length][this.length + 1][][][];
            this.iScale = new int[this.length][this.length + 1][];
            this.oScale = new int[this.length][this.length + 1][];
            for (int start = 0; start < this.length; ++start) {
                for (int end = start + 1; end <= this.length; ++end) {
                    this.h_iScorePreU[start][end] = new double[this.numStates][this.finalLevel + 1][];
                    this.h_iScorePostU[start][end] = new double[this.numStates][this.finalLevel + 1][];
                    this.h_oScorePreU[start][end] = new double[this.numStates][this.finalLevel + 1][];
                    this.h_oScorePostU[start][end] = new double[this.numStates][this.finalLevel + 1][];
                    this.iScale[start][end] = new int[this.numStates];
                    this.oScale[start][end] = new int[this.numStates];
                    Arrays.fill(this.iScale[start][end], Integer.MIN_VALUE);
                    Arrays.fill(this.oScale[start][end], Integer.MIN_VALUE);
                    for (int state = 0; state < this.numSubStatesArray.length; ++state) {
                        if (end - start > 1 && !this.grammarTags[state]) continue;
                        for (int level = 0; level <= this.finalLevel; ++level) {
                            this.h_iScorePreU[start][end][state][level] = new double[this.numSubStatesArray[state] / this.substatesToCover[level]];
                            this.h_iScorePostU[start][end][state][level] = new double[this.numSubStatesArray[state] / this.substatesToCover[level]];
                            this.h_oScorePreU[start][end][state][level] = new double[this.numSubStatesArray[state] / this.substatesToCover[level]];
                            this.h_oScorePostU[start][end][state][level] = new double[this.numSubStatesArray[state] / this.substatesToCover[level]];
                        }
                    }
                    for (int level = 0; level <= this.finalLevel; ++level) {
                        this.h_oScorePreU[start][end][0][level] = new double[1];
                        this.h_oScorePostU[start][end][0][level] = new double[1];
                    }
                }
            }
            this.narrowRExtent = new int[this.length + 1][this.numStates];
            this.wideRExtent = new int[this.length + 1][this.numStates];
            this.narrowLExtent = new int[this.length + 1][this.numStates];
            this.wideLExtent = new int[this.length + 1][this.numStates];
            for (int loc = 0; loc <= this.length; ++loc) {
                Arrays.fill(this.narrowLExtent[loc], -1);
                Arrays.fill(this.wideLExtent[loc], this.length + 1);
                Arrays.fill(this.narrowRExtent[loc], this.length + 1);
                Arrays.fill(this.wideRExtent[loc], -1);
            }
        }
    }

    @Override
    protected void scrubArrays() {
        if (this.h_iScorePostU == null) {
            return;
        }
        for (int start = 0; start < this.length; ++start) {
            for (int end = start + 1; end <= this.length; ++end) {
                for (int state = 0; state < this.numSubStatesArray.length; ++state) {
                    if (this.allowedSubStates[start][end][state] == null || end - start > 1 && !this.grammarTags[state]) continue;
                    for (int level = 0; level <= this.finalLevel; ++level) {
                        Arrays.fill(this.h_iScorePreU[start][end][state][level], 0.0);
                        Arrays.fill(this.h_iScorePostU[start][end][state][level], 0.0);
                        Arrays.fill(this.h_oScorePreU[start][end][state][level], 0.0);
                        Arrays.fill(this.h_oScorePostU[start][end][state][level], 0.0);
                    }
                    Arrays.fill(this.iScale[start][end], Integer.MIN_VALUE);
                    Arrays.fill(this.oScale[start][end], Integer.MIN_VALUE);
                }
            }
        }
        for (int loc = 0; loc <= this.length; ++loc) {
            Arrays.fill(this.narrowLExtent[loc], -1);
            Arrays.fill(this.wideLExtent[loc], this.length + 1);
            Arrays.fill(this.narrowRExtent[loc], this.length + 1);
            Arrays.fill(this.wideRExtent[loc], -1);
        }
    }

    @Override
    protected double getLikelihoodAndSetRootOutsideScore() {
        for (int level = 0; level <= this.finalLevel; ++level) {
            this.h_oScorePreU[0][this.length][0][level][0] = 1.0;
        }
        this.oScale[0][this.length][0] = 0;
        return Math.log(this.h_iScorePostU[0][this.length][0][this.finalLevel][0]) + (double)(100 * this.iScale[0][this.length][0]);
    }

    @Override
    void doConstrainedMaxCScores(List<StateSet> sentence) {
        this.doConstrainedMaxCScores(sentence, null);
    }

    @Override
    void doConstrainedMaxCScores(List<StateSet> sentence, double[][][] spanScores) {
        this.maxcScore = new double[this.length][this.length + 1][this.numStates];
        this.maxcSplit = new int[this.length][this.length + 1][this.numStates];
        this.maxcChild = new int[this.length][this.length + 1][this.numStates];
        this.maxcLeftChild = new int[this.length][this.length + 1][this.numStates];
        this.maxcRightChild = new int[this.length][this.length + 1][this.numStates];
        double tree_score = this.h_iScorePostU[0][this.length][0][this.finalLevel][0];
        int tree_scale = this.iScale[0][this.length][0];
        for (int diff = 1; diff <= this.length; ++diff) {
            for (int start = 0; start < this.length - diff + 1; ++start) {
                int end = start + diff;
                Arrays.fill(this.maxcSplit[start][end], -1);
                Arrays.fill(this.maxcChild[start][end], -1);
                Arrays.fill(this.maxcLeftChild[start][end], -1);
                Arrays.fill(this.maxcRightChild[start][end], -1);
                if (diff > 1) {
                    for (int pState = 0; pState < this.numSubStatesArray.length; ++pState) {
                        if (this.allowedSubStates[start][end][pState] == null) continue;
                        BinaryRule[] parentRules = this.grammar.splitRulesWithP(pState);
                        for (int i = 0; i < parentRules.length; ++i) {
                            int max;
                            int min;
                            boolean iPossibleR;
                            boolean iPossibleL;
                            HierarchicalAdaptiveBinaryRule r = (HierarchicalAdaptiveBinaryRule)parentRules[i];
                            short lState = r.leftChildState;
                            short rState = r.rightChildState;
                            int narrowR = this.narrowRExtent[start][lState];
                            boolean bl = iPossibleL = narrowR < end;
                            if (!iPossibleL) continue;
                            int narrowL = this.narrowLExtent[end][rState];
                            boolean bl2 = iPossibleR = narrowL >= narrowR;
                            if (!iPossibleR) continue;
                            int min1 = narrowR;
                            int min2 = this.wideLExtent[end][rState];
                            int n = min = min1 > min2 ? min1 : min2;
                            if (min > narrowL) continue;
                            int max1 = this.wideRExtent[start][lState];
                            int max2 = narrowL;
                            int n2 = max = max1 < max2 ? max1 : max2;
                            if (min > max) continue;
                            for (int split = min; split <= max; ++split) {
                                double rightChildScore;
                                double leftChildScore;
                                double gScore;
                                double ruleScore;
                                double scalingFactor;
                                if (this.allowedSubStates[start][split][lState] == null || this.allowedSubStates[split][end][rState] == null || (scalingFactor = ScalingTools.calcScaleFactor(this.oScale[start][end][pState] + this.iScale[start][split][lState] + this.iScale[split][end][rState] - tree_scale)) == 0.0 || (ruleScore = this.computeRuleScore(start, split, end, r, tree_score, scalingFactor)) == 0.0 || !((gScore = ruleScore * (leftChildScore = this.maxcScore[start][split][lState]) * (rightChildScore = this.maxcScore[split][end][rState])) > this.maxcScore[start][end][pState])) continue;
                                this.maxcScore[start][end][pState] = gScore;
                                this.maxcSplit[start][end][pState] = split;
                                this.maxcLeftChild[start][end][pState] = lState;
                                this.maxcRightChild[start][end][pState] = rState;
                            }
                        }
                    }
                } else {
                    for (int tag = 0; tag < this.numSubStatesArray.length; tag = (int)((short)(tag + 1))) {
                        double scalingFactor;
                        if (this.allowedSubStates[start][end][tag] == null || this.grammar.isGrammarTag(tag) || (scalingFactor = ScalingTools.calcScaleFactor(this.oScale[start][end][tag] - tree_scale)) == 0.0) continue;
                        int nTagStates = this.numSubStatesArray[tag];
                        double[] lexiconScoreArray = this.h_iScorePreU[start][end][tag][this.finalLevel];
                        double lexiconScores = 0.0;
                        for (int tp = 0; tp < nTagStates; ++tp) {
                            double ruleS;
                            double pOS = this.h_oScorePostU[start][end][tag][this.finalLevel][tp];
                            if (pOS == 0.0 || (ruleS = lexiconScoreArray[tp]) == 0.0) continue;
                            lexiconScores += pOS * ruleS / tree_score;
                        }
                        if (lexiconScores == 0.0) continue;
                        this.maxcScore[start][end][tag] = lexiconScores * scalingFactor;
                    }
                }
                double[] maxcScoreStartEnd = new double[this.numStates];
                for (int i = 0; i < this.numStates; ++i) {
                    maxcScoreStartEnd[i] = this.maxcScore[start][end][i];
                }
                for (int pState = 0; pState < this.numSubStatesArray.length; ++pState) {
                    if (this.allowedSubStates[start][end][pState] == null) continue;
                    double spanScore = spanScores != null ? spanScores[start][end][this.stateClass[pState]] : 1.0;
                    UnaryRule[] unaries = this.grammar.getClosedSumUnaryRulesByParent(pState);
                    for (int r = 0; r < unaries.length; ++r) {
                        double childScore;
                        double gScore;
                        double ruleScore;
                        double scalingFactor;
                        HierarchicalAdaptiveUnaryRule ur = (HierarchicalAdaptiveUnaryRule)unaries[r];
                        short cState = ur.childState;
                        if (pState == cState || this.allowedSubStates[start][end][cState] == null || (scalingFactor = ScalingTools.calcScaleFactor(this.oScale[start][end][pState] + this.iScale[start][end][cState] - tree_scale)) == 0.0 || (ruleScore = this.computeRuleScore(start, end, ur, tree_score, scalingFactor, spanScore)) == 0.0 || !((gScore = ruleScore * (childScore = this.maxcScore[start][end][cState])) > maxcScoreStartEnd[pState])) continue;
                        maxcScoreStartEnd[pState] = gScore;
                        this.maxcChild[start][end][pState] = cState;
                    }
                }
                this.maxcScore[start][end] = maxcScoreStartEnd;
            }
        }
    }

    private final double computeRuleScore(int start, int split, int end, HierarchicalAdaptiveBinaryRule rule, double tree_score, double scalingFactor) {
        double ruleScore = 0.0;
        short pState = rule.parentState;
        short lState = rule.leftChildState;
        short rState = rule.rightChildState;
        for (HierarchicalAdaptiveBinaryRule.SubRule subRule : rule.subRuleList) {
            double pOS;
            double rS;
            short level = subRule.level;
            double lS = this.h_iScorePostU[start][split][lState][level][subRule.lChild];
            if (lS == 0.0 || (rS = this.h_iScorePostU[split][end][rState][level][subRule.rChild]) == 0.0 || (pOS = this.h_oScorePostU[start][end][pState][level][subRule.parent]) == 0.0) continue;
            ruleScore += subRule.score * lS / tree_score * rS * scalingFactor * pOS;
        }
        return ruleScore;
    }

    private final double computeRuleScore(int start, int end, HierarchicalAdaptiveUnaryRule rule, double tree_score, double scalingFactor, double spanScore) {
        double ruleScore = 0.0;
        short pState = rule.parentState;
        short cState = rule.childState;
        for (HierarchicalAdaptiveUnaryRule.SubRule subRule : rule.subRuleList) {
            double pOS;
            short level;
            double cS;
            if (subRule == null || (cS = this.h_iScorePreU[start][end][cState][level = subRule.level][subRule.child]) == 0.0 || (pOS = this.h_oScorePreU[start][end][pState][level][subRule.parent]) == 0.0) continue;
            ruleScore += subRule.score * cS / tree_score * scalingFactor / spanScore * pOS;
        }
        return ruleScore;
    }

    @Override
    public void incrementExpectedCounts(Linearizer linearizer, double[] probs, List<StateSet> sentence) {
        double tree_score = this.h_iScorePostU[0][this.length][0][this.finalLevel][0];
        int tree_scale = this.iScale[0][this.length][0];
        if (ConditionalTrainer.Options.lockGrammar) {
            linearizer.increment(probs, sentence, this.getClassBracketPosteriors(), false);
            return;
        }
        for (int start = 0; start < this.length; ++start) {
            int lastState = this.numSubStatesArray.length;
            StateSet currentStateSet = sentence.get(start);
            for (int tag = 0; tag < lastState; ++tag) {
                double scalingFactor;
                if (this.grammar.isGrammarTag(tag) || this.allowedSubStates[start][start + 1][tag] == null || (scalingFactor = ScalingTools.calcScaleFactor(this.oScale[start][start + 1][tag] + this.iScale[start][start + 1][tag] - tree_scale)) == 0.0) continue;
                short nSubStates = this.numSubStatesArray[tag];
                for (short substate = 0; substate < nSubStates; substate = (short)(substate + 1)) {
                    double weight;
                    double oS;
                    double iS = this.h_iScorePreU[start][start + 1][tag][this.finalLevel][substate];
                    if (iS == 0.0 || (oS = this.h_oScorePostU[start][start + 1][tag][this.finalLevel][substate]) == 0.0 || !this.isValidExpectation(weight = iS / tree_score * scalingFactor * oS)) continue;
                    this.tmpCountsArray[substate] = weight;
                }
                linearizer.increment(probs, currentStateSet, tag, this.tmpCountsArray, false);
            }
        }
        for (int diff = 1; diff <= this.length; ++diff) {
            for (int start = 0; start < this.length - diff + 1; ++start) {
                int end = start + diff;
                int lastState = this.numSubStatesArray.length;
                for (int pState = 0; pState < lastState; pState = (int)((short)(pState + 1))) {
                    if (diff == 1 || this.allowedSubStates[start][end][pState] == null) continue;
                    BinaryRule[] parentRules = this.grammar.splitRulesWithP(pState);
                    for (int i = 0; i < parentRules.length; ++i) {
                        int max;
                        int min;
                        boolean iPossibleR;
                        boolean iPossibleL;
                        HierarchicalAdaptiveBinaryRule r = (HierarchicalAdaptiveBinaryRule)parentRules[i];
                        short lState = r.leftChildState;
                        short rState = r.rightChildState;
                        int narrowR = this.narrowRExtent[start][lState];
                        boolean bl = iPossibleL = narrowR < end;
                        if (!iPossibleL) continue;
                        int narrowL = this.narrowLExtent[end][rState];
                        boolean bl2 = iPossibleR = narrowL >= narrowR;
                        if (!iPossibleR) continue;
                        int min1 = narrowR;
                        int min2 = this.wideLExtent[end][rState];
                        int n = min = min1 > min2 ? min1 : min2;
                        if (min > narrowL) continue;
                        int max1 = this.wideRExtent[start][lState];
                        int max2 = narrowL;
                        int n2 = max = max1 < max2 ? max1 : max2;
                        if (min > max) continue;
                        boolean foundSomething = false;
                        for (int split = min; split <= max; ++split) {
                            double scalingFactor;
                            if (this.allowedSubStates[start][split][lState] == null || this.allowedSubStates[split][end][rState] == null || (scalingFactor = ScalingTools.calcScaleFactor(this.oScale[start][end][pState] + this.iScale[start][split][lState] + this.iScale[split][end][rState] - tree_scale)) == 0.0) continue;
                            boolean tmp = this.computeExpectedCount(start, split, end, r, tree_score, scalingFactor);
                            foundSomething = foundSomething || tmp;
                        }
                        if (!foundSomething) continue;
                        linearizer.increment(probs, r, this.tmpCountsArray, false);
                    }
                }
                int lastStateU = this.numSubStatesArray.length;
                for (int pState = 0; pState < lastStateU; pState = (int)((short)(pState + 1))) {
                    UnaryRule[] unaries;
                    if (this.allowedSubStates[start][end][pState] == null) continue;
                    for (UnaryRule ur : unaries = this.grammar.getClosedSumUnaryRulesByParent(pState)) {
                        boolean foundSomething;
                        double scalingFactor;
                        short cState = ur.childState;
                        if (pState == cState || this.allowedSubStates[start][end][cState] == null || (scalingFactor = ScalingTools.calcScaleFactor(this.oScale[start][end][pState] + this.iScale[start][end][cState] - tree_scale)) == 0.0 || !(foundSomething = this.computeExpectedCount(start, end, (HierarchicalAdaptiveUnaryRule)ur, tree_score, scalingFactor))) continue;
                        linearizer.increment(probs, ur, this.tmpCountsArray, false);
                    }
                }
            }
        }
        if (this.spanPredictor != null) {
            linearizer.increment(probs, sentence, this.getClassBracketPosteriors(), false);
        }
    }

    private final boolean computeExpectedCount(int start, int split, int end, HierarchicalAdaptiveBinaryRule rule, double tree_score, double scalingFactor) {
        short pState = rule.parentState;
        short lState = rule.leftChildState;
        short rState = rule.rightChildState;
        boolean foundSomething = false;
        int curInd = -1;
        for (HierarchicalAdaptiveBinaryRule.SubRule subRule : rule.subRuleList) {
            double ruleCount;
            double pOS;
            double rS;
            if (subRule == null) continue;
            short level = subRule.level;
            ++curInd;
            double lS = this.h_iScorePostU[start][split][lState][level][subRule.lChild];
            if (lS == 0.0 || (rS = this.h_iScorePostU[split][end][rState][level][subRule.rChild]) == 0.0 || (pOS = this.h_oScorePostU[start][end][pState][level][subRule.parent]) == 0.0 || !this.isValidExpectation(ruleCount = subRule.score * lS / tree_score * rS * scalingFactor * pOS)) continue;
            int n = curInd;
            this.tmpCountsArray[n] = this.tmpCountsArray[n] + ruleCount;
            foundSomething = true;
        }
        return foundSomething;
    }

    private final boolean computeExpectedCount(int start, int end, HierarchicalAdaptiveUnaryRule rule, double tree_score, double scalingFactor) {
        short pState = rule.parentState;
        short cState = rule.childState;
        boolean foundSomething = false;
        int curInd = -1;
        for (HierarchicalAdaptiveUnaryRule.SubRule subRule : rule.subRuleList) {
            double pOS;
            short level;
            double cS;
            ++curInd;
            if (subRule == null || (cS = this.h_iScorePreU[start][end][cState][level = subRule.level][subRule.child]) == 0.0 || (pOS = this.h_oScorePreU[start][end][pState][level][subRule.parent]) == 0.0) continue;
            double ruleCount = subRule.score * cS / tree_score * scalingFactor * pOS;
            if (this.spanScores != null) {
                ruleCount /= this.spanScores[start][end][this.stateClass[pState]];
            }
            if (!this.isValidExpectation(ruleCount)) continue;
            this.tmpCountsArray[curInd] = ruleCount;
            foundSomething = true;
        }
        return foundSomething;
    }

    @Override
    boolean[][][][] computeAllowedStates(double threshold) {
        double tree_score = this.h_iScorePostU[0][this.length][0][this.finalLevel][0];
        int tree_scale = this.iScale[0][this.length][0];
        boolean[][][][] result = new boolean[this.length][this.length + 1][][];
        for (int start = 0; start < this.length; ++start) {
            for (int end = start + 1; end <= this.length; ++end) {
                result[start][end] = new boolean[this.numStates][];
                int lastState = this.numSubStatesArray.length;
                for (int state = 0; state < lastState; ++state) {
                    double spanScore;
                    double d = spanScore = this.spanScores != null ? this.spanScores[start][end][this.stateClass[state]] : 1.0;
                    if (this.allowedSubStates[start][end][state] == null) continue;
                    boolean atLeastOnePossible = false;
                    for (int substate = 0; substate < this.numSubStatesArray[state]; ++substate) {
                        double tmp;
                        double posterior;
                        if (!this.allowedSubStates[start][end][state][substate]) continue;
                        double iS = this.h_iScorePostU[start][end][state][this.finalLevel][substate];
                        double oS = this.h_oScorePostU[start][end][state][this.finalLevel][substate];
                        double scalingFactor = ScalingTools.calcScaleFactor(this.oScale[start][end][state] + this.iScale[start][end][state] - tree_scale);
                        if (scalingFactor == 0.0 || !((posterior = (tmp = Math.max(iS * this.h_oScorePreU[start][end][state][this.finalLevel][substate], this.h_iScorePreU[start][end][state][this.finalLevel][substate] * oS)) / spanScore / tree_score * scalingFactor) > threshold)) continue;
                        if (result[start][end][state] == null) {
                            result[start][end][state] = new boolean[this.numSubStatesArray[state]];
                        }
                        result[start][end][state][substate] = true;
                        atLeastOnePossible = true;
                    }
                    if (atLeastOnePossible) continue;
                    result[start][end][state] = null;
                }
            }
        }
        return result;
    }

    @Override
    void doInsideScores(Tree<StateSet> tree, boolean noSmoothing, boolean debugOutput, double[][][] spanScores) {
        if (this.grammar.isLogarithmMode() || this.lexicon.isLogarithmMode()) {
            throw new Error("Grammar in logarithm mode!  Cannot do inside scores!");
        }
        if (tree.isLeaf()) {
            return;
        }
        List<Tree<StateSet>> children = tree.getChildren();
        for (Tree<StateSet> child : children) {
            if (child.isLeaf()) continue;
            this.doInsideScores(child, noSmoothing, debugOutput, spanScores);
        }
        StateSet parent = tree.getLabel();
        short pState = parent.getState();
        int nParentStates = parent.numSubStates();
        if (tree.isPreTerminal()) {
            StateSet wordStateSet = tree.getChildren().get(0).getLabel();
            double[] lexiconScores = this.lexicon.score(wordStateSet, pState, noSmoothing, false);
            if (lexiconScores.length != nParentStates) {
                System.out.println("Have more scores than substates!");
            }
            parent.setIScores(lexiconScores);
            parent.scaleIScores(0);
        } else {
            switch (children.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    StateSet child = children.get(0).getLabel();
                    short cState = child.getState();
                    HierarchicalAdaptiveUnaryRule urule = (HierarchicalAdaptiveUnaryRule)this.grammar.getUnaryRule(pState, cState);
                    double[] iScores = new double[nParentStates];
                    for (HierarchicalAdaptiveUnaryRule.SubRule subRule : urule.subRuleList) {
                        if (subRule == null) continue;
                        short level = subRule.level;
                        int i = this.substatesToCover[level] * subRule.child;
                        int j = i + this.substatesToCover[level];
                        int k = this.substatesToCover[level] * subRule.parent;
                        int l = k + this.substatesToCover[level];
                        double cS = 0.0;
                        for (int cp = i; cp < j; ++cp) {
                            cS += child.getIScore(cp);
                        }
                        if (pState == 0) {
                            l = 1;
                        }
                        int np = k;
                        while (np < l) {
                            double score = cS * subRule.score;
                            int n = np++;
                            iScores[n] = iScores[n] + score;
                        }
                    }
                    parent.setIScores(iScores);
                    parent.scaleIScores(child.getIScale());
                    break;
                }
                case 2: {
                    StateSet leftChild = children.get(0).getLabel();
                    StateSet rightChild = children.get(1).getLabel();
                    short lState = leftChild.getState();
                    short rState = rightChild.getState();
                    double[] iScores2 = new double[nParentStates];
                    HierarchicalAdaptiveBinaryRule brule = (HierarchicalAdaptiveBinaryRule)this.grammar.getBinaryRule(pState, lState, rState);
                    for (HierarchicalAdaptiveBinaryRule.SubRule subRule : brule.subRuleList) {
                        if (subRule == null) continue;
                        short level = subRule.level;
                        int e = this.substatesToCover[level] * subRule.lChild;
                        int f = e + this.substatesToCover[level];
                        int i = this.substatesToCover[level] * subRule.rChild;
                        int j = i + this.substatesToCover[level];
                        int k = this.substatesToCover[level] * subRule.parent;
                        int l = k + this.substatesToCover[level];
                        double lS = 0.0;
                        for (int lp = e; lp < f; ++lp) {
                            lS += leftChild.getIScore(lp);
                        }
                        double rS = 0.0;
                        for (int rp = i; rp < j; ++rp) {
                            rS += rightChild.getIScore(rp);
                        }
                        int np = k;
                        while (np < l) {
                            double score = lS * rS * subRule.score;
                            int n = np++;
                            iScores2[n] = iScores2[n] + score;
                        }
                    }
                    if (spanScores != null) {
                        int i = 0;
                        while (i < nParentStates) {
                            int n = i++;
                            iScores2[n] = iScores2[n] * spanScores[parent.from][parent.to][this.stateClass[pState]];
                        }
                    }
                    parent.setIScores(iScores2);
                    parent.scaleIScores(leftChild.getIScale() + rightChild.getIScale());
                    break;
                }
                default: {
                    throw new Error("Malformed tree: more than two children");
                }
            }
        }
    }

    @Override
    void setRootOutsideScore(Tree<StateSet> tree) {
        tree.getLabel().setOScore(0, 1.0);
        tree.getLabel().setOScale(0);
    }

    @Override
    void doOutsideScores(Tree<StateSet> tree, boolean unaryAbove, double[][][] spanScores) {
        if (this.grammar.isLogarithmMode() || this.lexicon.isLogarithmMode()) {
            throw new Error("Grammar in logarithm mode!  Cannot do inside scores!");
        }
        if (tree.isLeaf()) {
            return;
        }
        List<Tree<StateSet>> children = tree.getChildren();
        StateSet parent = tree.getLabel();
        short pState = parent.getState();
        int nParentStates = parent.numSubStates();
        if (!tree.isPreTerminal()) {
            double[] parentScores = parent.getOScores();
            if (spanScores != null && !unaryAbove) {
                int i = 0;
                while (i < nParentStates) {
                    int n = i++;
                    parentScores[n] = parentScores[n] * spanScores[parent.from][parent.to][this.stateClass[pState]];
                }
            }
            switch (children.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    StateSet child = children.get(0).getLabel();
                    short cState = child.getState();
                    int nChildStates = child.numSubStates();
                    double[] oScores = new double[nChildStates];
                    HierarchicalAdaptiveUnaryRule urule = (HierarchicalAdaptiveUnaryRule)this.grammar.getUnaryRule(pState, cState);
                    for (HierarchicalAdaptiveUnaryRule.SubRule subRule : urule.subRuleList) {
                        if (subRule == null) continue;
                        short level = subRule.level;
                        int i = this.substatesToCover[level] * subRule.child;
                        int j = i + this.substatesToCover[level];
                        int k = this.substatesToCover[level] * subRule.parent;
                        int l = k + this.substatesToCover[level];
                        if (pState == 0) {
                            l = 1;
                        }
                        double pS = 0.0;
                        for (int np = k; np < l; ++np) {
                            pS += parent.getOScore(np);
                        }
                        int cp = i;
                        while (cp < j) {
                            double score = pS * subRule.score;
                            int n = cp++;
                            oScores[n] = oScores[n] + score;
                        }
                    }
                    child.setOScores(oScores);
                    child.scaleOScores(parent.getOScale());
                    unaryAbove = true;
                    break;
                }
                case 2: {
                    StateSet leftChild = children.get(0).getLabel();
                    StateSet rightChild = children.get(1).getLabel();
                    int nLeftChildStates = leftChild.numSubStates();
                    int nRightChildStates = rightChild.numSubStates();
                    short lState = leftChild.getState();
                    short rState = rightChild.getState();
                    double[] lOScores = new double[nLeftChildStates];
                    double[] rOScores = new double[nRightChildStates];
                    HierarchicalAdaptiveBinaryRule brule = (HierarchicalAdaptiveBinaryRule)this.grammar.getBinaryRule(pState, lState, rState);
                    for (HierarchicalAdaptiveBinaryRule.SubRule subRule : brule.subRuleList) {
                        if (subRule == null) continue;
                        short level = subRule.level;
                        int e = this.substatesToCover[level] * subRule.lChild;
                        int f = e + this.substatesToCover[level];
                        int i = this.substatesToCover[level] * subRule.rChild;
                        int j = i + this.substatesToCover[level];
                        int k = this.substatesToCover[level] * subRule.parent;
                        int l = k + this.substatesToCover[level];
                        double lcS = 0.0;
                        for (int lp = e; lp < f; ++lp) {
                            lcS += leftChild.getIScore(lp);
                        }
                        double rcS = 0.0;
                        for (int rp = i; rp < j; ++rp) {
                            rcS += rightChild.getIScore(rp);
                        }
                        double pS = 0.0;
                        for (int np = k; np < l; ++np) {
                            pS += parent.getOScore(np);
                        }
                        double leftScore = pS * subRule.score * rcS;
                        int lp = e;
                        while (lp < f) {
                            int n = lp++;
                            lOScores[n] = lOScores[n] + leftScore;
                        }
                        double rightScore = pS * subRule.score * lcS;
                        int rp = i;
                        while (rp < j) {
                            int n = rp++;
                            rOScores[n] = rOScores[n] + rightScore;
                        }
                    }
                    leftChild.setOScores(lOScores);
                    leftChild.scaleOScores(parent.getOScale() + rightChild.getIScale());
                    rightChild.setOScores(rOScores);
                    rightChild.scaleOScores(parent.getOScale() + leftChild.getIScale());
                    unaryAbove = false;
                    break;
                }
                default: {
                    throw new Error("Malformed tree: more than two children");
                }
            }
            for (Tree<StateSet> child : children) {
                this.doOutsideScores(child, unaryAbove, spanScores);
            }
        }
    }

    @Override
    public double doInsideOutsideScores(Tree<StateSet> tree, boolean noSmoothing, boolean debugOutput, double[][][] spanScores) {
        this.doInsideScores(tree, noSmoothing, debugOutput, spanScores);
        this.setRootOutsideScore(tree);
        this.doOutsideScores(tree, false, spanScores);
        return Math.log(tree.getLabel().getIScore(0)) + (double)(100 * tree.getLabel().getIScale());
    }

    @Override
    public void doInsideOutsideScores(Tree<StateSet> tree, boolean noSmoothing, boolean debugOutput) {
        this.doInsideScores(tree, noSmoothing, debugOutput, null);
        this.setRootOutsideScore(tree);
        this.doOutsideScores(tree, false, null);
    }

    @Override
    public void incrementExpectedGoldCounts(Linearizer linearizer, double[] probs, Tree<StateSet> tree) {
        if (ConditionalTrainer.Options.lockGrammar) {
            return;
        }
        this.incrementExpectedGoldCounts(linearizer, probs, tree, tree.getLabel().getIScore(0), tree.getLabel().getIScale());
    }

    @Override
    public void incrementExpectedGoldCounts(Linearizer linearizer, double[] probs, Tree<StateSet> tree, double tree_score, int tree_scale) {
        if (tree.isLeaf()) {
            return;
        }
        if (tree.isPreTerminal()) {
            StateSet parent = tree.getLabel();
            StateSet child = tree.getChildren().get(0).getLabel();
            short tag = tree.getLabel().getState();
            short nSubStates = this.grammar.numSubStates[tag];
            double scalingFactor = ScalingTools.calcScaleFactor(parent.getOScale() + parent.getIScale() - tree_scale);
            for (short substate = 0; substate < nSubStates; substate = (short)(substate + 1)) {
                double pOS;
                double pIS = parent.getIScore(substate);
                if (pIS == 0.0 || (pOS = parent.getOScore(substate)) == 0.0) continue;
                double weight = 1.0;
                weight = pIS / tree_score * scalingFactor * pOS;
                if (this.isValidExpectation(weight)) {
                    this.tmpCountsArray[substate] = weight;
                    continue;
                }
                System.out.println("Overflow when counting gold tags? " + weight);
            }
            linearizer.increment(probs, child, tag, this.tmpCountsArray, true);
            return;
        }
        List<Tree<StateSet>> children = tree.getChildren();
        StateSet parent = tree.getLabel();
        short parentState = parent.getState();
        switch (children.size()) {
            case 0: {
                break;
            }
            case 1: {
                StateSet child = children.get(0).getLabel();
                short childState = child.getState();
                HierarchicalAdaptiveUnaryRule urule = (HierarchicalAdaptiveUnaryRule)this.grammar.getUnaryRule(parentState, childState);
                double scalingFactor = ScalingTools.calcScaleFactor(parent.getOScale() + child.getIScale() - tree_scale);
                int curInd = -1;
                for (HierarchicalAdaptiveUnaryRule.SubRule subRule : urule.subRuleList) {
                    ++curInd;
                    if (subRule == null) continue;
                    short level = subRule.level;
                    int i = this.substatesToCover[level] * subRule.child;
                    int j = i + this.substatesToCover[level];
                    int k = this.substatesToCover[level] * subRule.parent;
                    int l = k + this.substatesToCover[level];
                    if (parentState == 0) {
                        l = 1;
                    }
                    double pOS = 0.0;
                    for (int np = k; np < l; ++np) {
                        pOS += parent.getOScore(np);
                    }
                    double cS = 0.0;
                    for (int cp = i; cp < j; ++cp) {
                        cS += child.getIScore(cp);
                    }
                    double ruleCount = subRule.score * cS / tree_score * scalingFactor * pOS;
                    if (this.spanScores != null) {
                        ruleCount /= this.spanScores[child.from][child.to][this.stateClass[parentState]];
                    }
                    if (this.isValidExpectation(ruleCount)) {
                        this.tmpCountsArray[curInd] = ruleCount;
                        continue;
                    }
                    if (ruleCount == 0.0) continue;
                    System.out.println("not an expected gold count, u: " + ruleCount + "\n" + urule.toString());
                }
                linearizer.increment(probs, urule, this.tmpCountsArray, true);
                break;
            }
            case 2: {
                StateSet leftChild = children.get(0).getLabel();
                short lChildState = leftChild.getState();
                StateSet rightChild = children.get(1).getLabel();
                short rChildState = rightChild.getState();
                HierarchicalAdaptiveBinaryRule brule = (HierarchicalAdaptiveBinaryRule)this.grammar.getBinaryRule(parentState, lChildState, rChildState);
                double scalingFactor = ScalingTools.calcScaleFactor(parent.getOScale() + leftChild.getIScale() + rightChild.getIScale() - tree_scale);
                int curInd = -1;
                for (HierarchicalAdaptiveBinaryRule.SubRule subRule : brule.subRuleList) {
                    short level = subRule.level;
                    ++curInd;
                    int e = this.substatesToCover[level] * subRule.lChild;
                    int f = e + this.substatesToCover[level];
                    int i = this.substatesToCover[level] * subRule.rChild;
                    int j = i + this.substatesToCover[level];
                    int k = this.substatesToCover[level] * subRule.parent;
                    int l = k + this.substatesToCover[level];
                    double pOS = 0.0;
                    for (int np = k; np < l; ++np) {
                        pOS += parent.getOScore(np);
                    }
                    double lS = 0.0;
                    for (int lp = e; lp < f; ++lp) {
                        lS += leftChild.getIScore(lp);
                    }
                    double rS = 0.0;
                    for (int rp = i; rp < j; ++rp) {
                        rS += rightChild.getIScore(rp);
                    }
                    double ruleCount = subRule.score * lS / tree_score * rS * scalingFactor * pOS;
                    if (this.isValidExpectation(ruleCount)) {
                        int n = curInd;
                        this.tmpCountsArray[n] = this.tmpCountsArray[n] + ruleCount;
                        continue;
                    }
                    if (ruleCount == 0.0) continue;
                    System.out.println("not an expected gold count, b: " + ruleCount + "\n" + brule.toString());
                }
                linearizer.increment(probs, brule, this.tmpCountsArray, true);
                break;
            }
            default: {
                throw new Error("Malformed tree: more than two children");
            }
        }
        for (Tree<StateSet> child : children) {
            this.incrementExpectedGoldCounts(linearizer, probs, child, tree_score, tree_scale);
        }
    }

    public double[][][] getClassBracketPosteriors() {
        double tree_score = this.h_iScorePostU[0][this.length][0][this.finalLevel][0];
        int tree_scale = this.iScale[0][this.length][0];
        double[][][] result = new double[this.length][this.length + 1][this.spanPredictor.getNClasses()];
        for (int start = 0; start < this.length; ++start) {
            for (int end = start + 1; end <= this.length; ++end) {
                int lastState = this.numSubStatesArray.length;
                for (int state = 0; state < lastState; ++state) {
                    double tmp2;
                    double tmp;
                    double posterior;
                    double scalingFactor;
                    double oS2;
                    double iS2;
                    double oS;
                    double iS;
                    int substate;
                    int clas = this.stateClass[state];
                    double spanScore = this.spanScores[start][end][clas];
                    double statePosterior = 0.0;
                    if (this.allowedSubStates[start][end][state] == null) continue;
                    for (substate = 0; substate < this.numSubStatesArray[state]; ++substate) {
                        if (!this.allowedSubStates[start][end][state][substate]) continue;
                        iS = this.h_iScorePostU[start][end][state][this.finalLevel][substate];
                        oS = this.h_oScorePreU[start][end][state][this.finalLevel][substate];
                        iS2 = this.h_iScorePreU[start][end][state][this.finalLevel][substate];
                        oS2 = this.h_oScorePostU[start][end][state][this.finalLevel][substate];
                        scalingFactor = ScalingTools.calcScaleFactor(this.oScale[start][end][state] + this.iScale[start][end][state] - tree_scale);
                        if (scalingFactor == 0.0 || SloppyMath.isDangerous(posterior = Math.max(tmp = iS * oS, tmp2 = iS2 * oS2) / spanScore / tree_score * scalingFactor)) continue;
                        if (posterior > 1.01) {
                            System.out.println("too much posterior s:" + start + " e:" + end + " state " + state + " " + posterior + " " + this.spanScores[start][end]);
                            if (SloppyMath.isVeryDangerous(posterior)) {
                                posterior = 0.0;
                            }
                        }
                        double[] dArray = result[start][end];
                        int n = clas;
                        dArray[n] = dArray[n] + posterior;
                        statePosterior += posterior;
                    }
                    if (!(statePosterior > 1.01)) continue;
                    System.out.println("Too much for a single state: " + statePosterior);
                    for (substate = 0; substate < this.numSubStatesArray[state]; ++substate) {
                        if (!this.allowedSubStates[start][end][state][substate]) continue;
                        iS = this.h_iScorePostU[start][end][state][this.finalLevel][substate];
                        oS = this.h_oScorePreU[start][end][state][this.finalLevel][substate];
                        iS2 = this.h_iScorePreU[start][end][state][this.finalLevel][substate];
                        oS2 = this.h_oScorePostU[start][end][state][this.finalLevel][substate];
                        scalingFactor = ScalingTools.calcScaleFactor(this.oScale[start][end][state] + this.iScale[start][end][state] - tree_scale);
                        if (scalingFactor == 0.0) continue;
                        tmp = iS * oS;
                        tmp2 = iS2 * oS2;
                        posterior = Math.max(tmp, tmp2) / spanScore / tree_score * scalingFactor;
                        System.out.println(posterior);
                    }
                }
                if (!(result[start][end][0] > 2.01)) continue;
                System.out.println("too much in the sum, start " + start + " end " + end + "  " + result[start][end]);
                result[start][end][0] = 0.0;
            }
        }
        return result;
    }
}

