/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.ConditionalTrainer;
import edu.berkeley.nlp.PCFGLA.GrammarTester;
import edu.berkeley.nlp.PCFGLA.OptionParser;
import edu.berkeley.nlp.PCFGLA.ParserConstrainer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;

public class ConditionalPipeline {
    public static boolean initializeWithZero = true;

    public static void main(String[] args) {
        OptionParser optParser = new OptionParser(ConditionalTrainer.Options.class);
        ConditionalTrainer.Options opts = (ConditionalTrainer.Options)optParser.parse(args, true);
        String dirName = opts.outDir;
        String baseName = "split_";
        File directory = new File(dirName);
        if (!directory.mkdir()) {
            System.out.println("Failed to make directory.");
        }
        File nextFile = null;
        ArrayList<String> baselineArgsList = new ArrayList<String>(Arrays.asList("-path", opts.path, "-trfr", "" + opts.trainingFractionToKeep, "-treebank", (Object)((Object)opts.treebank) + "", "-out", dirName + "/" + "base_gen.gr", "-baseline", "-maxL", opts.maxL + "", "-b", (Object)((Object)opts.binarization) + ""));
        if (opts.markUnaryParents) {
            baselineArgsList.add("-markUnaryParents");
        }
        if (opts.markUnaryParents) {
            baselineArgsList.add("-filterStupidFrickinWHNP");
        }
        if (opts.collapseUnaries) {
            baselineArgsList.add("-collapseUnaries");
        }
        String[] baselineArgs = baselineArgsList.toArray(new String[0]);
        nextFile = new File(dirName + "/" + "base_gen.gr");
        if (opts.initializeDir == null) {
            if (!nextFile.exists() || opts.dontLoad) {
                ConditionalTrainer.main(baselineArgs);
            } else {
                System.out.println("Skipping this step since " + nextFile.toString() + " already exists.");
            }
            String[] consArgsTrain = ConditionalPipeline.addOptions(args, new String[]{"-out", dirName + "/" + baseName + "0", "-in", dirName + "/" + "base_gen.gr", "-outputLog", dirName + "/" + baseName + "0.cons.log"});
            nextFile = new File(dirName + "/" + baseName + "0-0.data");
            if (nextFile.exists() && !opts.dontLoad) {
                System.out.println("Skipping this step since " + nextFile.toString() + " already exists.");
            } else {
                ParserConstrainer.main(consArgsTrain);
                consArgsTrain = ConditionalPipeline.addOptions(args, new String[]{"-out", dirName + "/" + baseName + "0_dev", "-in", dirName + "/" + "base_gen.gr", "-section", "dev", "-nChunks", "1", "-outputLog", dirName + "/" + baseName + "0_dev.cons.log"});
                ParserConstrainer.main(consArgsTrain);
                consArgsTrain = ConditionalPipeline.addOptions(args, new String[]{"-out", dirName + "/" + baseName + "0_test", "-in", dirName + "/" + "base_gen.gr", "-section", "final", "-nChunks", "1", "-outputLog", dirName + "/" + baseName + "0_test.cons.log"});
                ParserConstrainer.main(consArgsTrain);
            }
        }
        nextFile = new File(dirName + "/" + baseName + "0.gr");
        String[] baselineCondArgs = null;
        baselineCondArgs = opts.initializeDir != null ? ConditionalPipeline.addOptions(args, new String[]{"-out", nextFile.toString(), "-cons", opts.initializeDir + "/" + baseName + "0", "-in", opts.initializeDir + "/" + baseName + "0.gr", "-doNOTprojectConstraints", "-noSplit", "-doConditional"}) : ConditionalPipeline.addOptions(args, new String[]{"-out", nextFile.toString(), "-cons", dirName + "/" + baseName + "0", initializeWithZero ? "-initializeZero" : "", "-doNOTprojectConstraints", "-noSplit", "-doConditional"});
        if (!nextFile.exists() || opts.dontLoad) {
            ConditionalTrainer.main(baselineCondArgs);
            if (opts.testAll) {
                System.out.println("Testing all grammars to determine which one was the best and should be split next");
                String[] testArgs = new String[]{"-doNOTprojectConstraints", "-cons", dirName + "/" + baseName + "0_dev-0.data", "-testAll", "-path", opts.path, "-in", baseName + "0.gr", "-filePath", opts.outDir, "-treebank", (Object)((Object)opts.treebank) + "", "-maxL", opts.maxL + "", "-parser", "plain", "-nProcess", opts.nProcess + ""};
                GrammarTester.main(testArgs);
            }
        } else {
            System.out.println("Skipping this step since " + nextFile.toString() + " already exists.");
        }
        for (int split = 1; split <= 6; ++split) {
            System.out.println("\n\nIn " + split + ". Split-Iteration.");
            String previousGrammar = dirName + "/" + baseName + (split - 1);
            String currentGrammar = dirName + "/" + baseName + split;
            String[] trainArgs = null;
            if (opts.initializeDir == null) {
                nextFile = new File(currentGrammar + ".gr");
                trainArgs = ConditionalPipeline.addOptions(args, new String[]{"-in", previousGrammar + ".gr", "-doConditional", "-cons", previousGrammar, "-out", nextFile.toString()});
            } else {
                nextFile = new File(currentGrammar + ".gr");
                trainArgs = ConditionalPipeline.addOptions(args, new String[]{"-in", opts.initializeDir + "/" + baseName + split + ".gr", "-doConditional", "-noSplit", "-cons", opts.initializeDir + "/" + baseName + (split - 1), "-out", nextFile.toString()});
            }
            if (!nextFile.exists() || opts.dontLoad) {
                ConditionalTrainer.main(trainArgs);
                if (opts.testAll) {
                    System.out.println("Testing all grammars to determine which one was the best and should be split next");
                    String[] testArgs = new String[]{"-cons", dirName + "/" + baseName + (split - 1) + "_dev-0.data", "-testAll", "-path", opts.path, "-in", baseName + split + ".gr", "-filePath", opts.outDir, "-treebank", (Object)((Object)opts.treebank) + "", "-maxL", opts.maxL + "", "-parser", "plain", "-nProcess", opts.nProcess + ""};
                    GrammarTester.main(testArgs);
                }
            } else {
                System.out.println("Skipping this step since " + nextFile.toString() + " already exists.");
            }
            if (opts.initializeDir != null) continue;
            nextFile = new File(currentGrammar + "-0.data");
            if (nextFile.exists() && !opts.dontLoad) {
                System.out.println("Skipping this step since " + nextFile.toString() + " already exists.");
                continue;
            }
            String[] consArgs = ConditionalPipeline.addOptions(args, new String[]{"-cons", previousGrammar, "-out", currentGrammar, "-in", currentGrammar + ".gr", "-outputLog", currentGrammar + ".cons.log"});
            ParserConstrainer.main(consArgs);
            consArgs = ConditionalPipeline.addOptions(args, new String[]{"-cons", previousGrammar + "_dev", "-out", currentGrammar + "_dev", "-in", currentGrammar + ".gr", "-section", "dev", "-nChunks", "1", "-outputLog", currentGrammar + "_dev.cons.log"});
            ParserConstrainer.main(consArgs);
            consArgs = ConditionalPipeline.addOptions(args, new String[]{"-cons", previousGrammar + "_test", "-out", currentGrammar + "_test", "-in", currentGrammar + ".gr", "-section", "final", "-nChunks", "1", "-outputLog", currentGrammar + "_test.cons.log"});
        }
        System.exit(0);
    }

    private static String[] addOptions(String[] a, String[] b) {
        int i;
        String[] res = new String[a.length + b.length];
        for (i = 0; i < a.length; ++i) {
            res[i] = a[i];
        }
        for (i = 0; i < b.length; ++i) {
            res[i + a.length] = b[i];
        }
        return res;
    }
}

