/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.BinaryRule;
import edu.berkeley.nlp.PCFGLA.CoarseToFineMaxRuleParser;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.HyperEdge;
import edu.berkeley.nlp.PCFGLA.LazyList;
import edu.berkeley.nlp.PCFGLA.Lexicon;
import edu.berkeley.nlp.PCFGLA.UnaryRule;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.util.PriorityQueue;
import edu.berkeley.nlp.util.ScalingTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoarseToFineNBestParser
extends CoarseToFineMaxRuleParser {
    LazyList[][][] chartBeforeU;
    LazyList[][][] chartAfterU;
    int k;
    List<Double> maxRuleScores;
    int tmp_k;

    public CoarseToFineNBestParser(Grammar gr, Lexicon lex, int k, double unaryPenalty, int endL, boolean viterbi, boolean sub, boolean score, boolean accurate, boolean variational, boolean useGoldPOS, boolean initCascade) {
        super(gr, lex, unaryPenalty, endL, viterbi, sub, score, accurate, variational, useGoldPOS, initCascade);
        this.k = k;
    }

    @Override
    void doConstrainedMaxCScores(List<String> sentence, Grammar grammar, Lexicon lexicon, boolean scale) {
        this.numSubStatesArray = grammar.numSubStates;
        double initVal = Double.NEGATIVE_INFINITY;
        this.chartBeforeU = new LazyList[this.length][this.length + 1][this.numStates];
        this.chartAfterU = new LazyList[this.length][this.length + 1][this.numStates];
        double logNormalizer = this.iScore[0][this.length][0][0];
        for (int diff = 1; diff <= this.length; ++diff) {
            for (int start = 0; start < this.length - diff + 1; ++start) {
                int pState;
                int end = start + diff;
                if (diff > 1) {
                    for (pState = 0; pState < this.numSubStatesArray.length; ++pState) {
                        if (!this.allowedStates[start][end][pState]) continue;
                        this.chartBeforeU[start][end][pState] = new LazyList(grammar.isGrammarTag);
                        BinaryRule[] parentRules = grammar.splitRulesWithP(pState);
                        int nParentStates = this.numSubStatesArray[pState];
                        double bestScore = Double.NEGATIVE_INFINITY;
                        HyperEdge bestElement = null;
                        for (int i = 0; i < parentRules.length; ++i) {
                            int max;
                            int min;
                            boolean iPossibleR;
                            boolean iPossibleL;
                            BinaryRule r = parentRules[i];
                            short lState = r.leftChildState;
                            short rState = r.rightChildState;
                            int narrowR = this.narrowRExtent[start][lState];
                            boolean bl = iPossibleL = narrowR < end;
                            if (!iPossibleL) continue;
                            int narrowL = this.narrowLExtent[end][rState];
                            boolean bl2 = iPossibleR = narrowL >= narrowR;
                            if (!iPossibleR) continue;
                            int min1 = narrowR;
                            int min2 = this.wideLExtent[end][rState];
                            int n = min = min1 > min2 ? min1 : min2;
                            if (min > narrowL) continue;
                            int max1 = this.wideRExtent[start][lState];
                            int max2 = narrowL;
                            int n2 = max = max1 < max2 ? max1 : max2;
                            if (min > max) continue;
                            double[][][] scores = r.getScores2();
                            int nLeftChildStates = this.numSubStatesArray[lState];
                            int nRightChildStates = this.numSubStatesArray[rState];
                            for (int split = min; split <= max; ++split) {
                                double gScore;
                                double rightChildScore;
                                double ruleScore = 0.0;
                                if (!this.allowedStates[start][split][lState] || !this.allowedStates[split][end][rState]) continue;
                                HyperEdge bestLeft = this.chartAfterU[start][split][lState].getKbest(0);
                                double leftChildScore = bestLeft == null ? Double.NEGATIVE_INFINITY : bestLeft.score;
                                HyperEdge bestRight = this.chartAfterU[split][end][rState].getKbest(0);
                                double d = rightChildScore = bestRight == null ? Double.NEGATIVE_INFINITY : bestRight.score;
                                if (leftChildScore == initVal || rightChildScore == initVal) continue;
                                double scalingFactor = 0.0;
                                if (scale) {
                                    scalingFactor = Math.log(ScalingTools.calcScaleFactor(this.oScale[start][end][pState] + this.iScale[start][split][lState] + this.iScale[split][end][rState] - this.iScale[0][this.length][0]));
                                }
                                if ((gScore = leftChildScore + scalingFactor + rightChildScore) == Double.NEGATIVE_INFINITY) continue;
                                for (int lp = 0; lp < nLeftChildStates; ++lp) {
                                    double lIS = this.iScore[start][split][lState][lp];
                                    if (lIS == 0.0) continue;
                                    for (int rp = 0; rp < nRightChildStates; ++rp) {
                                        double rIS;
                                        if (scores[lp][rp] == null || (rIS = this.iScore[split][end][rState][rp]) == 0.0) continue;
                                        for (int np = 0; np < nParentStates; ++np) {
                                            double ruleS;
                                            double pOS = this.oScore[start][end][pState][np];
                                            if (pOS == 0.0 || (ruleS = scores[lp][rp][np]) == 0.0) continue;
                                            ruleScore += pOS * ruleS * lIS * rIS / logNormalizer;
                                        }
                                    }
                                }
                                if (ruleScore == 0.0 || !((gScore += (ruleScore = Math.log(ruleScore))) > Double.NEGATIVE_INFINITY)) continue;
                                HyperEdge newElement = new HyperEdge(pState, lState, rState, 0, 0, 0, start, split, end, gScore, ruleScore);
                                if (gScore > bestScore) {
                                    bestScore = gScore;
                                    bestElement = newElement;
                                }
                                if (diff <= 2) continue;
                                this.chartBeforeU[start][end][pState].addToFringe(newElement);
                            }
                        }
                        if (diff != 2 || bestElement == null) continue;
                        this.chartBeforeU[start][end][pState].addToFringe(bestElement);
                    }
                } else {
                    for (int tag = 0; tag < this.numSubStatesArray.length; ++tag) {
                        if (!this.allowedStates[start][end][tag]) continue;
                        this.chartBeforeU[start][end][tag] = new LazyList(grammar.isGrammarTag);
                        int nTagStates = this.numSubStatesArray[tag];
                        String word = sentence.get(start);
                        if (grammar.isGrammarTag(tag)) continue;
                        double[] lexiconScoreArray = lexicon.score(word, (short)tag, start, false, false);
                        double lexiconScores = 0.0;
                        for (int tp = 0; tp < nTagStates; ++tp) {
                            double pOS = this.oScore[start][end][tag][tp];
                            double ruleS = lexiconScoreArray[tp];
                            lexiconScores += pOS * ruleS / logNormalizer;
                        }
                        double scalingFactor = 0.0;
                        if (scale) {
                            scalingFactor = Math.log(ScalingTools.calcScaleFactor(this.oScale[start][end][tag] - this.iScale[0][this.length][0]));
                        }
                        lexiconScores = Math.log(lexiconScores);
                        double gScore = lexiconScores + scalingFactor;
                        HyperEdge newElement = new HyperEdge(tag, -1, -1, 0, 0, 0, start, start, end, gScore, lexiconScores);
                        this.chartBeforeU[start][end][tag].addToFringe(newElement);
                    }
                }
                for (pState = 0; pState < this.numSubStatesArray.length; ++pState) {
                    HyperEdge bestSelf;
                    if (!this.allowedStates[start][end][pState]) continue;
                    this.chartAfterU[start][end][pState] = new LazyList(grammar.isGrammarTag);
                    int nParentStates = this.numSubStatesArray[pState];
                    UnaryRule[] unaries = grammar.getClosedSumUnaryRulesByParent(pState);
                    HyperEdge bestElement = null;
                    double bestScore = Double.NEGATIVE_INFINITY;
                    for (int r = 0; r < unaries.length; ++r) {
                        UnaryRule ur = unaries[r];
                        short cState = ur.childState;
                        if (pState == cState || this.iScore[start][end][cState] == null) continue;
                        double childScore = Double.NEGATIVE_INFINITY;
                        if (this.chartBeforeU[start][end][cState] != null) {
                            HyperEdge bestChild = this.chartBeforeU[start][end][cState].getKbest(0);
                            double d = childScore = bestChild == null ? Double.NEGATIVE_INFINITY : bestChild.score;
                        }
                        if (childScore == initVal) continue;
                        double scalingFactor = 0.0;
                        if (scale) {
                            scalingFactor = Math.log(ScalingTools.calcScaleFactor(this.oScale[start][end][pState] + this.iScale[start][end][cState] - this.iScale[0][this.length][0]));
                        }
                        double gScore = scalingFactor + childScore;
                        double[][] scores = ur.getScores2();
                        int nChildStates = this.numSubStatesArray[cState];
                        double ruleScore = 0.0;
                        for (int cp = 0; cp < nChildStates; ++cp) {
                            double cIS = this.iScore[start][end][cState][cp];
                            if (cIS == 0.0 || scores[cp] == null) continue;
                            for (int np = 0; np < nParentStates; ++np) {
                                double ruleS;
                                double pOS = this.oScore[start][end][pState][np];
                                if (pOS < 0.0 || (ruleS = scores[cp][np]) == 0.0) continue;
                                ruleScore += pOS * ruleS * cIS / logNormalizer;
                            }
                        }
                        if (ruleScore == 0.0 || !((gScore += (ruleScore = Math.log(ruleScore))) > Double.NEGATIVE_INFINITY)) continue;
                        HyperEdge newElement = new HyperEdge(pState, cState, 0, 0, start, end, gScore, ruleScore);
                        if (gScore > bestScore) {
                            bestScore = gScore;
                            bestElement = newElement;
                        }
                        if (diff <= 1) continue;
                        this.chartAfterU[start][end][pState].addToFringe(newElement);
                    }
                    if (diff == 1 && bestElement != null) {
                        this.chartAfterU[start][end][pState].addToFringe(bestElement);
                    }
                    if (this.chartBeforeU[start][end][pState] == null || (bestSelf = this.chartBeforeU[start][end][pState].getKbest(0)) == null) continue;
                    HyperEdge selfRule = new HyperEdge(pState, pState, 0, 0, start, end, bestSelf.score, 0.0);
                    this.chartAfterU[start][end][pState].addToFringe(selfRule);
                }
            }
        }
    }

    @Override
    public Tree<String> extractBestMaxRuleParse(int start, int end, List<String> sentence) {
        return this.extractBestMaxRuleParse1(start, end, 0, 0, sentence);
    }

    public List<Tree<String>> extractKBestMaxRuleParses(int start, int end, List<String> sentence, int k) {
        ArrayList<Tree<String>> list = new ArrayList<Tree<String>>(k);
        this.maxRuleScores = new ArrayList<Double>(k);
        this.tmp_k = 0;
        for (int i = 0; i < k; ++i) {
            Tree<String> tmp = this.extractBestMaxRuleParse1(start, end, 0, i, sentence);
            if (tmp != null) {
                this.maxRuleScores.add(this.chartAfterU[0][this.length][0].getKbest((int)i).score);
            }
            if (tmp == null) break;
            list.add(tmp);
        }
        return list;
    }

    @Override
    public double getModelScore(Tree<String> parsedTree) {
        return this.maxRuleScores.get(this.tmp_k++);
    }

    public Tree<String> extractBestMaxRuleParse1(int start, int end, int state, int suboptimalities, List<String> sentence) {
        boolean posLevel;
        HyperEdge parentNode = this.chartAfterU[start][end][state].getKbest(suboptimalities);
        if (parentNode == null) {
            System.err.println("Don't have a " + (suboptimalities + 1) + "-best tree.");
            return null;
        }
        int cState = parentNode.childState;
        Tree<String> result = null;
        HyperEdge childNode = this.chartBeforeU[start][end][cState].getKbest(parentNode.childBest);
        ArrayList children = new ArrayList();
        String stateStr = (String)this.tagNumberer.object(cState);
        if (stateStr.endsWith("^g")) {
            stateStr = stateStr.substring(0, stateStr.length() - 2);
        }
        boolean bl = posLevel = end - start == 1;
        if (posLevel) {
            children.add(new Tree<String>(sentence.get(start)));
        } else {
            int split = childNode.split;
            if (split == -1) {
                System.err.println("Warning: no symbol can generate the span from " + start + " to " + end + ".");
                System.err.println("The score is " + this.maxcScore[start][end][state] + " and the state is supposed to be " + stateStr);
                System.err.println("The insideScores are " + Arrays.toString(this.iScore[start][end][state]) + " and the outsideScores are " + Arrays.toString(this.oScore[start][end][state]));
                System.err.println("The maxcScore is " + this.maxcScore[start][end][state]);
                return new Tree<String>("ROOT");
            }
            int lState = childNode.lChildState;
            int rState = childNode.rChildState;
            Tree<String> leftChildTree = this.extractBestMaxRuleParse1(start, split, lState, childNode.lChildBest, sentence);
            Tree<String> rightChildTree = this.extractBestMaxRuleParse1(split, end, rState, childNode.rChildBest, sentence);
            children.add(leftChildTree);
            children.add(rightChildTree);
        }
        boolean scale = false;
        this.updateConstrainedMaxCScores(sentence, scale, childNode);
        result = new Tree<String>(stateStr, children);
        if (cState != state) {
            int intermediateNode;
            stateStr = (String)this.tagNumberer.object(state);
            if (stateStr.endsWith("^g")) {
                stateStr = stateStr.substring(0, stateStr.length() - 2);
            }
            if ((intermediateNode = this.grammar.getUnaryIntermediate((short)state, (short)cState)) > 0) {
                ArrayList restoredChild = new ArrayList();
                String stateStr2 = (String)this.tagNumberer.object(intermediateNode);
                if (stateStr2.endsWith("^g")) {
                    stateStr2 = stateStr2.substring(0, stateStr2.length() - 2);
                }
                restoredChild.add(result);
                result = new Tree<String>(stateStr2, restoredChild);
            }
            ArrayList childs = new ArrayList();
            childs.add(result);
            result = new Tree<String>(stateStr, childs);
        }
        this.updateConstrainedMaxCScores(sentence, scale, parentNode);
        return result;
    }

    void updateConstrainedMaxCScores(List<String> sentence, boolean scale, HyperEdge parent) {
        int start = parent.start;
        int end = parent.end;
        int pState = parent.parentState;
        int suboptimalities = parent.parentBest + 1;
        double ruleScore = parent.ruleScore;
        if (parent.alreadyExpanded) {
            return;
        }
        if (!parent.isUnary) {
            int rBest;
            HyperEdge rChild;
            double newScore;
            int lBest;
            HyperEdge lChild;
            int lState = parent.lChildState;
            int rState = parent.rChildState;
            int split = parent.split;
            HyperEdge newParentL = null;
            HyperEdge newParentR = null;
            if (split - start > 1 && (lChild = this.chartAfterU[start][split][lState].getKbest(lBest = parent.lChildBest + 1)) != null) {
                int rBest2 = parent.rChildBest;
                HyperEdge rChild2 = this.chartAfterU[split][end][rState].getKbest(rBest2);
                newScore = lChild.score + rChild2.score + ruleScore;
                newParentL = new HyperEdge(pState, lState, rState, suboptimalities, lBest, rBest2, start, split, end, newScore, ruleScore);
            }
            if (end - split > 1 && (rChild = this.chartAfterU[split][end][rState].getKbest(rBest = parent.rChildBest + 1)) != null) {
                int lBest2 = parent.lChildBest;
                HyperEdge lChild2 = this.chartAfterU[start][split][lState].getKbest(lBest2);
                newScore = lChild2.score + rChild.score + ruleScore;
                newParentR = new HyperEdge(pState, lState, rState, suboptimalities, lBest2, rBest, start, split, end, newScore, ruleScore);
            }
            if (newParentL != null && newParentR != null && newParentL.score > newParentR.score) {
                this.chartBeforeU[start][end][pState].addToFringe(newParentL);
            } else if (newParentL != null && newParentR != null) {
                this.chartBeforeU[start][end][pState].addToFringe(newParentR);
            } else if (newParentL != null || newParentR != null) {
                if (newParentL != null) {
                    this.chartBeforeU[start][end][pState].addToFringe(newParentL);
                } else {
                    this.chartBeforeU[start][end][pState].addToFringe(newParentR);
                }
            }
            parent.alreadyExpanded = true;
        } else {
            int cState = parent.childState;
            int cBest = parent.childBest + 1;
            if (end - start > 1) {
                HyperEdge child = this.chartBeforeU[start][end][cState].getKbest(cBest);
                if (child != null) {
                    double newScore = child.score + ruleScore;
                    HyperEdge newParent = new HyperEdge(pState, cState, suboptimalities, cBest, start, end, newScore, ruleScore);
                    this.chartAfterU[start][end][pState].addToFringe(newParent);
                }
                parent.alreadyExpanded = true;
            }
        }
    }

    @Override
    public List<Tree<String>> getKBestConstrainedParses(List<String> sentence, List<String> posTags, int k) {
        if (sentence.size() == 0) {
            ArrayList<Tree<String>> result = new ArrayList<Tree<String>>();
            result.add(new Tree<String>("ROOT"));
            return result;
        }
        this.doPreParses(sentence, null, false, posTags);
        List<Tree<String>> bestTrees = null;
        double score = 0.0;
        Grammar curGrammar = this.grammarCascade[this.endLevel - this.startLevel + 1];
        Lexicon curLexicon = this.lexiconCascade[this.endLevel - this.startLevel + 1];
        double initVal = this.viterbiParse ? Double.NEGATIVE_INFINITY : 0.0;
        int level = this.isBaseline ? 1 : this.endLevel;
        this.createArrays(false, curGrammar.numStates, curGrammar.numSubStates, level, initVal, false);
        this.initializeChart(sentence, curLexicon, false, false, posTags, false);
        this.doConstrainedInsideScores(curGrammar, this.viterbiParse, this.viterbiParse);
        score = this.iScore[0][this.length][0][0];
        if (!this.viterbiParse) {
            score = Math.log(score);
        }
        this.logLikelihood = score;
        if (score != Double.NEGATIVE_INFINITY) {
            if (!this.viterbiParse) {
                this.oScore[0][this.length][0][0] = 1.0;
                this.doConstrainedOutsideScores(curGrammar, this.viterbiParse, false);
                this.doConstrainedMaxCScores(sentence, curGrammar, curLexicon, false);
            }
        } else {
            this.setupScaling();
            this.initializeChart(sentence, curLexicon, false, false, posTags, true);
            this.doScaledConstrainedInsideScores(curGrammar);
            score = this.iScore[0][this.length][0][0];
            if (!this.viterbiParse) {
                score = Math.log(score) + (double)(100 * this.iScale[0][this.length][0]);
            }
            this.oScore[0][this.length][0][0] = 1.0;
            this.oScale[0][this.length][0] = 0;
            this.doScaledConstrainedOutsideScores(curGrammar);
            this.doConstrainedMaxCScores(sentence, curGrammar, curLexicon, true);
        }
        this.grammar = curGrammar;
        this.lexicon = curLexicon;
        bestTrees = this.extractKBestMaxRuleParses(0, this.length, sentence, k);
        return bestTrees;
    }

    @Override
    public CoarseToFineNBestParser newInstance() {
        CoarseToFineNBestParser newParser = new CoarseToFineNBestParser(this.grammar, this.lexicon, this.k, this.unaryPenalty, this.endLevel, this.viterbiParse, this.outputSub, this.outputScore, this.accurate, this.doVariational, this.useGoldPOS, false);
        newParser.initCascade(this);
        return newParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Object call() {
        List<Tree<String>> result = this.getKBestConstrainedParses(this.nextSentence, null, this.k);
        this.nextSentence = null;
        PriorityQueue priorityQueue = this.queue;
        synchronized (priorityQueue) {
            this.queue.add(result, -this.nextSentenceID);
            this.queue.notifyAll();
        }
        return null;
    }
}

