/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.util;

import de.uni_leipzig.simba.data.Mapping;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    static Logger logger = Logger.getLogger((String)"LIMES");

    public static double getPrecision(Mapping reference, Mapping computed) {
        double size = computed.size();
        double count = 0.0;
        for (String key : computed.map.keySet()) {
            for (String value : computed.map.get(key).keySet()) {
                if (!reference.contains(key, value) && !reference.contains(value, key)) continue;
                count += 1.0;
            }
        }
        return count / size;
    }

    public static double getRecall(Mapping reference, Mapping computed) {
        double size = reference.size();
        double count = 0.0;
        for (String key : computed.map.keySet()) {
            for (String value : computed.map.get(key).keySet()) {
                if (!reference.contains(key, value) && !reference.contains(value, key)) continue;
                count += 1.0;
            }
        }
        return count / size;
    }

    public static double getFscore(Mapping reference, Mapping computed) {
        double sizeC = computed.size();
        double sizeR = reference.size();
        double count = 0.0;
        for (String key : computed.map.keySet()) {
            for (String value : computed.map.get(key).keySet()) {
                if (!reference.contains(key, value) && !reference.contains(value, key)) continue;
                count += 1.0;
            }
        }
        double p = count / sizeC;
        double r = count / sizeR;
        return 2.0 * p * r / (p + r);
    }

    public static HashMap<String, Double> getPRF(Mapping reference, Mapping computed) {
        HashMap<String, Double> result = new HashMap<String, Double>();
        double sizeC = computed.size();
        double sizeR = reference.size();
        double count = 0.0;
        for (String key : computed.map.keySet()) {
            for (String value : computed.map.get(key).keySet()) {
                if (!reference.contains(key, value) && !reference.contains(value, key)) continue;
                count += 1.0;
            }
        }
        double p = count / sizeC;
        result.put("precision", p);
        double r = count / sizeR;
        result.put("recall", r);
        result.put("fscore", 2.0 * p * r / (p + r));
        return result;
    }

    private static String splitAtCamelCase(String s) {
        String regex = "([a-z])([A-Z])";
        String replacement = "$1 $2";
        return s.replaceAll(regex, replacement).toLowerCase();
    }

    public static double getStandardDeviation(List<Double> data) {
        double mean = 0.0;
        int n = data.size();
        if (n < 2) {
            return Double.NaN;
        }
        for (int i = 0; i < n; ++i) {
            mean += data.get(i).doubleValue();
        }
        mean /= (double)n;
        double sum = 0.0;
        for (int i = 0; i < n; ++i) {
            double v = data.get(i) - mean;
            sum += v * v;
        }
        return Math.sqrt(sum / (double)(n - 1));
    }

    public static double getMean(List<Double> data) {
        double mean = 0.0;
        int n = data.size();
        if (n < 2) {
            return Double.NaN;
        }
        for (int i = 0; i < n; ++i) {
            mean += data.get(i).doubleValue();
        }
        return mean /= (double)n;
    }
}

