/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.util;

import de.uni_leipzig.simba.cache.HybridCache;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.io.ConfigReader;
import de.uni_leipzig.simba.learning.learner.Configuration;
import de.uni_leipzig.simba.learning.learner.LinearCombinationLearner;
import de.uni_leipzig.simba.learning.oracle.oracle.Oracle;
import de.uni_leipzig.simba.learning.oracle.oracle.OracleFactory;
import java.util.HashMap;

public class RavenExampleRunner {
    public static final String pathToConfig = "Examples/GeneticEval/";
    public static final String pathToData = "Examples/GeneticEval/Datasets/";
    public static final String ReferenceFile = "DBLP-ACM/DBLP-ACM_perfectMapping.csv";
    public static final String LimesConfigFile = "PublicationData.xml";
    int rounds = 1;
    public static Mapping propertyMapping = new Mapping();
    public static HashMap<String, String> propertyTypes = new HashMap();

    public void run() {
        ConfigReader cR = new ConfigReader();
        cR.validateAndRead("Examples/GeneticEval/PublicationData.xml");
        HybridCache sC = HybridCache.getData(cR.sourceInfo);
        HybridCache tC = HybridCache.getData(cR.targetInfo);
        Oracle o = OracleFactory.getOracle("Examples/GeneticEval/Datasets/DBLP-ACM/DBLP-ACM_perfectMapping.csv", "CSV", "simple");
        for (int i = 0; i < 1; ++i) {
            propertyMapping.add(cR.sourceInfo.properties.get(i), cR.targetInfo.properties.get(i), 1.0);
            String sourcePropFunctionChain = "";
            String targetPropFunctionChain = "";
            if (sourcePropFunctionChain.indexOf("number") == -1) {
                propertyTypes.put(cR.sourceInfo.properties.get(i), "string");
            } else {
                propertyTypes.put(cR.sourceInfo.properties.get(i), "spatial");
            }
            if (targetPropFunctionChain.indexOf("number") == -1) {
                propertyTypes.put(cR.targetInfo.properties.get(i), "string");
                continue;
            }
            propertyTypes.put(cR.targetInfo.properties.get(i), "spatial");
        }
        LinearCombinationLearner learner = new LinearCombinationLearner(cR.sourceInfo, cR.targetInfo, sC, tC, o, propertyMapping, propertyTypes, 0.5, 0.5);
        learner.computeNextConfig(this.rounds);
        Configuration config = learner.getCurrentConfig();
        double prec = learner.getPrecision();
        double rec = learner.getRecall();
        String output = "====>" + this.rounds + ": Config:\n" + config.getExpression() + "\n" + "Precision:" + prec + " Recall:" + rec;
        System.out.println(output);
    }

    public static void main(String[] args) {
        for (int i = 0; i < 3; ++i) {
            RavenExampleRunner runner = new RavenExampleRunner();
            runner.run();
        }
    }
}

