/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.util;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFReader;
import de.uni_leipzig.simba.io.KBInfo;
import de.uni_leipzig.simba.query.ModelRegistry;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ModelTester {
    KBInfo kb;
    Model model;
    static Logger logger = Logger.getLogger((String)"LIMES");

    public void testModel1(KBInfo kbinfo) {
        try {
            this.kb = kbinfo;
            this.model = ModelFactory.createDefaultModel();
            RDFReader r = this.model.getReader(this.kb.type);
            FileInputStream in = new FileInputStream(this.kb.endpoint);
            InputStreamReader reader = new InputStreamReader((InputStream)in, "UTF8");
            r.read(this.model, (Reader)reader, null);
            logger.info((Object)("RDF model read from " + this.kb.endpoint + " is of size " + this.model.size()));
            ModelRegistry.register(this.kb.endpoint, this.model);
        }
        catch (Exception e) {
            logger.fatal((Object)("Error while reading input stream " + this.kb.endpoint));
            e.printStackTrace();
        }
    }

    public void query() {
        String basicQuery = "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>  \nPREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>  \n";
        String query = "SELECT ?o \n WHERE { ?s rdf:type ?o } LIMIT 10";
        Query sparqlQuery = QueryFactory.create((String)(basicQuery + query), (Syntax)Syntax.syntaxARQ);
        Model model = ModelRegistry.getInstance().getMap().get(this.kb.endpoint);
        if (model == null) {
            throw new RuntimeException("No model with id '" + this.kb.endpoint + "' registered");
        }
        QueryExecution qexec = QueryExecutionFactory.create((Query)sparqlQuery, (Model)model);
        ResultSet results = qexec.execSelect();
        System.out.println(results);
        while (results.hasNext()) {
            QuerySolution sol = results.next();
            System.out.println(sol);
        }
    }

    public static void main(String[] args) {
        Properties systemproperties = System.getProperties();
        Enumeration<?> e = systemproperties.propertyNames();
        while (e.hasMoreElements()) {
            String prop = (String)e.nextElement();
            System.out.println("Property: " + prop + " , Wert: " + systemproperties.getProperty(prop));
        }
    }
}

