/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.transformation.learner;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.cache.HybridCache;
import de.uni_leipzig.simba.data.Instance;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.evaluation.PRFComputer;
import de.uni_leipzig.simba.execution.ExecutionEngine;
import de.uni_leipzig.simba.execution.Instruction;
import de.uni_leipzig.simba.io.KBInfo;
import de.uni_leipzig.simba.mapper.SetOperations;
import de.uni_leipzig.simba.query.CsvQueryModule;
import de.uni_leipzig.simba.selfconfig.ComplexClassifier;
import de.uni_leipzig.simba.selfconfig.MeshBasedSelfConfigurator;
import de.uni_leipzig.simba.selfconfig.SimpleClassifier;
import de.uni_leipzig.simba.transformation.dictionary.Dictionary;
import de.uni_leipzig.simba.transformation.dictionary.Rule;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationLearner {
    public Dictionary learnRules(Mapping m) {
        Dictionary dict = new Dictionary();
        for (String s : m.map.keySet()) {
            for (String t : m.map.get(s).keySet()) {
                dict.addRules(s, t);
            }
        }
        return dict;
    }

    public Dictionary learnRules(Cache source, Cache target, Mapping m, String sourceProperty, String targetProperty) {
        Dictionary dict = new Dictionary();
        for (String s : m.map.keySet()) {
            for (String t : m.map.get(s).keySet()) {
                Instance sourceInstance = source.getInstance(s);
                Instance targetInstance = target.getInstance(t);
                if (sourceInstance == null || targetInstance == null) continue;
                TreeSet<String> sourceValues = source.getInstance(s).getProperty(sourceProperty);
                TreeSet<String> targetValues = target.getInstance(t).getProperty(targetProperty);
                for (String sV : sourceValues) {
                    for (String sT : targetValues) {
                        dict.addRules(sV, sT);
                    }
                }
            }
        }
        return dict;
    }

    public Set<Rule> learnAllRules(Cache source, Cache target, Mapping m, String sourceProperty, String targetProperty) {
        HashSet<Rule> source2target = new HashSet<Rule>();
        Dictionary ruleDict = this.learnRules(source, target, m, sourceProperty, targetProperty);
        System.out.println("+++" + ruleDict.getRulesWithMaxCoverage());
        source2target.addAll(ruleDict.getRulesWithMaxCoverage().keySet());
        HashSet<Rule> target2source = new HashSet<Rule>();
        target2source.addAll(this.learnRules(target, source, m.reverseSourceTarget(), targetProperty, sourceProperty).getRulesWithMaxCoverage().keySet());
        for (Rule r : source2target) {
            r.setFromSourceToTarget(true);
        }
        for (Rule r : target2source) {
            r.setFromSourceToTarget(false);
        }
        for (Rule r1 : target2source) {
            boolean add = true;
            for (Rule r2 : source2target) {
                if (!r2.getSource().equals(r1.getTarget()) || !r2.getTarget().equals(r1.getSource())) continue;
                add = false;
            }
            if (!add) continue;
            source2target.add(r1);
        }
        return source2target;
    }

    public Cache applyRuleToCache(Rule r, Cache source, String property) {
        ArrayList<String> uris = source.getAllUris();
        for (String uri : uris) {
            Instance s = source.getInstance(uri);
            TreeSet<String> values = s.getProperty(property);
            TreeSet<String> newValues = new TreeSet<String>();
            for (String value : values) {
                String newValue = value.replaceAll(Pattern.quote(r.getSource()), r.getTarget());
                newValues.add(newValue);
            }
            s.replaceProperty(property, newValues);
        }
        return source;
    }

    public Cache applyRuleToCacheUsingMapping(Rule r, Cache source, Cache target, String sourceProperty, String targetProperty, Mapping m) {
        Set<String> sourceUris = m.map.keySet();
        int count = 0;
        for (String sourceUri : sourceUris) {
            boolean checkSourceValue = false;
            Instance s = source.getInstance(sourceUri);
            TreeSet<String> sourceValues = s.getProperty(sourceProperty);
            Set<String> targetUris = m.map.get(sourceUri).keySet();
            for (String value : sourceValues) {
                if (!value.contains(r.getSource())) continue;
                checkSourceValue = true;
                break;
            }
            if (!checkSourceValue) continue;
            boolean checkTargetValue = false;
            for (String targetUri : targetUris) {
                Instance t = target.getInstance(targetUri);
                TreeSet<String> targetValues = t.getProperty(targetProperty);
                for (String targetValue : targetValues) {
                    if (!targetValue.contains(r.getTarget())) continue;
                    checkTargetValue = true;
                    break;
                }
                if (!checkTargetValue) continue;
                break;
            }
            if (!checkTargetValue) continue;
            ++count;
            TreeSet<String> newValues = new TreeSet<String>();
            for (String value : sourceValues) {
                String newValue = value.replaceAll(Pattern.quote(r.getSource()), r.getTarget());
                newValues.add(newValue);
            }
            s.replaceProperty(sourceProperty, newValues);
        }
        if (count == 0) {
            System.out.println("WARN: No source for " + r);
        }
        return source;
    }

    public void runLearningIteration(Cache source, Cache target, Mapping m, String sourceProperty, String targetProperty) {
        Set<Rule> rules = this.learnAllRules(source, target, m, sourceProperty, targetProperty);
        for (Rule r : rules) {
            if (r.isFromSourceToTarget()) {
                source = this.applyRuleToCache(r, source, sourceProperty);
                continue;
            }
            target = this.applyRuleToCache(r, target, targetProperty);
        }
    }

    public double runSelfConfig(Cache source, Cache target, Mapping reference) {
        MeshBasedSelfConfigurator bsc = new MeshBasedSelfConfigurator(source, target, 0.6, 1.0);
        bsc.setMeasure("reference");
        List<SimpleClassifier> cp = bsc.getBestInitialClassifiers();
        ComplexClassifier cc = bsc.getZoomedHillTop(5, 10, cp);
        Mapping m2 = cc.mapping;
        Mapping m3 = m2.getBestOneToNMapping();
        PRFComputer prf = new PRFComputer();
        double p = prf.computePrecision(m2, reference);
        double r = prf.computeRecall(m2, reference);
        String output = p + "\t" + r + "\t" + 2.0 * p * r / (p + r) + "\n";
        System.out.println(output);
        return 2.0 * p * r / (p + r);
    }

    public static void main(String[] args) {
        KBInfo S = new KBInfo();
        S.endpoint = "E:/Work/Data/EAGLE/dbpedia-linkedmdb/source.csv";
        KBInfo T = new KBInfo();
        T.endpoint = "E:/Work/Data/EAGLE/dbpedia-linkedmdb/target.csv";
        CsvQueryModule qm = new CsvQueryModule(S);
        qm.setSeparation("\t");
        Cache source = new HybridCache();
        qm.fillAllInCache(source);
        CsvQueryModule qm2 = new CsvQueryModule(T);
        Cache target = new HybridCache();
        qm2.setSeparation("\t");
        qm2.fillAllInCache(target);
        Mapping reference = Mapping.readFromCsvFile("E:/Work/Data/EAGLE/dbpedia-linkedmdb/reference.csv");
        TransformationLearner tl = new TransformationLearner();
        ArrayList result = new ArrayList();
        for (int i = 0; i < 20; ++i) {
            Set<Rule> rules = tl.learnAllRules(source, target, reference, "director", "director");
            System.out.println(">> S -> T:" + rules);
            for (Rule rule : rules) {
                if (rule.isFromSourceToTarget()) {
                    source = tl.applyRuleToCacheUsingMapping(rule, source, target, "director", "director", reference);
                    continue;
                }
                target = tl.applyRuleToCacheUsingMapping(rule, target, source, "director", "director", reference.reverseSourceTarget());
            }
            rules = tl.learnAllRules(source, target, reference, "label", "label");
            System.out.println(">>" + rules);
            for (Rule rule : rules) {
                if (rule.isFromSourceToTarget()) {
                    source = tl.applyRuleToCacheUsingMapping(rule, source, target, "label", "label", reference);
                    continue;
                }
                target = tl.applyRuleToCacheUsingMapping(rule, target, source, "label", "label", reference.reverseSourceTarget());
            }
            String measure = "trigrams";
            String property = "label";
            String measureExpression = measure + "(x." + property + ", y." + property + ")";
            ExecutionEngine ee = new ExecutionEngine(source, target, "?x", "?y");
            for (double iter = 0.0; iter < 5.0; iter += 1.0) {
                Instruction inst1 = new Instruction(Instruction.Command.RUN, measureExpression, 1.0 - 0.1 * iter + "", -1, -1, -1);
                Mapping data1 = ee.executeRun(inst1);
                property = "director";
                measureExpression = measure + "(x." + property + ", y." + property + ")";
                Instruction inst2 = new Instruction(Instruction.Command.RUN, measureExpression, 1.0 - 0.1 * iter + "", -1, -1, -1);
                Mapping data2 = ee.executeRun(inst2);
                Mapping data = SetOperations.intersection(data1, data2);
                PRFComputer prf = new PRFComputer();
                double p = prf.computePrecision(data, reference);
                double r = prf.computeRecall(data, reference);
                System.out.println("Iteration " + i + "\t Threshold " + (1.0 - 0.1 * iter) + "\t" + p + "\t" + r + "\t" + 2.0 * p * r / (p + r));
            }
        }
        System.out.println(result);
    }
}

