/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.transformation.dictionary;

import de.uni_leipzig.simba.transformation.dictionary.Rule;
import de.uni_leipzig.simba.transformation.stringops.StringOps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dictionary {
    Map<String, Map<String, Double>> sourceTargetMap = new HashMap<String, Map<String, Double>>();

    public void addRule(Rule r) {
        if (this.sourceTargetMap.containsKey(r.source)) {
            if (this.sourceTargetMap.get(r.source).containsKey(r.target)) {
                this.sourceTargetMap.get(r.source).put(r.target, this.sourceTargetMap.get(r.source).get(r.target) + 1.0);
            } else {
                this.sourceTargetMap.get(r.source).put(r.target, 1.0);
            }
        } else {
            this.sourceTargetMap.put(r.source, new HashMap());
            this.sourceTargetMap.get(r.source).put(r.target, 1.0);
        }
    }

    public int size() {
        return this.sourceTargetMap.size();
    }

    public Set<String> generateRuleParts(String[] splits, Set<String> tabus) {
        HashSet<String> ruleParts = new HashSet<String>();
        for (int i = 0; i < splits.length; ++i) {
            String ruleSource = "";
            for (int j = i; j < splits.length && !tabus.contains(splits[j]); ++j) {
                ruleSource = ruleSource + StringOps.SEPARATOR + splits[j];
                ruleParts.add(ruleSource.trim());
            }
        }
        return ruleParts;
    }

    public void addRules(String source, String target) {
        String[] sourceSplit = source.split(StringOps.SEPARATOR);
        String[] targetSplit = target.split(StringOps.SEPARATOR);
        TreeSet<String> commonSubStrings = new TreeSet<String>();
        for (String s : sourceSplit) {
            for (String t : targetSplit) {
                if (!s.equals(t)) continue;
                commonSubStrings.add(s);
            }
        }
        Set<String> sourceRuleParts = this.generateRuleParts(sourceSplit, commonSubStrings);
        Set<String> targetRuleParts = this.generateRuleParts(targetSplit, commonSubStrings);
        for (String s : sourceRuleParts) {
            for (String t : targetRuleParts) {
                this.addRule(new Rule(s, t));
            }
        }
    }

    public Map<Rule, Double> getMostFrequentRules() {
        double max = 0.0;
        HashMap<Rule, Double> result = new HashMap<Rule, Double>();
        for (String source : this.sourceTargetMap.keySet()) {
            for (String target : this.sourceTargetMap.get(source).keySet()) {
                double value = this.sourceTargetMap.get(source).get(target);
                if (value > max) {
                    result = new HashMap();
                    result.put(new Rule(source, target), value);
                    max = value;
                    continue;
                }
                if (value != max) continue;
                result.put(new Rule(source, target), value);
            }
        }
        return result;
    }

    public Map<Rule, Double> getRulesWithMaxCoverage() {
        double max = 0.0;
        HashMap<Rule, Double> result = new HashMap<Rule, Double>();
        for (String source : this.sourceTargetMap.keySet()) {
            for (String target : this.sourceTargetMap.get(source).keySet()) {
                double value;
                double l1 = 0.0;
                double l2 = 0.0;
                if (!source.equalsIgnoreCase(Rule.EPSILON)) {
                    l1 = source.split(StringOps.SEPARATOR).length;
                }
                if (!target.equalsIgnoreCase(Rule.EPSILON)) {
                    l2 = target.split(StringOps.SEPARATOR).length;
                }
                if ((value = this.sourceTargetMap.get(source).get(target) * (l1 + l2)) > max) {
                    result = new HashMap();
                    result.put(new Rule(source, target), value);
                    max = value;
                    continue;
                }
                if (value != max) continue;
                result.put(new Rule(source, target), value);
            }
        }
        return result;
    }

    public String toString() {
        return this.sourceTargetMap.toString();
    }
}

