/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.specification;

import de.uni_leipzig.simba.controller.Parser;
import de.uni_leipzig.simba.specification.Operator;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkSpec {
    public List<LinkSpec> children = null;
    public Operator operator = null;
    public String filterExpression;
    public double threshold;
    public LinkSpec parent;
    public List<LinkSpec> dependencies;

    public LinkSpec() {
        this.threshold = -1.0;
        this.parent = null;
        this.dependencies = null;
    }

    public LinkSpec(String measure, double threshold) {
        this.parent = null;
        this.dependencies = null;
        this.readSpec(measure, threshold);
    }

    public void addChild(LinkSpec spec) {
        if (this.children == null) {
            this.children = new ArrayList<LinkSpec>();
        }
        this.children.add(spec);
    }

    public void addDependency(LinkSpec spec) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<LinkSpec>();
        }
        this.dependencies.add(spec);
    }

    public void removeDependency(LinkSpec spec) {
        if (this.dependencies.contains(spec)) {
            this.dependencies.remove(spec);
        }
        if (this.dependencies.isEmpty()) {
            this.dependencies = null;
        }
    }

    public boolean hasDependencies() {
        if (this.dependencies == null) {
            return false;
        }
        return !this.dependencies.isEmpty();
    }

    public boolean isEmpty() {
        return this.threshold < 0.0;
    }

    public boolean isAtomic() {
        if (this.children == null) {
            return true;
        }
        return this.children.isEmpty();
    }

    public void readSpec(String spec, double theta) {
        Parser p = new Parser(spec, this.threshold);
        if (p.isAtomic()) {
            this.filterExpression = spec;
            this.threshold = theta;
        } else {
            LinkSpec leftSpec = new LinkSpec();
            LinkSpec rightSpec = new LinkSpec();
            leftSpec.parent = this;
            rightSpec.parent = this;
            this.children = new ArrayList<LinkSpec>();
            this.children.add(leftSpec);
            this.children.add(rightSpec);
            if (p.getOperation().equalsIgnoreCase("AND")) {
                this.operator = Operator.AND;
                leftSpec.readSpec(p.term1, p.threshold1);
                rightSpec.readSpec(p.term2, p.threshold2);
                this.filterExpression = null;
                this.threshold = theta;
            } else if (p.getOperation().equalsIgnoreCase("MIN")) {
                this.operator = Operator.AND;
                leftSpec.readSpec(p.term1, theta);
                rightSpec.readSpec(p.term2, theta);
                this.filterExpression = null;
                this.threshold = theta;
            } else if (p.getOperation().equalsIgnoreCase("OR")) {
                this.operator = Operator.OR;
                leftSpec.readSpec(p.term1, p.threshold1);
                rightSpec.readSpec(p.term2, p.threshold2);
                this.filterExpression = null;
                this.threshold = theta;
            } else if (p.getOperation().equalsIgnoreCase("MAX")) {
                this.operator = Operator.OR;
                leftSpec.readSpec(p.term1, theta);
                rightSpec.readSpec(p.term2, theta);
                this.filterExpression = null;
                this.threshold = theta;
            } else if (p.getOperation().equalsIgnoreCase("XOR")) {
                this.operator = Operator.XOR;
                leftSpec.readSpec(p.term1, p.threshold1);
                rightSpec.readSpec(p.term2, p.threshold2);
                this.filterExpression = null;
                this.threshold = theta;
            } else if (p.getOperation().equalsIgnoreCase("MINUS")) {
                this.operator = Operator.MINUS;
                leftSpec.readSpec(p.term1, p.threshold1);
                rightSpec.readSpec(p.term2, p.threshold2);
                this.filterExpression = null;
                this.threshold = theta;
            } else if (p.getOperation().equalsIgnoreCase("ADD")) {
                this.operator = Operator.AND;
                leftSpec.readSpec(p.term1, (theta - p.coef2) / p.coef1);
                rightSpec.readSpec(p.term2, (theta - p.coef1) / p.coef2);
                this.filterExpression = spec;
                this.threshold = theta;
            }
        }
    }

    public List<LinkSpec> getAllLeaves() {
        ArrayList<LinkSpec> allLeaves = new ArrayList<LinkSpec>();
        if (this.isAtomic()) {
            allLeaves.add(this);
        } else {
            for (LinkSpec child : this.children) {
                allLeaves.addAll(child.getAllLeaves());
            }
        }
        return allLeaves;
    }

    public int size() {
        int size = 1;
        if (this.isEmpty()) {
            return 0;
        }
        if (this.isAtomic()) {
            return 1;
        }
        for (LinkSpec c : this.children) {
            size += c.size();
        }
        return size;
    }

    public int hashCode() {
        return (int)System.currentTimeMillis();
    }

    public LinkSpec clone() {
        LinkSpec clone = new LinkSpec();
        clone.threshold = this.threshold;
        clone.operator = this.operator;
        clone.filterExpression = this.filterExpression;
        ArrayList<LinkSpec> l = new ArrayList<LinkSpec>();
        for (LinkSpec c : this.children) {
            LinkSpec childCopy = c.clone();
            childCopy.parent = clone;
            l.add(childCopy);
        }
        return clone;
    }

    public String toString() {
        if (this.parent != null) {
            return "(" + this.filterExpression + ", " + this.threshold + ", " + (Object)((Object)this.operator) + ", " + this.parent.hashCode() + ") -> " + this.children;
        }
        return "(" + this.filterExpression + ", " + this.threshold + ", " + (Object)((Object)this.operator) + ", null,) -> " + this.children;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public String getMeasure() {
        if (this.isAtomic()) {
            return this.filterExpression;
        }
        return (Object)((Object)this.operator) + "(" + ")";
    }

    public static void main(String[] args) {
        LinkSpec spec = new LinkSpec();
        spec.readSpec("AND(trigrams(x.p, y.p)|0.7, euclidean(x.q, y.q)|0.3)", 0.8);
        System.out.println(spec + " " + spec.size());
    }
}

