/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.selfconfig;

import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.selfconfig.PseudoMeasures;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferencePseudoMeasures
extends PseudoMeasures {
    @Override
    public double getPseudoFMeasure(List<String> sourceUris, List<String> targetUris, Mapping result, double beta) {
        double p = this.getPseudoPrecision(result);
        double r = this.getPseudoRecall(sourceUris, targetUris, result);
        if (p == 0.0 && r == 0.0) {
            return 0.0;
        }
        double f = (1.0 + beta * beta) * p * r / (beta * beta * p + r);
        return f;
    }

    @Override
    public double getPseudoPrecision(Mapping result) {
        double p = result.map.keySet().size();
        double q = 0.0;
        for (String s : result.map.keySet()) {
            q += (double)result.map.get(s).size();
        }
        if (p == 0.0 || q == 0.0) {
            return 0.0;
        }
        return p / q;
    }

    @Override
    public double getPseudoRecall(List<String> sourceUris, List<String> targetUris, Mapping result) {
        double size = 0.0;
        for (String s : result.map.keySet()) {
            size += (double)result.map.get(s).size();
        }
        return size / (double)Math.min(sourceUris.size(), targetUris.size());
    }

    @Override
    public String getName() {
        return "Reference Pseudo F-Measure";
    }
}

