/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.selfconfig;

import de.uni_leipzig.simba.cache.MemoryCache;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.selfconfig.Measure;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PseudoMeasures
implements Measure {
    @Override
    public double getPseudoFMeasure(List<String> sourceUris, List<String> targetUris, Mapping result, double beta) {
        double p = this.getPseudoPrecision(result);
        double r = this.getPseudoRecall(sourceUris, targetUris, result);
        if (p == 0.0 && r == 0.0) {
            return 0.0;
        }
        double f = (1.0 + beta * beta) * p * r / (beta * beta * p + r);
        return f;
    }

    @Override
    public double getPseudoPrecision(Mapping result) {
        double p = result.map.keySet().size();
        double q = 0.0;
        for (String s : result.map.keySet()) {
            q += (double)result.map.get(s).size();
        }
        if (p == 0.0 || q == 0.0) {
            return 0.0;
        }
        return p / q;
    }

    @Override
    public double getPseudoRecall(List<String> sourceUris, List<String> targetUris, Mapping result) {
        double q = result.map.keySet().size();
        HashSet<String> values = new HashSet<String>();
        for (String s : result.map.keySet()) {
            for (String t : result.map.get(s).keySet()) {
                values.add(t);
            }
        }
        double reference = sourceUris.size() + targetUris.size();
        return (q + (double)values.size()) / reference;
    }

    public static void test() {
        MemoryCache source = new MemoryCache();
        MemoryCache target = new MemoryCache();
        source.addTriple("s1", "p1", "o11");
        source.addTriple("s1", "p2", "o12");
        source.addTriple("s2", "p1", "o21");
        source.addTriple("s2", "p2", "o22");
        source.addTriple("s2", "p2", "o21");
        target.addTriple("t1", "p1", "o11");
        target.addTriple("t1", "p2", "o12");
        target.addTriple("t2", "p1", "o21");
        target.addTriple("t2", "p2", "o22");
        target.addTriple("t3", "p1", "o31");
        Mapping m = new Mapping();
        m.add("s1", "t1", 1.0);
        m.add("s1", "t2", 1.0);
        m.add("s2", "t2", 1.0);
        System.out.println(new PseudoMeasures().getPseudoPrecision(m));
        System.out.println(new PseudoMeasures().getPseudoRecall(source.getAllUris(), target.getAllUris(), m));
    }

    public String getName() {
        return "Pseudo F-Measure";
    }

    public static void main(String[] args) {
        PseudoMeasures.test();
    }
}

