/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.selfconfig;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.evaluation.PRFComputer;
import de.uni_leipzig.simba.selfconfig.ComplexClassifier;
import de.uni_leipzig.simba.selfconfig.DisjunctiveMeshSelfConfigurator;
import de.uni_leipzig.simba.selfconfig.Experiment;
import de.uni_leipzig.simba.selfconfig.LinearMeshSelfConfigurator;
import de.uni_leipzig.simba.selfconfig.MeshBasedSelfConfigurator;
import de.uni_leipzig.simba.selfconfig.SimpleClassifier;
import java.util.List;

public class MyExperiment {
    public static String runAll(String source, String target, String reference, double coverage, double beta, String measure) {
        String output = "";
        output = output + MyExperiment.run(source, target, reference, coverage, beta, measure, "linear") + "\n";
        output = output + MyExperiment.run(source, target, reference, coverage, beta, measure, "conjunctive") + "\n";
        output = output + MyExperiment.run(source, target, reference, coverage, beta, measure, "disjunctive");
        return output;
    }

    public static String run(String source, String target, String reference, double coverage, double beta, String measure, String type) {
        Mapping r;
        Cache t;
        Cache s;
        if (source.endsWith("nt")) {
            if (source.contains("person")) {
                s = Experiment.readOAEIFile(source, "-Person");
                t = Experiment.readOAEIFile(target, "-Person");
                r = Experiment.readOAEIMapping(reference);
            } else {
                s = Experiment.readOAEIFile(source, "-Restaurant");
                t = Experiment.readOAEIFile(target, "-Restaurant");
                r = Experiment.readOAEIMapping(reference);
            }
        } else {
            s = Experiment.readFile(source);
            t = Experiment.readFile(target);
            r = Experiment.readReference(reference);
        }
        MeshBasedSelfConfigurator lsc = type.toLowerCase().startsWith("l") ? new LinearMeshSelfConfigurator(s, t, coverage, beta) : (type.toLowerCase().startsWith("d") ? new DisjunctiveMeshSelfConfigurator(s, t, coverage, beta) : new MeshBasedSelfConfigurator(s, t, coverage, beta));
        lsc.setMeasure(measure);
        long begin = System.currentTimeMillis();
        List<SimpleClassifier> cp = lsc.getBestInitialClassifiers();
        long middle = System.currentTimeMillis();
        ComplexClassifier cc = lsc.getZoomedHillTop(5, 10, cp);
        long end = System.currentTimeMillis();
        Mapping m = cc.mapping;
        m = lsc.getBestOneToOneMapping(m);
        PRFComputer prf = new PRFComputer();
        double precision = prf.computePrecision(m, r);
        double recall = prf.computeRecall(m, r);
        double f = prf.computeFScore(m, r);
        String output = type + "\t" + (middle - begin) / 1000L + "\t" + (end - middle) / 1000L + "\t" + (end - begin) / 1000L + "\t" + cc.fMeasure + "\t" + precision + "\t" + recall + "\t" + f;
        return output;
    }

    public static String testBeta(String source, String target, String reference, double coverage, double beta, String measure, String type) {
        Mapping r;
        Cache t;
        Cache s;
        long beginning = System.currentTimeMillis();
        if (source.endsWith("nt")) {
            if (source.contains("person")) {
                s = Experiment.readOAEIFile(source, "-Person");
                t = Experiment.readOAEIFile(target, "-Person");
                r = Experiment.readOAEIMapping(reference);
            } else {
                s = Experiment.readOAEIFile(source, "-Restaurant");
                t = Experiment.readOAEIFile(target, "-Restaurant");
                r = Experiment.readOAEIMapping(reference);
            }
        } else {
            s = Experiment.readFile(source);
            t = Experiment.readFile(target);
            r = Experiment.readReference(reference);
        }
        MeshBasedSelfConfigurator lsc = type.toLowerCase().startsWith("l") ? new LinearMeshSelfConfigurator(s, t, coverage, beta) : (type.toLowerCase().startsWith("d") ? new DisjunctiveMeshSelfConfigurator(s, t, coverage, beta) : new MeshBasedSelfConfigurator(s, t, coverage, beta));
        List<SimpleClassifier> cp = lsc.getBestInitialClassifiers();
        String output = "";
        for (double b = 0.1; b < 2.1; b += 0.1) {
            long begin = System.currentTimeMillis();
            MeshBasedSelfConfigurator msc = type.toLowerCase().startsWith("l") ? new LinearMeshSelfConfigurator(s, t, coverage, b) : (type.toLowerCase().startsWith("d") ? new DisjunctiveMeshSelfConfigurator(s, t, coverage, b) : new MeshBasedSelfConfigurator(s, t, coverage, b));
            msc.setMeasure(measure);
            long middle = System.currentTimeMillis();
            ComplexClassifier cc = msc.getZoomedHillTop(5, 10, cp);
            Mapping m = cc.mapping;
            m = Mapping.getBestOneToOneMappings(m);
            PRFComputer prf = new PRFComputer();
            double precision = prf.computePrecision(m, r);
            double recall = prf.computeRecall(m, r);
            double f = prf.computeFScore(m, r);
            long end = System.currentTimeMillis();
            output = output + type + "\t" + b + "\t" + (middle - begin) + "\t" + (end - middle) + "\t" + (end - begin) + "\t" + cc.fMeasure + "\t" + precision + "\t" + recall + "\t" + f + "\n";
        }
        return output;
    }

    public static void main(String[] args) {
        String result = "Type\tBeta\tMapping time\tRuntime\tTotaltime\tPseudo-F\tPrecision\tRecall\tReal F\n";
        String approach = "own";
        String classifier = "linear";
        result = result + "PERSONS1\n";
        result = result + "Type\tBeta\tMapping time\tRuntime\tTotaltime\tPseudo-F\tPrecision\tRecall\tReal F\n";
        result = result + MyExperiment.testBeta("E:/Work/Data/OAEI2010/person11.nt", "E:/Work/Data/OAEI2010/person12.nt", "E:/Work/Data/OAEI2010/dataset11_dat    aset12_goldstandard_person.xml", 0.6, 0.1, approach, classifier);
        result = result + "Type\tBeta\tMapping time\tRuntime\tTotaltime\tPseudo-F\tPrecision\tRecall\tReal F\n";
        result = result + "PERSONS2\n";
        result = result + MyExperiment.testBeta("E:/Work/Data/OAEI2010/person21.nt", "E:/Work/Data/OAEI2010/person22.nt", "E:/Work/Data/OAEI2010/dataset21_dataset22_goldstandard_person.xml", 0.6, 0.1, approach, classifier);
        result = result + "RESTAURANT\n";
        result = result + "Type\tBeta\tMapping time\tRuntime\tTotaltime\tPseudo-F\tPrecision\tRecall\tReal F\n";
        result = result + MyExperiment.testBeta("E:/Work/Data/OAEI2010/restaurant1.nt", "E:/Work/Data/OAEI2010/restaurant2.nt", "E:/Work/Data/OAEI2010/restaurant1_restaurant2_goldstandard_correct.rdf", 0.6, 0.1, approach, classifier);
        result = result + "DBLP-ACM\n";
        result = result + "Type\tBeta\tMapping time\tRuntime\tTotaltime\tPseudo-F\tPrecision\tRecall\tReal F\n";
        result = result + MyExperiment.testBeta("E:/Work/Data/Datenbanken/DBLP-ACM/DBLP.csv", "E:/Work/Data/Datenbanken/DBLP-ACM/ACM.csv", "E:/Work/Data/Datenbanken/DBLP-ACM/DBLP-ACM.csv", 0.6, 0.1, approach, classifier);
        result = result + "Amazon-Googleproducts\n";
        result = result + "Type\tBeta\tMapping time\tRuntime\tTotaltime\tPseudo-F\tPrecision\tRecall\tReal F\n";
        result = result + MyExperiment.testBeta("E:/Work/Data/Datenbanken/Amazon-GoogleProducts/Amazon.csv", "E:/Work/Data/Datenbanken/Amazon-GoogleProducts/GoogleProducts.csv", "E:/Work/Data/Datenbanken/Amazon-GoogleProducts/Amazon_GoogleProducts_perfectMapping.csv", 0.6, 0.1, approach, classifier);
        result = result + "Abt-Buy\n";
        result = result + "Type\tBeta\tMapping time\tRuntime\tTotaltime\tPseudo-F\tPrecision\tRecall\tReal F\n";
        result = result + MyExperiment.testBeta("E:/Work/Data/Datenbanken/Abt-Buy/Abt.csv", "E:/Work/Data/Datenbanken/Abt-Buy/Buy.csv", "E:/Work/Data/Datenbanken/Abt-Buy/abt_buy_perfectMapping.csv", 0.6, 0.1, approach, classifier);
        System.out.println(result);
    }
}

