/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.selfconfig;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.selfconfig.BooleanSelfConfigurator;
import de.uni_leipzig.simba.selfconfig.ComplexClassifier;
import de.uni_leipzig.simba.selfconfig.Measure;
import de.uni_leipzig.simba.selfconfig.PseudoMeasures;
import de.uni_leipzig.simba.selfconfig.ReferencePseudoMeasures;
import de.uni_leipzig.simba.selfconfig.SimpleClassifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeshBasedSelfConfigurator
extends BooleanSelfConfigurator {
    static Logger logger = Logger.getLogger((String)"LIMES");
    static String STRATEGY = "MAX";
    static String MEASURE = "reference";
    Measure _measure = MEASURE.equals("reference") ? new ReferencePseudoMeasures() : new PseudoMeasures();

    public MeshBasedSelfConfigurator(Cache source, Cache target, double minCoverage, double beta) {
        super(source, target, minCoverage, beta);
    }

    public static List<ComplexClassifier> generate(List<SimpleClassifier> classifiers, List<Double> min, List<Double> max, int n) {
        return null;
    }

    public static List<Double> copy(List<Double> l) {
        ArrayList<Double> copy = new ArrayList<Double>();
        for (int i = 0; i < l.size(); ++i) {
            copy.add(l.get(i));
        }
        return copy;
    }

    public static List<List<Double>> generateCoordinates(List<Double> min, List<Double> max, int n) {
        int dimensions = min.size();
        if (dimensions == 0) {
            return null;
        }
        ArrayList<List<Double>> result = new ArrayList<List<Double>>();
        double delta = (max.get(0) - min.get(0)) / (double)(n - 1);
        for (int i = 0; i < n; ++i) {
            ArrayList<Double> entry = new ArrayList<Double>();
            entry.add(min.get(0) + (double)i * delta);
            result.add(entry);
        }
        for (int dim = 1; dim < dimensions; ++dim) {
            ArrayList buffer = new ArrayList();
            for (int i = 0; i < result.size(); ++i) {
                int j;
                ArrayList<List<Double>> clones = new ArrayList<List<Double>>();
                for (j = 0; j < n; ++j) {
                    clones.add(MeshBasedSelfConfigurator.copy((List)result.get(i)));
                }
                delta = (max.get(dim) - min.get(dim)) / (double)(n - 1);
                for (j = 0; j < n; ++j) {
                    ((List)clones.get(j)).add(min.get(dim) + (double)j * delta);
                    buffer.add(clones.get(j));
                }
            }
            result = buffer;
        }
        return result;
    }

    public Map<Double, Mapping> getMappings(double min, double max, int n, SimpleClassifier cp) {
        HashMap<Double, Mapping> result = new HashMap<Double, Mapping>();
        double delta = (max - min) / (double)(n - 1);
        if (min == 0.0 && max == min) {
            return new HashMap<Double, Mapping>();
        }
        Mapping m = min == 0.0 && max != min ? this.executeClassifier(cp, min + delta) : this.executeClassifier(cp, min);
        m.initReversedMap();
        for (int i = 0; i < n; ++i) {
            double threshold = min + (double)i * delta;
            if (!(threshold > 0.0)) continue;
            result.put(threshold, m.getSubMap(threshold));
        }
        return result;
    }

    public ComplexClassifier getZoomedHillTop(int gridPoints, int iterations, List<SimpleClassifier> sc) {
        ComplexClassifier cc;
        logger.info((Object)"Beginning self-configuration process ... ");
        if (gridPoints < 5) {
            gridPoints = 5;
        }
        ComplexClassifier bestCc = cc = this.getHillTop(gridPoints, sc);
        double delta = 1.0 / ((double)gridPoints - 1.0);
        for (int i = 1; i < iterations; ++i) {
            if (cc.fMeasure == 1.0) {
                return cc;
            }
            logger.info((Object)("Current F-score = " + cc.fMeasure));
            logger.info((Object)("Current delta = " + delta));
            ArrayList<Double> min = new ArrayList<Double>();
            ArrayList<Double> max = new ArrayList<Double>();
            for (int j = 0; j < cc.classifiers.size(); ++j) {
                if (cc.classifiers.get((int)j).threshold >= delta) {
                    min.add(cc.classifiers.get((int)j).threshold - delta);
                } else {
                    min.add(0.0);
                }
                if (cc.classifiers.get((int)j).threshold + delta >= 1.0) {
                    max.add(1.0);
                    continue;
                }
                max.add(cc.classifiers.get((int)j).threshold + delta);
            }
            cc = this.getHillTop(min, max, gridPoints, cc.classifiers);
            if (bestCc.fMeasure <= cc.fMeasure) {
                bestCc = cc;
            } else {
                cc = bestCc;
            }
            delta = 2.0 * delta / ((double)gridPoints - 1.0);
        }
        logger.info((Object)("Final F-score = " + bestCc.fMeasure));
        return bestCc;
    }

    public ComplexClassifier getHillTop(int n, List<SimpleClassifier> sc) {
        ArrayList<Double> min = new ArrayList<Double>();
        ArrayList<Double> max = new ArrayList<Double>();
        for (int i = 0; i < sc.size(); ++i) {
            min.add(0.0);
            max.add(1.0);
        }
        return this.getHillTop(min, max, n, sc);
    }

    public ComplexClassifier getHillTop(List<Double> min, List<Double> max, int n, List<SimpleClassifier> sc) {
        int j;
        double sum;
        List point;
        logger.info((Object)("Getting hill top for dimensions described in " + sc));
        List<List<Double>> coordinates = MeshBasedSelfConfigurator.generateCoordinates(min, max, n);
        logger.info((Object)("Generated " + coordinates.size() + " grid points ..."));
        HashMap<Double, Map<Double, Mapping>> mappings = new HashMap<Double, Map<Double, Mapping>>();
        for (int i = 0; i < sc.size(); ++i) {
            mappings.put(new Double(i), this.getMappings(min.get(i), max.get(i), n, sc.get(i)));
        }
        double bestF = -1.0;
        ArrayList<List<Double>> highestPoints = new ArrayList<List<Double>>();
        Mapping bestMapping = new Mapping();
        Mapping m = new Mapping();
        for (int i = 0; i < coordinates.size(); ++i) {
            double f;
            List<Double> meshPoint = coordinates.get(i);
            ArrayList<Mapping> currentMappings = new ArrayList<Mapping>();
            for (int j2 = 0; j2 < meshPoint.size(); ++j2) {
                if (!(meshPoint.get(j2) > 0.0)) continue;
                currentMappings.add((Mapping)((Map)mappings.get(new Double(j2))).get(meshPoint.get(j2)));
            }
            if (currentMappings.isEmpty()) {
                f = 0.0;
            } else {
                m = MeshBasedSelfConfigurator.getIntersection(currentMappings);
                f = this._measure.getPseudoFMeasure(this.source.getAllUris(), this.target.getAllUris(), m, this.beta);
            }
            if (f > bestF) {
                highestPoints = new ArrayList();
                highestPoints.add(meshPoint);
                bestF = f;
                bestMapping = m;
                continue;
            }
            if (f != bestF) continue;
            highestPoints.add(meshPoint);
        }
        double bestSum = -1.0;
        List bestPoint = null;
        if (highestPoints.size() == 1) {
            bestPoint = (List)highestPoints.get(0);
        } else if (STRATEGY.toLowerCase().startsWith("max")) {
            for (int i = 0; i < highestPoints.size(); ++i) {
                point = (List)highestPoints.get(i);
                sum = 0.0;
                for (j = 0; j < point.size(); ++j) {
                    sum += ((Double)point.get(j)).doubleValue();
                }
                if (!(sum > bestSum)) continue;
                bestPoint = point;
                bestSum = sum;
            }
        } else {
            bestSum = sc.size();
            for (int i = 0; i < highestPoints.size(); ++i) {
                point = (List)highestPoints.get(i);
                sum = 0.0;
                for (j = 0; j < point.size(); ++j) {
                    sum += ((Double)point.get(j)).doubleValue();
                }
                if (!(sum < bestSum)) continue;
                bestPoint = point;
                bestSum = sum;
            }
        }
        ArrayList<SimpleClassifier> scList = new ArrayList<SimpleClassifier>();
        for (int i = 0; i < sc.size(); ++i) {
            if (!((Double)bestPoint.get(i) > 0.0)) continue;
            scList.add(sc.get(i).clone());
            ((SimpleClassifier)scList.get((int)(scList.size() - 1))).threshold = (Double)bestPoint.get(i);
        }
        ComplexClassifier cc = new ComplexClassifier(scList, bestF);
        cc.mapping = bestMapping;
        System.out.println("Best Classifier: " + cc.classifiers);
        System.out.println("Highest Point: " + bestPoint);
        System.out.println("FMeasure = " + bestF);
        return cc;
    }

    public static void testing() {
        ArrayList<Double> min = new ArrayList<Double>();
        ArrayList<Double> max = new ArrayList<Double>();
        min.add(0.0);
        min.add(0.0);
        min.add(0.0);
        max.add(5.0);
        max.add(5.0);
        max.add(5.0);
        System.out.println(MeshBasedSelfConfigurator.generateCoordinates(min, max, 3));
    }

    public static void main(String[] args) {
        MeshBasedSelfConfigurator.testing();
    }

    public void setMeasure(String m) {
        this._measure = m.equals("reference") ? new ReferencePseudoMeasures() : new PseudoMeasures();
    }
}

