/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.selfconfig;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.cache.MemoryCache;
import de.uni_leipzig.simba.data.Instance;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.execution.ExecutionEngine;
import de.uni_leipzig.simba.execution.Instruction;
import de.uni_leipzig.simba.selfconfig.Measure;
import de.uni_leipzig.simba.selfconfig.PseudoMeasures;
import de.uni_leipzig.simba.selfconfig.ReferencePseudoMeasures;
import de.uni_leipzig.simba.selfconfig.SelfConfigurator;
import de.uni_leipzig.simba.selfconfig.SimpleClassifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinearSelfConfigurator
implements SelfConfigurator {
    public boolean STRICT = true;
    public int ITERATIONS_MAX = 1000;
    public double MIN_THRESHOLD = 0.3;
    static Logger logger = Logger.getLogger((String)"LIMES");
    Strategy strategy = Strategy.FMEASURE;
    Cache source;
    Cache target;
    Map<String, Double> sourcePropertiesCoverageMap;
    Map<String, Double> targetPropertiesCoverageMap;
    Map<String, String> sourcePropertyTypeMap;
    Map<String, String> targetPropertyTypeMap;
    List<SimpleClassifier> buffer;
    double beta;
    Map<String, String> measures;
    public double learningRate = 0.25;
    public double kappa = 0.6;
    Measure _measure;
    String MEASURE = "own";

    public LinearSelfConfigurator() {
        this._measure = this.MEASURE.equals("reference") ? new ReferencePseudoMeasures() : new PseudoMeasures();
    }

    public LinearSelfConfigurator(Cache source, Cache target, double minCoverage, double beta) {
        this.source = source;
        this.target = target;
        this.beta = beta;
        this.sourcePropertiesCoverageMap = LinearSelfConfigurator.getPropertyStats(source, minCoverage);
        this.targetPropertiesCoverageMap = LinearSelfConfigurator.getPropertyStats(target, minCoverage);
        this.measures = new HashMap<String, String>();
        this.measures.put("euclidean", "numeric");
        this.measures.put("levenshtein", "string");
        this.measures.put("jaccard", "string");
        this.measures.put("trigrams", "string");
        this._measure = this.MEASURE.equals("reference") ? new ReferencePseudoMeasures() : new PseudoMeasures();
    }

    @Override
    public void computeMeasure(Cache source, Cache target, String[] parameters) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getMeasure() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getThreshold() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Mapping getResults() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public static Map<String, Double> getPropertyStats(Cache c, double minCoverage) {
        HashMap<String, Double> buffer = new HashMap<String, Double>();
        HashMap<String, Double> result = new HashMap<String, Double>();
        for (Instance i : c.getAllInstances()) {
            for (String p : i.getAllProperties()) {
                if (!buffer.containsKey(p)) {
                    buffer.put(p, 1.0);
                    continue;
                }
                buffer.put(p, (Double)buffer.get(p) + 1.0);
            }
        }
        double total = c.getAllInstances().size();
        for (String p : buffer.keySet()) {
            double coverage = (Double)buffer.get(p) / total;
            if (!(coverage >= minCoverage)) continue;
            result.put(p, coverage);
        }
        return result;
    }

    public static String getPropertyType(Cache c, String p) {
        for (Instance i : c.getAllInstances()) {
            if (!i.getAllProperties().contains(p)) continue;
            for (String value : i.getProperty(p)) {
                if (value.matches("[0-9]*\\.*[0-9]*")) continue;
                return "string";
            }
        }
        return "numeric";
    }

    public List<SimpleClassifier> getAllInitialClassifiers() {
        ArrayList<SimpleClassifier> initialClassifiers = new ArrayList<SimpleClassifier>();
        for (String p : this.sourcePropertiesCoverageMap.keySet()) {
            for (String q : this.sourcePropertiesCoverageMap.keySet()) {
                SimpleClassifier cp = this.getInitialClassifier(p, q, "jaccard");
                initialClassifiers.add(cp);
            }
        }
        return initialClassifiers;
    }

    public List<SimpleClassifier> getBestInitialClassifiers() {
        HashSet<String> measureList = new HashSet<String>();
        measureList.add("jaccard");
        measureList.add("levenshtein");
        measureList.add("trigrams");
        ArrayList<SimpleClassifier> initialClassifiers = new ArrayList<SimpleClassifier>();
        logger.info(this.sourcePropertiesCoverageMap);
        logger.info(this.targetPropertiesCoverageMap);
        for (String p : this.sourcePropertiesCoverageMap.keySet()) {
            double fMeasure = 0.0;
            SimpleClassifier bestClassifier = null;
            HashMap cp = new HashMap();
            for (String q : this.targetPropertiesCoverageMap.keySet()) {
                for (String measure : measureList) {
                    SimpleClassifier cps = this.getInitialClassifier(p, q, measure);
                    if (!(cps.fMeasure > fMeasure)) continue;
                    bestClassifier = cps.clone();
                    fMeasure = cps.fMeasure;
                }
            }
            if (bestClassifier == null) continue;
            initialClassifiers.add(bestClassifier);
        }
        return initialClassifiers;
    }

    private SimpleClassifier getInitialClassifier(String sourceProperty, String targetProperty, String measure) {
        double fMax = 0.0;
        double theta = 1.0;
        for (double threshold = 1.0; threshold > this.MIN_THRESHOLD; threshold -= this.learningRate) {
            Mapping mapping = this.execute(sourceProperty, targetProperty, measure, threshold);
            double fMeasure = this._measure.getPseudoFMeasure(this.source.getAllUris(), this.target.getAllUris(), mapping, this.beta);
            System.out.println("Source: " + sourceProperty + "" + " Target: " + targetProperty + " Threshold " + threshold + " leads to F-Measure " + fMeasure);
            if (this.STRICT) {
                if (fMeasure > fMax) {
                    fMax = fMeasure;
                    theta = threshold;
                }
            } else if (fMeasure >= fMax) {
                fMax = fMeasure;
                theta = threshold;
            }
            if (fMeasure < fMax) break;
        }
        SimpleClassifier cp = new SimpleClassifier(measure, theta);
        cp.fMeasure = fMax;
        cp.sourceProperty = sourceProperty;
        cp.targetProperty = targetProperty;
        return cp;
    }

    public Mapping getMapping(List<SimpleClassifier> classifiers) {
        classifiers = this.normalizeClassifiers(classifiers);
        HashMap<SimpleClassifier, Mapping> mappings = new HashMap<SimpleClassifier, Mapping>();
        for (int i = 0; i < classifiers.size(); ++i) {
            double threshold = 1.0 + classifiers.get((int)i).weight - 1.0 / this.kappa;
            if (!(threshold > 0.0)) continue;
            Mapping m = this.executeClassifier(classifiers.get(i), threshold);
            mappings.put(classifiers.get(i), m);
        }
        System.out.println(mappings);
        return this.getOverallMapping(mappings, 1.0);
    }

    public Mapping getOverallMapping(Map<SimpleClassifier, Mapping> mappings, double threshold) {
        if (mappings.isEmpty()) {
            return new Mapping();
        }
        Mapping reference = mappings.get(mappings.keySet().iterator().next());
        Mapping result = new Mapping();
        for (String s : reference.map.keySet()) {
            for (String t : reference.map.get(s).keySet()) {
                double score = 0.0;
                for (SimpleClassifier cp : mappings.keySet()) {
                    score += cp.weight * mappings.get(cp).getSimilarity(s, t);
                }
                if (!(score >= threshold)) continue;
                result.add(s, t, score);
            }
        }
        return result;
    }

    public List<SimpleClassifier> normalizeClassifiers(List<SimpleClassifier> classifiers) {
        double total = 0.0;
        for (SimpleClassifier cp : classifiers) {
            total += cp.weight;
        }
        for (SimpleClassifier cp : classifiers) {
            cp.weight /= total * this.kappa;
        }
        return classifiers;
    }

    public List<SimpleClassifier> getInitialOverallClassifiers(List<SimpleClassifier> classifiers) {
        if (this.strategy.equals((Object)Strategy.FMEASURE)) {
            double total = 0.0;
            for (SimpleClassifier cp : classifiers) {
                total += cp.fMeasure;
            }
            for (SimpleClassifier cp : classifiers) {
                cp.weight = cp.fMeasure / (total * this.kappa);
            }
        }
        return classifiers;
    }

    public double computeNext(List<SimpleClassifier> classifiers, int index) {
        classifiers.get((int)index).weight -= this.learningRate;
        classifiers = this.normalizeClassifiers(classifiers);
        Mapping m = this.getMapping(classifiers);
        this.buffer = classifiers;
        return this._measure.getPseudoFMeasure(this.source.getAllUris(), this.target.getAllUris(), m, this.beta);
    }

    public List<SimpleClassifier> learnClassifer(List<SimpleClassifier> classifiers) {
        classifiers = this.normalizeClassifiers(classifiers);
        Mapping m = this.getMapping(classifiers);
        double f = this._measure.getPseudoFMeasure(this.source.getAllUris(), this.target.getAllUris(), m, this.beta);
        if (f == 1.0) {
            return classifiers;
        }
        int dimensions = classifiers.size();
        int direction = 0;
        int iterations = 0;
        List<SimpleClassifier> bestClassifiers = null;
        double bestF = f;
        while (iterations <= this.ITERATIONS_MAX) {
            ++iterations;
            double index = -1.0;
            for (int i = 0; i < dimensions; ++i) {
                double fMeasure = this.computeNext(classifiers, i);
                if (!(fMeasure > bestF)) continue;
                bestF = fMeasure;
                index = i;
                bestClassifiers = this.buffer;
            }
            if (bestF == f) {
                System.out.println(">>>> Walking along direction " + direction);
                this.computeNext(classifiers, direction);
                bestClassifiers = this.buffer;
                ++direction;
                direction %= dimensions;
            } else if (bestF < f) {
                return bestClassifiers;
            }
            classifiers = bestClassifiers;
            System.out.println(">> Iteration " + iterations + ": " + classifiers + " F-Measure = " + bestF);
        }
        return classifiers;
    }

    public static void test() {
        MemoryCache source = new MemoryCache();
        MemoryCache target = new MemoryCache();
        source.addTriple("s1", "name", "xiua");
        source.addTriple("s1", "surname", "huong");
        source.addTriple("s2", "name", "xilua");
        source.addTriple("s2", "surname", "huo");
        source.addTriple("s3", "name", "xiang");
        source.addTriple("s3", "surname", "hu");
        target.addTriple("t1", "name", "xioa");
        target.addTriple("t1", "surname", "huon");
        target.addTriple("t2", "name", "xilua");
        target.addTriple("t2", "surname", "huo");
        target.addTriple("t3", "name", "xiang");
        target.addTriple("t3", "surname", "hu");
        LinearSelfConfigurator lsc = new LinearSelfConfigurator(source, target, 0.6, 1.0);
        List<SimpleClassifier> cp = lsc.getBestInitialClassifiers();
        System.out.println("Classifier:" + cp);
        cp = lsc.getInitialOverallClassifiers(cp);
        System.out.println("Normalized classifiers:" + cp);
    }

    public static void main(String[] args) {
        LinearSelfConfigurator.test();
    }

    public Mapping executeClassifier(SimpleClassifier c, double threshold) {
        return this.execute(c.sourceProperty, c.targetProperty, c.measure, threshold);
    }

    public Mapping execute(String sourceProperty, String targetProperty, String measure, double threshold) {
        String measureExpression = measure + "(x." + sourceProperty + ", y." + targetProperty + ")";
        Instruction inst = new Instruction(Instruction.Command.RUN, measureExpression, threshold + "", -1, -1, -1);
        ExecutionEngine ee = new ExecutionEngine(this.source, this.target, "?x", "?y");
        return ee.executeRun(inst);
    }

    public Mapping getBestOneToOneMapping(Mapping m) {
        Mapping result = new Mapping();
        for (String s : m.map.keySet()) {
            double maxSim = 0.0;
            HashSet<String> target = new HashSet<String>();
            for (String t : m.map.get(s).keySet()) {
                if (m.getSimilarity(s, t) == maxSim) {
                    target.add(t);
                }
                if (!(m.getSimilarity(s, t) > maxSim)) continue;
                maxSim = m.getSimilarity(s, t);
                target = new HashSet();
                target.add(t);
            }
            for (String t : target) {
                result.add(s, t, maxSim);
            }
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Strategy {
        FMEASURE,
        THRESHOLD,
        PRECISION,
        RECALL;

    }
}

