/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.selfconfig;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.cache.HybridCache;
import de.uni_leipzig.simba.cache.MemoryCache;
import de.uni_leipzig.simba.data.Instance;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.evaluation.PRFComputer;
import de.uni_leipzig.simba.io.KBInfo;
import de.uni_leipzig.simba.query.CsvQueryModule;
import de.uni_leipzig.simba.selfconfig.BooleanSelfConfigurator;
import de.uni_leipzig.simba.selfconfig.ComplexClassifier;
import de.uni_leipzig.simba.selfconfig.MeshBasedSelfConfigurator;
import de.uni_leipzig.simba.selfconfig.SimpleClassifier;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Experiment {
    static Logger logger = Logger.getLogger((String)"LIMES");
    static String SEPARATOR = "\t";
    static String CSVSEPARATOR = ",";

    public static Cache readFile(String file) {
        MemoryCache c = new MemoryCache();
        String s = "";
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
            s = reader.readLine();
            String[] properties = s.split(SEPARATOR);
            s = reader.readLine();
            while (s != null) {
                s = s.toLowerCase();
                s = StringEscapeUtils.unescapeHtml((String)s);
                String[] split = s.split(SEPARATOR);
                for (int i = 1; i < properties.length; ++i) {
                    try {
                        c.addTriple(split[0], properties[i], split[i]);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                s = reader.readLine();
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return c;
    }

    public static Mapping readOAEIMapping(String file) {
        Mapping m = new Mapping();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
            String s = reader.readLine();
            String e1 = "";
            while (s != null) {
                String[] split = s.split(" ");
                if (s.contains("entity1")) {
                    e1 = s.substring(s.indexOf("=") + 2, s.lastIndexOf(">") - 2);
                } else if (s.contains("entity2")) {
                    String e2 = s.substring(s.indexOf("=") + 2, s.lastIndexOf(">") - 2);
                    m.add(e1, e2, 1.0);
                }
                s = reader.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return m;
    }

    public static Cache readOAEIFile(String file, String token) {
        MemoryCache c = new MemoryCache();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
            String s = reader.readLine();
            while (s != null) {
                String[] split = s.split(" ");
                String value = split[2];
                if (split.length > 3) {
                    for (int i = 3; i < split.length; ++i) {
                        value = value + " " + split[i];
                    }
                }
                if (split[0].contains(token) && !split[1].contains("#type")) {
                    c.addTriple(split[0].substring(1, split[0].length() - 1), split[1].substring(1, split[1].length() - 1), value.substring(1, value.length() - 3).toLowerCase());
                }
                s = reader.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return c;
    }

    public static Mapping readReference(String file) {
        Mapping m = new Mapping();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
            String s = reader.readLine();
            String[] properties = s.split(SEPARATOR);
            s = reader.readLine();
            while (s != null) {
                s = s.toLowerCase();
                s = StringEscapeUtils.unescapeHtml((String)s);
                String[] split = s.split(SEPARATOR);
                m.add(split[0], split[1], 1.0);
                s = reader.readLine();
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return m;
    }

    public ArrayList<Double> runExperiment(String source, String target, String reference, double coverage, double beta, boolean cleanUp) {
        Cache s = Experiment.readFile(source);
        Cache t = Experiment.readFile(target);
        Mapping r = Experiment.readReference(reference);
        BooleanSelfConfigurator bsc = new BooleanSelfConfigurator(s, t, coverage, beta);
        List<SimpleClassifier> cp = bsc.getBestInitialClassifiers();
        cp = bsc.learnClassifer(cp);
        Mapping m = bsc.getMapping(cp);
        PRFComputer prf = new PRFComputer();
        if (cleanUp) {
            m = bsc.getBestOneToOneMapping(m);
        }
        ArrayList<Double> result = new ArrayList<Double>();
        result.add(prf.computePrecision(m, r));
        result.add(prf.computeRecall(m, r));
        result.add(prf.computeFScore(m, r));
        return result;
    }

    public static void test2() {
        Cache source = Experiment.readOAEIFile("E:/Work/Data/OAEI2010/restaurant1.nt", "-Restaurant");
        Experiment.toCsvFile(source, "E:/Work/Data/OAEI2010/restaurant1.csv");
        Cache target = Experiment.readOAEIFile("E:/Work/Data/OAEI2010/restaurant2.nt", "-Restaurant");
        Experiment.toCsvFile(target, "E:/Work/Data/OAEI2010/restaurant2.csv");
        Mapping reference = Experiment.readOAEIMapping("E:/Work/Data/OAEI2010/restaurant1_restaurant2_goldstandard.rdf");
        Experiment.toCsvFile(reference, "E:/Work/Data/OAEI2010/restaurant-reference.csv");
    }

    public static void test3() {
        KBInfo S = new KBInfo();
        S.endpoint = "E:/Work/Data/EAGLE/dbpedia-linkedmdb/source.csv";
        KBInfo T = new KBInfo();
        T.endpoint = "E:/Work/Data/EAGLE/dbpedia-linkedmdb/target.csv";
        CsvQueryModule qm = new CsvQueryModule(S);
        qm.setSeparation("\t");
        HybridCache source = new HybridCache();
        qm.fillAllInCache(source);
        CsvQueryModule qm2 = new CsvQueryModule(T);
        HybridCache target = new HybridCache();
        qm2.setSeparation("\t");
        qm2.fillAllInCache(target);
        Mapping reference = Mapping.readFromCsvFile("E:/Work/Data/EAGLE/dbpedia-linkedmdb/reference.csv");
        MeshBasedSelfConfigurator bsc = new MeshBasedSelfConfigurator(source, target, 0.6, 1.0);
        bsc.setMeasure("reference");
        List<SimpleClassifier> cp = bsc.getBestInitialClassifiers();
        ComplexClassifier cc = bsc.getZoomedHillTop(5, 10, cp);
        Mapping m2 = cc.mapping;
        Mapping m3 = bsc.getBestOneToOneMapping(m2);
        PRFComputer prf = new PRFComputer();
        double p = prf.computePrecision(m3, reference);
        double r = prf.computeRecall(m3, reference);
        String output = p + "\t" + r + "\t" + 2.0 * p * r / (p + r) + "\n";
        System.out.println(output);
    }

    public static void test() {
        long begin = System.currentTimeMillis();
        Cache source = Experiment.readOAEIFile("E:/Work/Data/OAEI2010/person21.nt", "-Person");
        Cache target = Experiment.readOAEIFile("E:/Work/Data/OAEI2010/person22.nt", "-Person");
        Mapping reference = Experiment.readOAEIMapping("E:/Work/Data/OAEI2010/dataset21_dataset22_goldstandard_person.xml");
        MeshBasedSelfConfigurator bsc = new MeshBasedSelfConfigurator(source, target, 0.6, 1.0);
        bsc.setMeasure("reference");
        List<SimpleClassifier> cp = bsc.getBestInitialClassifiers();
        logger.info(cp);
        Mapping m = bsc.getMapping(cp);
        PRFComputer prf = new PRFComputer();
        Mapping m1 = bsc.getBestOneToOneMapping(m);
        long middle = System.currentTimeMillis();
        String output = "Iteration\tPrecision\tRecall\tF-Measure\n";
        Mapping m2 = new Mapping();
        Mapping m3 = new Mapping();
        for (int i = 1; i < 2; ++i) {
            ComplexClassifier cc = bsc.getZoomedHillTop(5, 10, cp);
            m2 = cc.mapping;
            m3 = bsc.getBestOneToOneMapping(m2);
            double p = prf.computePrecision(m2, reference);
            double r = prf.computeRecall(m2, reference);
            output = output + i + "\t" + p + "\t" + r + "\t" + 2.0 * p * r / (p + r) + "\n";
        }
        System.out.println(m.size() + " " + prf.computeFScore(m, reference));
        System.out.println(m1.size() + " " + prf.computeFScore(m1, reference));
        System.out.println(m2.size() + " " + prf.computeFScore(m2, reference));
        System.out.println(m3.size() + " " + prf.computeFScore(m3, reference));
        long end = System.currentTimeMillis();
        System.out.println("Experiment carried out in " + (double)(end - begin) / 1000.0 + " seconds");
        System.out.println("Property mapping took " + (double)(middle - begin) / 1000.0 + " seconds");
        System.out.println("Finding mapping took " + (double)(end - middle) / 1000.0 + " seconds");
    }

    public static void toCsvFile(Cache c, String outputFile) {
        Set<String> pSet = c.getAllInstances().get(0).getAllProperties();
        try {
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            writer.print("ID");
            for (String p : pSet) {
                writer.print(CSVSEPARATOR + p);
            }
            writer.print("\n");
            ArrayList<Instance> instances = c.getAllInstances();
            for (Instance instance : instances) {
                writer.print(instance.getUri());
                for (String p : pSet) {
                    writer.print(CSVSEPARATOR + instance.getProperty(p).first());
                }
                writer.print("\n");
            }
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void toCsvFile(Mapping m, String outputFile) {
        try {
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            writer.print("ID");
            for (String m1 : m.map.keySet()) {
                for (String m2 : m.map.get(m1).keySet()) {
                    writer.println(m1 + CSVSEPARATOR + m2);
                }
            }
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            PatternLayout layout = new PatternLayout("%d{dd.MM.yyyy HH:mm:ss} %-5p [%t] %l: %m%n");
            FileAppender fileAppender = new FileAppender((Layout)layout, "E:/tmp/experiment.log", false);
            fileAppender.setLayout((Layout)layout);
            logger.addAppender((Appender)fileAppender);
        }
        catch (Exception e) {
            logger.warn((Object)"Exception creating file appender.");
        }
        Experiment.test3();
    }
}

