/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.selfconfig;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.cache.MemoryCache;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.execution.ExecutionEngine;
import de.uni_leipzig.simba.execution.Instruction;
import de.uni_leipzig.simba.selfconfig.ComplexClassifier;
import de.uni_leipzig.simba.selfconfig.LinearSelfConfigurator;
import de.uni_leipzig.simba.selfconfig.Measure;
import de.uni_leipzig.simba.selfconfig.PseudoMeasures;
import de.uni_leipzig.simba.selfconfig.ReferencePseudoMeasures;
import de.uni_leipzig.simba.selfconfig.SimpleClassifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BooleanSelfConfigurator
extends LinearSelfConfigurator {
    Measure _measure;
    String MEASURE = "reference";

    @Override
    public Mapping getBestOneToOneMapping(Mapping m) {
        Mapping result = new Mapping();
        for (String s : m.map.keySet()) {
            double maxSim = 0.0;
            HashSet<String> target = new HashSet<String>();
            for (String t : m.map.get(s).keySet()) {
                if (m.getSimilarity(s, t) == maxSim) {
                    target.add(t);
                }
                if (!(m.getSimilarity(s, t) > maxSim)) continue;
                maxSim = m.getSimilarity(s, t);
                target = new HashSet();
                target.add(t);
            }
            for (String t : target) {
                result.add(s, t, maxSim);
            }
        }
        return result;
    }

    public BooleanSelfConfigurator(Cache source, Cache target, double minCoverage, double beta) {
        this.source = source;
        this.target = target;
        this.beta = beta;
        this.sourcePropertiesCoverageMap = BooleanSelfConfigurator.getPropertyStats(source, minCoverage);
        this.targetPropertiesCoverageMap = BooleanSelfConfigurator.getPropertyStats(target, minCoverage);
        this.measures = new HashMap();
        this.measures.put("euclidean", "numeric");
        this.measures.put("levenshtein", "string");
        this.measures.put("jaccard", "string");
        this.measures.put("trigrams", "string");
        this._measure = this.MEASURE.equals("reference") ? new ReferencePseudoMeasures() : new PseudoMeasures();
    }

    public ComplexClassifier computeNext(ComplexClassifier classifier, int index) {
        ComplexClassifier cc = classifier.clone();
        ComplexClassifier result = new ComplexClassifier(null, 0.0);
        if (cc.classifiers.get((int)index).threshold > this.learningRate) {
            cc.classifiers.get((int)index).threshold -= this.learningRate;
            Mapping m = this.getMapping(cc.classifiers);
            result.classifiers = cc.classifiers;
            result.fMeasure = this._measure.getPseudoFMeasure(this.source.getAllUris(), this.target.getAllUris(), m, this.beta);
            return result;
        }
        if (cc.classifiers.size() > index + 1) {
            ArrayList<SimpleClassifier> cp = new ArrayList<SimpleClassifier>();
            for (int i = 0; i < cc.classifiers.size(); ++i) {
                if (i == index) continue;
                cp.add(cc.classifiers.get(i));
            }
            Mapping m = this.getMapping(cp);
            result.classifiers = cp;
            result.fMeasure = this._measure.getPseudoFMeasure(this.source.getAllUris(), this.target.getAllUris(), m, this.beta);
            return result;
        }
        return result;
    }

    @Override
    public Mapping getMapping(List<SimpleClassifier> classifiers) {
        ArrayList<Mapping> mappings = new ArrayList<Mapping>();
        for (int i = 0; i < classifiers.size(); ++i) {
            Mapping m = this.executeClassifier(classifiers.get(i), classifiers.get((int)i).threshold);
            mappings.add(m);
        }
        Mapping result = BooleanSelfConfigurator.getIntersection(mappings);
        return result;
    }

    @Override
    public Mapping executeClassifier(SimpleClassifier c, double threshold) {
        return this.execute(c.sourceProperty, c.targetProperty, c.measure, threshold);
    }

    @Override
    public Mapping execute(String sourceProperty, String targetProperty, String measure, double threshold) {
        String measureExpression = measure + "(x." + sourceProperty + ", y." + targetProperty + ")";
        Instruction inst = new Instruction(Instruction.Command.RUN, measureExpression, threshold + "", -1, -1, -1);
        ExecutionEngine ee = new ExecutionEngine(this.source, this.target, "?x", "?y");
        return ee.executeRun(inst);
    }

    public static Mapping getIntersection(List<Mapping> mappings) {
        if (mappings.isEmpty()) {
            return new Mapping();
        }
        Mapping reference = mappings.get(0);
        Mapping result = new Mapping();
        for (String s : reference.map.keySet()) {
            for (String t : reference.map.get(s).keySet()) {
                boolean maps = true;
                for (int i = 1; i < mappings.size(); ++i) {
                    Mapping m = mappings.get(i);
                    if (m.contains(s, t)) continue;
                    maps = false;
                }
                if (!maps) continue;
                result.add(s, t, 1.0);
            }
        }
        return result;
    }

    @Override
    public List<SimpleClassifier> learnClassifer(List<SimpleClassifier> classifiers) {
        classifiers = this.normalizeClassifiers(classifiers);
        Mapping m = this.getMapping(classifiers);
        double f = this._measure.getPseudoFMeasure(this.source.getAllUris(), this.target.getAllUris(), m, this.beta);
        if (f == 1.0) {
            return classifiers;
        }
        ComplexClassifier classifier = new ComplexClassifier(classifiers, f);
        ComplexClassifier bestClassifier = null;
        ComplexClassifier bestGlobalClassifier = classifier.clone();
        double bestF = 0.0;
        double globalBestF = f;
        int direction = 0;
        int iterations = 0;
        while (iterations <= this.ITERATIONS_MAX) {
            ++iterations;
            int index = -1;
            bestF = 0.0;
            for (int i = 0; i < classifier.classifiers.size(); ++i) {
                ComplexClassifier cc = this.computeNext(classifier, i);
                if (!(cc.fMeasure > bestF)) continue;
                bestF = cc.fMeasure;
                index = i;
                bestClassifier = cc;
            }
            if (bestF < globalBestF) {
                return bestGlobalClassifier.classifiers;
            }
            if (bestF == globalBestF) {
                System.out.println(">>>> Walking along direction " + direction);
                if (direction >= classifier.classifiers.size()) {
                    direction = 0;
                }
                bestClassifier = this.computeNext(classifier, direction);
                ++direction;
                direction %= classifier.classifiers.size();
            }
            bestGlobalClassifier = bestClassifier.clone();
            globalBestF = bestF;
            classifier = bestClassifier;
            System.out.println(">> Iteration " + iterations + ": " + classifier.classifiers + " F-Measure = " + globalBestF + " Mapping = " + this.getMapping(classifiers));
        }
        return bestGlobalClassifier.classifiers;
    }

    public static void testIntersection() {
        Mapping m1 = new Mapping();
        m1.add("s1", "t1", 0.8);
        m1.add("s2", "t2", 0.8);
        m1.add("s3", "t3", 0.8);
        Mapping m2 = new Mapping();
        m2.add("s1", "t1", 0.8);
        m2.add("s3", "t3", 0.8);
        ArrayList<Mapping> list = new ArrayList<Mapping>();
        list.add(m1);
        list.add(m2);
    }

    public void testa() {
        MemoryCache source = new MemoryCache();
        MemoryCache target = new MemoryCache();
        source.addTriple("s1", "name", "xigang");
        source.addTriple("s1", "surname", "hugong");
        source.addTriple("s2", "name", "xigang");
        source.addTriple("s2", "surname", "huo");
        source.addTriple("s3", "name", "xiang");
        source.addTriple("s3", "surname", "hu");
        target.addTriple("t1", "name", "xigang");
        target.addTriple("t1", "surname", "hugon");
        target.addTriple("t2", "name", "xigang");
        target.addTriple("t2", "surname", "huo");
        target.addTriple("t3", "name", "xiang");
        target.addTriple("t3", "surname", "hu");
        BooleanSelfConfigurator bsc = new BooleanSelfConfigurator(source, target, 0.6, 1.0);
        List<SimpleClassifier> cp = bsc.getBestInitialClassifiers();
        System.out.println("Classifier:" + cp);
        cp = bsc.getInitialOverallClassifiers(cp);
        System.out.println("Normalized classifiers:" + cp);
        Mapping m = bsc.getMapping(cp);
        System.out.println("Initial FMeasure = " + this._measure.getPseudoFMeasure(source.getAllUris(), target.getAllUris(), m, bsc.beta));
        cp = bsc.learnClassifer(cp);
        System.out.println("Best classifier:" + cp);
        m = bsc.getMapping(cp);
        System.out.println("Best F-Measure = " + this._measure.getPseudoFMeasure(source.getAllUris(), target.getAllUris(), m, bsc.beta));
    }

    public static void main(String[] args) {
        new BooleanSelfConfigurator(null, null, 0.0, 0.0).testa();
    }
}

