/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.query;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.rdf.model.Model;
import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.io.KBInfo;
import de.uni_leipzig.simba.preprocessing.Preprocessor;
import de.uni_leipzig.simba.query.ModelRegistry;
import de.uni_leipzig.simba.query.QueryModule;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class SparqlQueryModule
implements QueryModule {
    KBInfo kb;

    public SparqlQueryModule(KBInfo kbinfo) {
        this.kb = kbinfo;
    }

    public void fillCache(Cache cache) {
        this.fillCache(cache, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillCache(Cache cache, boolean sparql) {
        int i;
        Logger logger = Logger.getLogger((String)"LIMES");
        long startTime = System.currentTimeMillis();
        Iterator<String> iter = this.kb.prefixes.keySet().iterator();
        String query = "";
        while (iter.hasNext()) {
            String key = iter.next();
            query = query + "PREFIX " + key + ": <" + this.kb.prefixes.get(key) + ">\n";
        }
        query = query + "SELECT DISTINCT " + this.kb.var;
        for (int i2 = 0; i2 < this.kb.properties.size(); ++i2) {
            query = query + " ?v" + i2;
        }
        query = query + "\n";
        if (this.kb.graph != null) {
            if (!this.kb.graph.equals(" ") && this.kb.graph.length() > 3) {
                logger.info((Object)("Query Graph: " + this.kb.graph));
                query = query + "FROM <" + this.kb.graph + ">\n";
            } else {
                this.kb.graph = null;
            }
        }
        if (this.kb.restrictions.size() > 0) {
            iter = this.kb.restrictions.iterator();
            query = query + "WHERE {\n";
            for (i = 0; i < this.kb.restrictions.size(); ++i) {
                String where = this.kb.restrictions.get(i).trim();
                if (where.length() <= 3) continue;
                query = query + where + " .\n";
            }
        }
        if (this.kb.properties.size() > 0) {
            logger.info((Object)("Properties are " + this.kb.properties));
            String optional = "";
            for (i = 0; i < this.kb.properties.size(); ++i) {
                optional = optional + this.kb.var + " " + this.kb.properties.get(i) + " ?v" + i + " .\n";
            }
            int varCount = 1;
            while (optional.contains("/")) {
                optional = optional.replace("/", " ?w" + varCount + " .\n?w" + varCount + " ");
                ++varCount;
            }
            query = query + optional;
        }
        String[] q = query.split("\n");
        query = "";
        for (int ql = 0; ql < q.length; ++ql) {
            if (q[ql].contains("^")) {
                String[] sp = q[ql].replaceAll("\\^", "").split(" ");
                query = query + sp[2] + " " + sp[1] + " " + sp[0] + " " + sp[3] + "\n";
                continue;
            }
            query = query + q[ql] + "\n";
        }
        if (this.kb.restrictions.size() > 0) {
            query = query + "}";
        }
        logger.info((Object)("Query issued is \n" + query));
        logger.info((Object)"Querying the endpoint.");
        int offset = 0;
        boolean moreResults = false;
        int counter = 0;
        int counter2 = 0;
        String basicQuery = query;
        do {
            QueryExecution qexec;
            logger.info((Object)("Getting statements " + offset + " to " + (offset + this.kb.pageSize)));
            if (this.kb.pageSize > 0) {
                query = basicQuery + " LIMIT " + this.kb.pageSize + " OFFSET " + offset;
            }
            Query sparqlQuery = QueryFactory.create((String)query, (Syntax)Syntax.syntaxARQ);
            if (!sparql) {
                Model model = ModelRegistry.getInstance().getMap().get(this.kb.endpoint);
                if (model == null) {
                    throw new RuntimeException("No model with id '" + this.kb.endpoint + "' registered");
                }
                qexec = QueryExecutionFactory.create((Query)sparqlQuery, (Model)model);
            } else {
                qexec = this.kb.graph != null ? QueryExecutionFactory.sparqlService((String)this.kb.endpoint, (Query)sparqlQuery, (String)this.kb.graph) : QueryExecutionFactory.sparqlService((String)this.kb.endpoint, (Query)sparqlQuery);
            }
            ResultSet results = qexec.execSelect();
            try {
                if (results.hasNext()) {
                    moreResults = true;
                } else {
                    moreResults = false;
                    break;
                }
                while (results.hasNext()) {
                    QuerySolution soln = results.nextSolution();
                    try {
                        String uri = soln.get(this.kb.var.substring(1)).toString();
                        for (int i3 = 0; i3 < this.kb.properties.size(); ++i3) {
                            String propertyLabel = this.kb.properties.get(i3);
                            if (!soln.contains("v" + i3)) continue;
                            String rawValue = soln.get("v" + i3).toString();
                            for (String propertyDub : this.kb.functions.get(propertyLabel).keySet()) {
                                if (this.kb.functions.get(propertyDub).equals("POINT")) {
                                    rawValue = soln.get("v" + i3).asNode().getLiteralLexicalForm();
                                    List<Double> coordinates = Preprocessor.getPoints(rawValue);
                                    for (int c = 0; c < coordinates.size(); ++c) {
                                        cache.addTriple(uri, "c" + c, coordinates.get(c) + "");
                                    }
                                    continue;
                                }
                                String value = Preprocessor.process(rawValue, this.kb.functions.get(propertyLabel).get(propertyDub));
                                cache.addTriple(uri, propertyDub, value);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Error while processing: " + soln.toString()));
                        logger.warn((Object)("Following exception occured: " + e.getMessage()));
                        logger.info((Object)"Processing further ...");
                    }
                    ++counter2;
                    ++counter;
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Exception while handling query");
                logger.warn((Object)e.toString());
                logger.warn((Object)("XML = \n" + ResultSetFormatter.asXMLString((ResultSet)results)));
            }
            finally {
                qexec.close();
            }
            offset += this.kb.pageSize;
        } while (moreResults && this.kb.pageSize > 0);
        logger.info((Object)("Retrieved " + counter + " triples and " + cache.size() + " entities."));
        logger.info((Object)("Retrieving statements took " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds."));
    }
}

