/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.query;

import de.uni_leipzig.simba.io.KBInfo;
import de.uni_leipzig.simba.query.CsvQueryModule;
import de.uni_leipzig.simba.query.FileQueryModule;
import de.uni_leipzig.simba.query.QueryModule;
import de.uni_leipzig.simba.query.SparqlQueryModule;
import de.uni_leipzig.simba.query.VectorQueryModule;
import org.apache.log4j.Logger;

public class QueryModuleFactory {
    static Logger logger = Logger.getLogger((String)"LIMES");

    public static QueryModule getQueryModule(String name, KBInfo kbinfo) {
        logger.info((Object)("Generating <" + name + "> reader"));
        if (name.toLowerCase().startsWith("csv")) {
            return new CsvQueryModule(kbinfo);
        }
        if (name.toLowerCase().startsWith("n3") || name.toLowerCase().startsWith("nt")) {
            kbinfo.type = "N3";
            return new FileQueryModule(kbinfo);
        }
        if (name.toLowerCase().startsWith("n-triple")) {
            kbinfo.type = "N-TRIPLE";
            return new FileQueryModule(kbinfo);
        }
        if (name.toLowerCase().startsWith("turtle") || name.toLowerCase().startsWith("ttl")) {
            kbinfo.type = "TURTLE";
            return new FileQueryModule(kbinfo);
        }
        if (name.toLowerCase().startsWith("rdf") || name.toLowerCase().startsWith("xml")) {
            kbinfo.type = "RDF/XML";
            return new FileQueryModule(kbinfo);
        }
        if (name.toLowerCase().startsWith("vector")) {
            return new VectorQueryModule(kbinfo);
        }
        return new SparqlQueryModule(kbinfo);
    }
}

