/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.query;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFormatter;
import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.io.KBInfo;
import de.uni_leipzig.simba.query.QueryModule;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class NoPrefixSparqlQueryModule
implements QueryModule {
    KBInfo kb;

    public NoPrefixSparqlQueryModule(KBInfo kbinfo) {
        this.kb = kbinfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillCache(Cache cache) {
        int i;
        Logger logger = Logger.getLogger((String)"LIMES");
        long startTime = System.currentTimeMillis();
        String query = "";
        query = query + "SELECT DISTINCT " + this.kb.var;
        for (int i2 = 0; i2 < this.kb.properties.size(); ++i2) {
            query = query + " ?v" + i2;
        }
        query = query + "\n";
        if (this.kb.restrictions.size() > 0) {
            Iterator<String> iter = this.kb.restrictions.iterator();
            query = query + "WHERE {\n";
            for (i = 0; i < this.kb.restrictions.size(); ++i) {
                String where = this.kb.restrictions.get(i);
                query = query + where + " .\n";
            }
        }
        query = query + "OPTIONAL {";
        if (this.kb.properties.size() > 0) {
            logger.info((Object)("Properties are " + this.kb.properties));
            String optional = "";
            for (i = 0; i < this.kb.properties.size(); ++i) {
                optional = optional + this.kb.var + " <" + this.kb.properties.get(i) + "> ?v" + i + " .\n";
            }
            query = query + optional;
        }
        query = query + "}";
        if (this.kb.restrictions.size() > 0) {
            query = query + "}\n";
        }
        logger.info((Object)("Query issued is \n" + query));
        logger.info((Object)"Querying the endpoint.");
        int offset = 0;
        boolean moreResults = false;
        int counter = 0;
        int counter2 = 0;
        String basicQuery = query;
        do {
            logger.info((Object)("Getting statements " + offset + " to " + (offset + this.kb.pageSize)));
            if (this.kb.pageSize > 0) {
                query = basicQuery + " LIMIT " + this.kb.pageSize + " OFFSET " + offset;
            }
            Query sparqlQuery = QueryFactory.create((String)query);
            QueryExecution qexec = QueryExecutionFactory.sparqlService((String)this.kb.endpoint, (Query)sparqlQuery);
            logger.info((Object)("No default graph " + this.kb.graph));
            ResultSet results = qexec.execSelect();
            try {
                if (results.hasNext()) {
                    moreResults = true;
                } else {
                    moreResults = false;
                    break;
                }
                while (results.hasNext()) {
                    QuerySolution soln = results.nextSolution();
                    try {
                        String uri = soln.get(this.kb.var.substring(1)).toString();
                        for (int i3 = 0; i3 < this.kb.properties.size(); ++i3) {
                            String property = this.kb.properties.get(i3);
                            if (soln.contains("v" + i3)) {
                                String value = soln.get("v" + i3).toString();
                                if (value.contains("@")) {
                                    value = value.substring(0, value.indexOf("@"));
                                }
                                if (value.contains("^^")) {
                                    if (value.contains(":date")) {
                                        if ((value = value.substring(0, value.indexOf("^^"))).contains(" ")) {
                                            value = value.substring(0, value.indexOf(" "));
                                        }
                                        String[] split = value.split("-");
                                        value = Integer.parseInt(split[0]) * 365 + Integer.parseInt(split[1]) * 12 + Integer.parseInt(split[2]) + "";
                                    } else {
                                        value = value.substring(0, value.indexOf("^^"));
                                    }
                                }
                                cache.addTriple(uri, property, value);
                                continue;
                            }
                            cache.addTriple(uri, property, "");
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)("Error while processing: " + soln.toString()));
                        logger.warn((Object)("Following exception occured: " + e.getMessage()));
                        logger.info((Object)"Processing further ...");
                    }
                    ++counter2;
                    ++counter;
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Exception while handling query");
                logger.warn((Object)e.toString());
                logger.warn((Object)("XML = \n" + ResultSetFormatter.asXMLString((ResultSet)results)));
            }
            finally {
                qexec.close();
            }
            offset += this.kb.pageSize;
        } while (moreResults && this.kb.pageSize > 0);
        logger.info((Object)("Retrieved " + counter + " triples and " + cache.size() + " entities."));
        logger.info((Object)("Retrieving statements took " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds."));
    }
}

