/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.query;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.cache.HybridCache;
import de.uni_leipzig.simba.io.KBInfo;
import de.uni_leipzig.simba.preprocessing.Preprocessor;
import de.uni_leipzig.simba.query.QueryModule;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class N3QueryModule
implements QueryModule {
    static final Logger logger = Logger.getLogger((String)"LIMES");
    KBInfo kb;

    public void fillCache(Cache c) {
        HashMap prefixes = new HashMap();
        Logger logger = Logger.getLogger((String)"LIMES");
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.kb.endpoint));
            String s = reader.readLine();
            if (s != null) {
                s = reader.readLine();
                while (s != null) {
                    if ((s = s.trim()).length() > 0) {
                        String[] split;
                        if (s.startsWith("@prefix")) {
                            split = s.split(" ");
                            logger.info((Object)("adding prefix " + split[1] + "-->" + split[2]));
                            this.kb.prefixes.put(split[1], split[2]);
                        } else {
                            split = s.split(" ");
                            String subject = split[0].replace("<", "").replace(">", "");
                            String predicate = this.getPrefixedData(split[1].replace("<", "").replace(">", ""));
                            logger.info((Object)("get preprocessing for " + predicate));
                            for (String predicateLabel : this.kb.functions.get(predicate).keySet()) {
                                String object = Preprocessor.process(split[2].replace("<", "").replace(">", ""), this.kb.functions.get(predicate).get(predicateLabel));
                                if (object.indexOf("\"") != -1) {
                                    object = object.replaceAll("\"", "");
                                }
                                c.addTriple(subject, predicateLabel, object);
                            }
                        }
                    }
                    s = reader.readLine();
                }
            } else {
                logger.warn((Object)("Input file " + this.kb.endpoint + " was empty or faulty"));
            }
            reader.close();
            logger.info((Object)("Retrieved " + c.size() + " statements"));
        }
        catch (Exception e) {
            logger.fatal((Object)("Exception:" + e.getMessage()));
            e.printStackTrace();
        }
    }

    public String getPrefixedData(String s) {
        if (!s.startsWith("http://")) {
            return s;
        }
        int splitIndex = Math.max(s.lastIndexOf("/"), s.lastIndexOf("#"));
        if (splitIndex > 0 && splitIndex < s.length() - 1) {
            String baseUri = s.substring(0, splitIndex + 1);
            String suffix = s.substring(splitIndex + 1);
            String prefix = "";
            if (this.kb.prefixes.containsValue(baseUri)) {
                prefix = this.kb.getPrefix(baseUri);
            }
            if (prefix.length() > 0 && prefix != null) {
                return prefix + ":" + suffix;
            }
            logger.warn((Object)("No prefix found for URI: " + s));
            return s;
        }
        return s;
    }

    public N3QueryModule(KBInfo kbinfo) {
        this.kb = kbinfo;
    }

    public static void main(String[] args) {
        KBInfo k = new KBInfo();
        k.endpoint = "C:/Users/Lyko/Desktop/drugbank_dump.nt";
        k.prefixes.put("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        k.prefixes.put("owl", "http://www.w3.org/2002/07/owl#");
        k.properties.add("rdf:type");
        k.properties.add("owl:equivalentProperty");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("rdf:type", "lowercase");
        k.functions.put("rdf:type", map);
        map.clear();
        map.put("owl:equivalentProperty", "uri");
        k.functions.put("owl:equivalentProperty", map);
        HybridCache c = new HybridCache();
        N3QueryModule qm = new N3QueryModule(k);
        qm.fillCache(c);
        System.out.println(c);
    }
}

