/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.query;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFReader;
import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.cache.HybridCache;
import de.uni_leipzig.simba.io.KBInfo;
import de.uni_leipzig.simba.query.ModelRegistry;
import de.uni_leipzig.simba.query.QueryModule;
import de.uni_leipzig.simba.query.SparqlQueryModule;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.log4j.Logger;

public class FileQueryModule
implements QueryModule {
    KBInfo kb;
    Model model;
    static Logger logger = Logger.getLogger((String)"LIMES");

    public FileQueryModule(KBInfo kbinfo) {
        try {
            InputStream in;
            RDFReader r;
            block4: {
                this.kb = kbinfo;
                this.model = ModelFactory.createDefaultModel();
                r = this.model.getReader(this.kb.type);
                try {
                    in = new FileInputStream(this.kb.endpoint);
                }
                catch (FileNotFoundException e) {
                    in = this.getClass().getClassLoader().getResourceAsStream(this.kb.endpoint);
                    if (in != null) break block4;
                    logger.fatal((Object)"endpoint could not be loaded as a file or resource");
                    return;
                }
            }
            InputStreamReader reader = new InputStreamReader(in, "UTF8");
            r.read(this.model, (Reader)reader, null);
            logger.info((Object)("RDF model read from " + this.kb.endpoint + " is of size " + this.model.size()));
            ModelRegistry.register(this.kb.endpoint, this.model);
        }
        catch (Exception e) {
            logger.fatal((Object)"Error loading endpoint", (Throwable)e);
        }
    }

    public void fillCache(Cache c) {
        SparqlQueryModule sqm = new SparqlQueryModule(this.kb);
        sqm.fillCache(c, false);
    }

    public static void main(String[] args) {
        String ex = "C:\\Users\\Lyko\\Desktop\\dailymed_dump.nt";
        KBInfo kb = new KBInfo();
        kb.endpoint = ex;
        kb.type = "N3";
        FileQueryModule fqm = new FileQueryModule(kb);
        HybridCache hc = new HybridCache();
        fqm.fillCache(hc);
        System.out.println("CACHE: " + hc.size());
    }
}

