/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.query;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.io.KBInfo;
import de.uni_leipzig.simba.preprocessing.Preprocessor;
import de.uni_leipzig.simba.query.QueryModule;
import de.uni_leipzig.simba.util.DataCleaner;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class CsvQueryModule
implements QueryModule {
    private String SEP = ",";
    KBInfo kb;

    public CsvQueryModule(KBInfo kbinfo) {
        this.kb = kbinfo;
    }

    public void setSeparation(String s) {
        this.SEP = s;
    }

    public void fillCache(Cache c) {
        Logger logger = Logger.getLogger((String)"LIMES");
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.kb.endpoint));
            String s = reader.readLine();
            if (s != null) {
                ArrayList<String> properties = new ArrayList<String>();
                String[] split = s.split(this.SEP);
                properties.addAll(Arrays.asList(split));
                s = reader.readLine();
                while (s != null) {
                    split = DataCleaner.separate(s, this.SEP, properties.size());
                    String id = split[0];
                    for (String propertyLabel : this.kb.properties) {
                        String rawValue = split[properties.indexOf(propertyLabel)];
                        for (String propertyDub : this.kb.functions.get(propertyLabel).keySet()) {
                            String value = Preprocessor.process(rawValue, this.kb.functions.get(propertyLabel).get(propertyDub));
                            if (properties.indexOf(propertyLabel) < 0) continue;
                            c.addTriple(id, propertyDub, value);
                        }
                    }
                    s = reader.readLine();
                }
            } else {
                logger.warn((Object)("Input file " + this.kb.endpoint + " was empty or faulty"));
            }
            reader.close();
            logger.info((Object)("Retrieved " + c.size() + " statements"));
        }
        catch (Exception e) {
            logger.fatal((Object)("Exception:" + e.getMessage()));
            e.printStackTrace();
        }
    }

    public void fillAllInCache(Cache c) {
        Logger logger = Logger.getLogger((String)"LIMES");
        String s = "";
        try {
            BufferedReader reader = new BufferedReader(new FileReader(this.kb.endpoint));
            s = reader.readLine();
            if (s != null) {
                ArrayList<String> properties = new ArrayList<String>();
                String[] split = s.split(this.SEP);
                properties.addAll(Arrays.asList(split));
                logger.info((Object)("Properties = " + properties));
                logger.info((Object)("KB Properties = " + this.kb.properties));
                this.kb.properties = properties;
                s = reader.readLine();
                while (s != null) {
                    split = s.split(this.SEP);
                    String id = split[0].substring(1, split[0].length() - 1);
                    for (String propertyLabel : this.kb.properties) {
                        String rawValue = split[properties.indexOf(propertyLabel)];
                        if (this.kb.functions.containsKey(propertyLabel)) {
                            for (String propertyDub : this.kb.functions.get(propertyLabel).keySet()) {
                                String value = Preprocessor.process(rawValue, this.kb.functions.get(propertyLabel).get(propertyDub));
                                if (properties.indexOf(propertyLabel) < 0) continue;
                                c.addTriple(id, propertyDub, value);
                            }
                            continue;
                        }
                        c.addTriple(id, propertyLabel, rawValue.replaceAll(Pattern.quote("@en"), ""));
                    }
                    s = reader.readLine();
                }
            } else {
                logger.warn((Object)("Input file " + this.kb.endpoint + " was empty or faulty"));
            }
            reader.close();
            logger.info((Object)("Retrieved " + c.size() + " statements"));
        }
        catch (Exception e) {
            logger.fatal((Object)("Exception:" + e.getMessage()));
            logger.warn((Object)s);
            e.printStackTrace();
        }
    }
}

