/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.preprocessing;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Preprocessor {
    static Logger logger = Logger.getLogger((String)"LIMES");

    public static String process(String entry, String functionChain) {
        String result = entry.split("\\^")[0];
        if (functionChain != null && !functionChain.equals("")) {
            String[] split = functionChain.split("->");
            for (int i = 0; i < split.length; ++i) {
                result = Preprocessor.atomicProcess(result, split[i]);
            }
        }
        return result;
    }

    public static String atomicProcess(String entry, String function) {
        if (function.length() < 2) {
            return entry;
        }
        if (function.startsWith("lowercase")) {
            return entry.toLowerCase();
        }
        if (function.startsWith("uppercase")) {
            return entry.toUpperCase();
        }
        if (function.startsWith("replace")) {
            String replaced = function.substring(8, function.indexOf(","));
            String replacee = function.substring(function.indexOf(",") + 1, function.indexOf(")"));
            return entry.replaceAll(Pattern.quote(replaced), replacee);
        }
        if (function.startsWith("regexreplace")) {
            try {
                String replaced = function.substring(13, function.lastIndexOf(","));
                String replacee = function.substring(function.lastIndexOf(",") + 1, function.indexOf(")", function.lastIndexOf(",")));
                return entry.replaceAll(replaced, replacee).trim();
            }
            catch (IndexOutOfBoundsException e1) {
                logger.warn((Object)("Preprocessing function " + function + " could not be read."));
            }
            catch (PatternSyntaxException e2) {
                logger.warn((Object)("Preprocessing function " + function + " could not be read. Error in Regular Expression."));
            }
            return entry;
        }
        if (function.startsWith("nolang")) {
            if (entry.contains("@")) {
                return entry.substring(0, entry.lastIndexOf("@"));
            }
            return entry;
        }
        if (function.startsWith("cleaniri")) {
            if (entry.contains("/")) {
                return entry.substring(entry.lastIndexOf("/") + 1);
            }
            return entry;
        }
        if (function.startsWith("number")) {
            String value = entry.replaceAll("[^0-9,.,-]", "");
            if (value.length() == 0) {
                return "0";
            }
            try {
                Double.parseDouble(value);
            }
            catch (Exception e) {
                return "0";
            }
            return value;
        }
        if (function.startsWith("celsius")) {
            double value = Double.parseDouble(Preprocessor.atomicProcess(entry, "number"));
            double result = 32.0 + value * 9.0 / 5.0;
            return result + "";
        }
        if (function.startsWith("fahrenheit")) {
            double value = Double.parseDouble(Preprocessor.atomicProcess(entry, "number"));
            double result = (value - 32.0) * 5.0 / 9.0;
            return result + "";
        }
        if (function.startsWith("date")) {
            return entry.replaceAll("[^0-9,.-]", "");
        }
        if (function.startsWith("removebraces")) {
            int openBrace = entry.indexOf("(");
            int closingBrace = entry.indexOf(")", Math.max(openBrace, 0));
            if (closingBrace > -1 && openBrace > -1) {
                return entry.substring(0, Math.min(closingBrace, openBrace) - 1) + entry.substring(Math.max(openBrace, closingBrace) + 1);
            }
            String ret = entry.replaceAll("\\(", "");
            return ret.replaceAll("\\)", "");
        }
        return entry;
    }

    public static void main(String[] args) {
        String[] toreplace;
        System.out.println(Preprocessor.getPoints("POINT(-0.274278 51.9302)"));
        String s = "X AS Y";
        String AS = " AS ";
        String func = "lowercase->regexreplace(\\(.*\\),)";
        String func2 = "lowercase->removebraces";
        func = "lowercase->regexreplace(\\(.*\\),)";
        for (String entry : toreplace = new String[]{"Kill or Cure (1962 film)", "Shoot Loud, Louder... I Don't Understand", "The Unholy Three (1930 film)"}) {
            System.out.println(Preprocessor.process(entry, func));
            System.out.println(Preprocessor.process(entry, func2));
        }
    }

    public static List<Double> getPoints(String rawValue) {
        if (!rawValue.contains("(") || !rawValue.contains(")")) {
            return new ArrayList<Double>();
        }
        String s = rawValue.substring(rawValue.indexOf("(") + 1, rawValue.indexOf(")"));
        String[] split = s.split(" ");
        ArrayList<Double> result = new ArrayList<Double>();
        for (int i = 0; i < split.length; ++i) {
            result.add(Double.parseDouble(split[i]));
        }
        return result;
    }
}

