/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.organizer;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.data.Instance;
import de.uni_leipzig.simba.metricfactory.MetricFactory;
import de.uni_leipzig.simba.organizer.LimesOrganizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelocationBasedOrganizer
extends LimesOrganizer {
    HashMap<Instance, TreeSet<Instance>> newExemplarMap;
    long relocationTime = 0L;
    Logger logger = Logger.getLogger((String)"LIMES");

    @Override
    public String getName() {
        return "relocationBased";
    }

    @Override
    public void computeExemplars(Cache c, MetricFactory m, int nrExemplars) {
        HashMap updatedMap = new HashMap();
        super.computeExemplars(c, m, nrExemplars);
        int relocationComparisons = 0;
        long currentTime = System.currentTimeMillis();
        Iterator exemplars = this.exemplarMap.keySet().iterator();
        this.newExemplarMap = new HashMap();
        while (exemplars.hasNext()) {
            Instance key = (Instance)exemplars.next();
            this.logger.info((Object)("Relocation comparisons at " + (relocationComparisons += this.relocateExemplar(key, (TreeSet)this.exemplarMap.get(key), m))));
        }
        this.exemplarMap = this.newExemplarMap;
        this.relocationTime = System.currentTimeMillis() - currentTime;
        this.logger.info((Object)("Relocation took " + this.relocationTime / 1000L + " seconds."));
        this.logger.info((Object)("Relocation took " + relocationComparisons + " comparisons."));
        this.comparisons += relocationComparisons;
        this.comparisonTime += this.relocationTime;
    }

    private int relocateExemplar(Instance exemplar, TreeSet<Instance> children, MetricFactory m) {
        if (children.size() < 2) {
            this.newExemplarMap.put(exemplar, children);
            return 0;
        }
        this.logger.info((Object)("Input: " + exemplar + " -> " + children.size() + " children"));
        ArrayList<Instance> childrenList = new ArrayList<Instance>(children);
        childrenList.add(exemplar);
        int relocationComparisons = 0;
        int size = childrenList.size();
        double[][] similarityMatrix = new double[size][size];
        for (int i = 0; i < size; ++i) {
            similarityMatrix[i][i] = 0.0;
            for (int j = i + 1; j < size; ++j) {
                similarityMatrix[i][j] = m.getSimilarity(childrenList.get(i), childrenList.get(j));
                similarityMatrix[j][i] = similarityMatrix[i][j];
                ++relocationComparisons;
            }
        }
        double maxSimilarity = 0.0;
        int index = 0;
        for (int i = 0; i < size; ++i) {
            double similarity = 0.0;
            for (int j = 0; j < size; ++j) {
                similarity += similarityMatrix[i][j];
            }
            if (!(similarity > maxSimilarity)) continue;
            index = i;
            maxSimilarity = similarity;
        }
        childrenList.get((int)index).distance = -1.0;
        Iterator<Instance> iter = children.iterator();
        TreeSet<Instance> newChildren = new TreeSet<Instance>();
        while (iter.hasNext()) {
            Instance child = iter.next();
            int indexOfChild = childrenList.indexOf(child);
            if (indexOfChild == index) continue;
            child.distance = 1.0 - similarityMatrix[index][indexOfChild];
            newChildren.add(child);
        }
        this.logger.info((Object)("Output: " + childrenList.get(index) + " -> " + children.size() + " children"));
        this.newExemplarMap.put(childrenList.get(index), newChildren);
        return relocationComparisons;
    }
}

