/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.organizer;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.data.Instance;
import de.uni_leipzig.simba.metricfactory.MetricFactory;
import de.uni_leipzig.simba.organizer.LimesOrganizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class LinearOnePassOrganizer
extends LimesOrganizer {
    public double similarityThreshold = 0.2;

    public void computeExemplars(Cache c, MetricFactory m, int nrExemplars) {
        Logger logger = Logger.getLogger((String)"LIMES");
        logger.info((Object)("Similarity threshold for exemplars was set to " + this.similarityThreshold));
        long startTime = System.currentTimeMillis();
        this.uris = c.getAllUris();
        this.exemplarMap = new HashMap();
        if (nrExemplars <= 2) {
            nrExemplars = 2;
        }
        if (nrExemplars > c.size()) {
            nrExemplars = c.size();
        }
        this.exemplarDistanceMap = new HashMap();
        ArrayList<Instance> exemplarList = new ArrayList<Instance>();
        Instance exemplar = c.getInstance((String)this.uris.get(0));
        exemplarList.add(exemplar);
        this.exemplarMap.put(exemplar, new TreeSet());
        ArrayList distances = new ArrayList();
        for (int i = 1; i < this.uris.size(); ++i) {
            double max = 0.0;
            int index = -1;
            for (int j = 0; j < exemplarList.size(); ++j) {
                double value = m.getSimilarity((Instance)exemplarList.get(j), c.getInstance((String)this.uris.get(i)));
                ++this.comparisons;
                if (!(value >= max)) continue;
                max = value;
                index = j;
            }
            if (max <= this.similarityThreshold || index == -1) {
                exemplarList.add(c.getInstance((String)this.uris.get(i)));
                this.exemplarMap.put(c.getInstance((String)this.uris.get(i)), new TreeSet());
                continue;
            }
            c.getInstance((String)((String)this.uris.get((int)i))).distance = 1.0 - max;
            ((TreeSet)this.exemplarMap.get(exemplarList.get(index))).add(c.getInstance((String)this.uris.get(i)));
        }
        logger.info((Object)("Reorganizing cache took " + this.comparisons + " comparisons."));
        logger.info((Object)("Reorganizing cache generated " + exemplarList.size() + " exemplars."));
        logger.info((Object)("Reorganizing was carried out in " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds."));
    }

    public void computeExemplars(Cache c, MetricFactory m) {
        int size = (int)Math.sqrt(c.size());
        this.computeExemplars(c, m, size);
    }

    public String getName() {
        return "LinearOrganizerOnePass";
    }
}

