/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.organizer;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.data.Instance;
import de.uni_leipzig.simba.metricfactory.MetricFactory;
import de.uni_leipzig.simba.organizer.Organizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LimesOrganizer
implements Organizer {
    HashMap<Instance, TreeSet<Instance>> exemplarMap;
    HashMap<Instance, ArrayList<Double>> exemplarDistanceMap;
    ArrayList<String> uris;
    public int comparisons = 0;
    public int lookups = 0;
    public long comparisonTime = 0L;

    @Override
    public int getComparisons() {
        return this.comparisons;
    }

    @Override
    public void computeExemplars(Cache c, MetricFactory m, int nrExemplars) {
        int j;
        double distance;
        int i;
        long startTime = System.currentTimeMillis();
        this.uris = c.getAllUris();
        int index = 0;
        if (nrExemplars <= 2) {
            nrExemplars = 2;
        }
        if (nrExemplars > c.size()) {
            nrExemplars = c.size();
        }
        this.exemplarDistanceMap = new HashMap();
        ArrayList<Instance> exemplarList = new ArrayList<Instance>();
        Instance exemplar = c.getInstance(this.uris.get(0));
        ArrayList<Double> distances = new ArrayList<Double>();
        double max = 0.0;
        for (i = 0; i < this.uris.size(); ++i) {
            distance = 1.0f - m.getSimilarity(exemplar, c.getInstance(this.uris.get(i)));
            ++this.comparisons;
            distances.add(distance);
        }
        this.exemplarDistanceMap.put(exemplar, distances);
        exemplarList.add(exemplar);
        while (exemplarList.size() < nrExemplars) {
            max = 0.0;
            index = 0;
            double theoreticalMax = exemplarList.size();
            for (i = 0; i < c.size(); ++i) {
                distance = 0.0;
                for (j = 0; j < exemplarList.size(); ++j) {
                    distance += this.exemplarDistanceMap.get(exemplarList.get(j)).get(i).doubleValue();
                    ++this.lookups;
                }
                if (!(distance > max)) continue;
                max = distance;
                index = i;
                if (max == theoreticalMax) break;
            }
            exemplar = c.getInstance(this.uris.get(index));
            distances = new ArrayList();
            for (i = 0; i < c.size(); ++i) {
                distance = 1.0f - m.getSimilarity(exemplar, c.getInstance(this.uris.get(i)));
                ++this.comparisons;
                distances.add(distance);
            }
            this.exemplarDistanceMap.put(exemplar, distances);
            exemplarList.add(exemplar);
        }
        this.exemplarMap = new HashMap();
        for (i = 0; i < exemplarList.size(); ++i) {
            this.exemplarMap.put((Instance)exemplarList.get(i), new TreeSet());
        }
        for (i = 0; i < this.uris.size(); ++i) {
            distance = 0.0;
            double min = 1.0;
            index = 0;
            for (j = 0; j < exemplarList.size(); ++j) {
                distance = this.exemplarDistanceMap.get(exemplarList.get(j)).get(i);
                ++this.lookups;
                if (!(min > distance)) continue;
                min = distance;
                index = j;
            }
            if (!(min > 0.0)) continue;
            c.getInstance((String)this.uris.get((int)i)).distance = min;
            this.exemplarMap.get(exemplarList.get(index)).add(c.getInstance(this.uris.get(i)));
        }
        Logger logger = Logger.getLogger((String)"LIMES");
        logger.info((Object)("Reorganizing cache took " + this.comparisons + " comparisons."));
        logger.info((Object)("Reorganizing was carried out in " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds."));
    }

    @Override
    public void computeExemplars(Cache c, MetricFactory m) {
        int size = (int)Math.sqrt(c.size());
        this.computeExemplars(c, m, size);
    }

    @Override
    public HashMap<String, Double> getSimilarInstances(Instance instance, double threshold, MetricFactory metric) {
        long startTime = System.currentTimeMillis();
        Iterator<Instance> exemplarIterator = this.exemplarMap.keySet().iterator();
        HashMap<String, Double> result = new HashMap<String, Double>();
        while (exemplarIterator.hasNext()) {
            Instance exemplar = exemplarIterator.next();
            TreeSet<Instance> instancesInSubspace = this.exemplarMap.get(exemplar);
            Iterator<Instance> examplesIterator = instancesInSubspace.iterator();
            double basicSim = metric.getSimilarity(instance, exemplar);
            ++this.comparisons;
            if (basicSim >= threshold) {
                result.put(exemplar.getUri(), basicSim);
            }
            boolean end = false;
            while (examplesIterator.hasNext()) {
                Instance example = examplesIterator.next();
                if (!(basicSim + example.distance >= threshold)) continue;
                double sim = metric.getSimilarity(instance, example);
                ++this.comparisons;
                if (!(sim >= threshold)) continue;
                result.put(example.getUri(), sim);
            }
        }
        this.comparisonTime += System.currentTimeMillis() - startTime;
        return result;
    }

    @Override
    public double getComparisonTime() {
        return this.comparisonTime / 1000L;
    }

    @Override
    public String getName() {
        return "limes";
    }
}

