/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.organizer;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.data.Instance;
import de.uni_leipzig.simba.metricfactory.MetricFactory;
import de.uni_leipzig.simba.organizer.LimesOrganizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class Limes2Organizer
extends LimesOrganizer {
    public void computeExemplars(Cache c, MetricFactory m, int nrExemplars) {
        int j;
        double distance;
        int i;
        long startTime = System.currentTimeMillis();
        this.uris = c.getAllUris();
        int index = 0;
        if (nrExemplars <= 2) {
            nrExemplars = 2;
        }
        if (nrExemplars > c.size()) {
            nrExemplars = c.size();
        }
        this.exemplarDistanceMap = new HashMap();
        ArrayList<Instance> exemplarList = new ArrayList<Instance>();
        Instance exemplar = c.getInstance((String)this.uris.get(0));
        ArrayList<Double> distances = new ArrayList<Double>();
        double max = 0.0;
        for (i = 0; i < this.uris.size(); ++i) {
            distance = 1.0f - m.getSimilarity(exemplar, c.getInstance((String)this.uris.get(i)));
            ++this.comparisons;
            distances.add(distance);
        }
        this.exemplarDistanceMap.put(exemplar, distances);
        exemplarList.add(exemplar);
        while (exemplarList.size() < nrExemplars) {
            max = 0.0;
            index = 0;
            double theoreticalMax = exemplarList.size();
            for (i = 0; i < c.size(); ++i) {
                if (exemplarList.contains(c.getInstance((String)this.uris.get(i)))) continue;
                distance = 0.0;
                for (j = 0; j < exemplarList.size(); ++j) {
                    distance += ((Double)((ArrayList)this.exemplarDistanceMap.get(exemplarList.get(j))).get(i)).doubleValue();
                    ++this.lookups;
                }
                if (!(distance > max)) continue;
                max = distance;
                index = i;
                if (max == theoreticalMax) break;
            }
            exemplar = c.getInstance((String)this.uris.get(index));
            distances = new ArrayList();
            for (i = 0; i < c.size(); ++i) {
                distance = 1.0f - m.getSimilarity(exemplar, c.getInstance((String)this.uris.get(i)));
                ++this.comparisons;
                distances.add(distance);
            }
            this.exemplarDistanceMap.put(exemplar, distances);
            exemplarList.add(exemplar);
        }
        this.exemplarMap = new HashMap();
        for (i = 0; i < exemplarList.size(); ++i) {
            this.exemplarMap.put(exemplarList.get(i), new TreeSet());
        }
        for (i = 0; i < this.uris.size(); ++i) {
            distance = 0.0;
            double min = 1.0;
            index = 0;
            for (j = 0; j < exemplarList.size(); ++j) {
                distance = (Double)((ArrayList)this.exemplarDistanceMap.get(exemplarList.get(j))).get(i);
                ++this.lookups;
                if (!(min > distance)) continue;
                min = distance;
                index = j;
            }
            if (!(min > 0.0)) continue;
            c.getInstance((String)((String)this.uris.get((int)i))).distance = min;
            ((TreeSet)this.exemplarMap.get(exemplarList.get(index))).add(c.getInstance((String)this.uris.get(i)));
        }
        Logger logger = Logger.getLogger((String)"LIMES");
        logger.info((Object)("Reorganizing cache took " + this.comparisons + " comparisons."));
        logger.info((Object)("Reorganizing was carried out in " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds."));
    }
}

