/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.organizer;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.data.Instance;
import de.uni_leipzig.simba.metricfactory.MetricFactory;
import de.uni_leipzig.simba.organizer.Organizer;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BruteForceOrganizer
implements Organizer {
    Cache cache;
    int comparisons;
    double time;

    @Override
    public HashMap<String, Double> getSimilarInstances(Instance instance, double threshold, MetricFactory m) {
        long currentTime = System.currentTimeMillis();
        HashMap<String, Double> map = new HashMap<String, Double>();
        ArrayList<String> uris = this.cache.getAllUris();
        for (int i = 0; i < uris.size(); ++i) {
            double sim = m.getSimilarity(instance, this.cache.getInstance(uris.get(i)));
            if (sim >= threshold) {
                map.put(uris.get(i), sim);
            }
            ++this.comparisons;
        }
        this.time += (double)(System.currentTimeMillis() - currentTime);
        return map;
    }

    @Override
    public void computeExemplars(Cache c, MetricFactory m, int nrExemplars) {
        this.cache = c;
        this.comparisons = 0;
        this.time = 0.0;
    }

    @Override
    public void computeExemplars(Cache c, MetricFactory m) {
        this.cache = c;
        this.comparisons = 0;
        this.time = 0.0;
    }

    @Override
    public int getComparisons() {
        return this.comparisons;
    }

    @Override
    public double getComparisonTime() {
        return this.time / 1000.0;
    }

    @Override
    public String getName() {
        return "bruteForce";
    }
}

