/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.multilinker;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.util.FileManager;
import de.uni_leipzig.simba.cache.HybridCache;
import de.uni_leipzig.simba.controller.PPJoinController;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.evaluation.PRFComputer;
import de.uni_leipzig.simba.genetics.core.Metric;
import de.uni_leipzig.simba.genetics.learner.GeneticActiveLearner;
import de.uni_leipzig.simba.genetics.learner.LinkSpecificationLearner;
import de.uni_leipzig.simba.genetics.learner.LinkSpecificationLearnerFactory;
import de.uni_leipzig.simba.genetics.selfconfig.BasicGeneticSelfConfigurator;
import de.uni_leipzig.simba.genetics.util.Pair;
import de.uni_leipzig.simba.genetics.util.PropertyMapping;
import de.uni_leipzig.simba.io.ConfigReader;
import de.uni_leipzig.simba.io.KBInfo;
import de.uni_leipzig.simba.learning.oracle.oracle.SimpleOracle;
import de.uni_leipzig.simba.multilinker.MappingMath;
import de.uni_leipzig.simba.selfconfig.ComplexClassifier;
import de.uni_leipzig.simba.selfconfig.MeshBasedSelfConfigurator;
import de.uni_leipzig.simba.selfconfig.PseudoMeasures;
import de.uni_leipzig.simba.selfconfig.SimpleClassifier;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.collections15.multimap.MultiHashMap;
import org.apache.log4j.Logger;
import org.jgap.InvalidConfigurationException;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiInterlinker {
    static Logger logger = Logger.getLogger((String)"LIMES");
    private PPJoinController ppJoinController;
    private BasicGeneticSelfConfigurator bgsConfiger;
    long datasetSize;
    Map<String, Double> results = new TreeMap<String, Double>();
    Mapping optimalMap = new Mapping();

    public PPJoinController getPpJoinController() {
        return this.ppJoinController;
    }

    public void setPpJoinController(PPJoinController ppJoinController) {
        this.ppJoinController = ppJoinController;
    }

    public Mapping getUnsupervisedMappings(String fileName, String sourceDatasetFile, String targetDatasetFile) {
        Mapping map = new Mapping();
        if (new File(fileName).exists()) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            ConfigReader cR = new ConfigReader();
            cR.validateAndRead(fileName);
            cR.sourceInfo.endpoint = sourceDatasetFile;
            cR.sourceInfo.id = sourceDatasetFile.substring(sourceDatasetFile.lastIndexOf("/") + 1, sourceDatasetFile.lastIndexOf("."));
            cR.targetInfo.endpoint = targetDatasetFile;
            cR.targetInfo.id = targetDatasetFile.substring(targetDatasetFile.lastIndexOf("/") + 1, targetDatasetFile.lastIndexOf("."));
            params.put("sourceInfo", cR.sourceInfo);
            params.put("targetInfo", cR.targetInfo);
            System.out.println("Source: " + cR.sourceInfo);
            System.out.println("Target: " + cR.targetInfo);
            HybridCache sourceCash = HybridCache.getData(cR.getSourceInfo());
            HybridCache targetCash = HybridCache.getData(cR.getTargetInfo());
            params.put("sourceCache", sourceCash);
            params.put("targetCache", targetCash);
            PropertyMapping pM = new PropertyMapping();
            for (String sourceProperty : cR.getSourceInfo().properties) {
                for (String targetProperty : cR.getTargetInfo().properties) {
                    pM.addStringPropertyMatch(sourceProperty, targetProperty);
                }
            }
            params.put("propertyMapping", pM);
            params.put("beta", 1.0);
            params.put("generations", 3);
            params.put("populationSize", 5);
            params.put("crossOverRate", Float.valueOf(0.4f));
            params.put("mutationRate", Float.valueOf(0.4f));
            params.put("measure", new PseudoMeasures());
            this.bgsConfiger = new BasicGeneticSelfConfigurator();
            this.datasetSize = sourceCash.getAllInstances().size();
            try {
                Metric m = this.bgsConfiger.learn(params);
                map = this.bgsConfiger.getMapping();
                System.out.println("Source ID:         " + cR.getSourceInfo().id);
                System.out.println("Target ID:         " + cR.getTargetInfo().id);
                System.out.println("Metric:            " + m);
                System.out.println("Total Maping size: " + map.getNumberofMappings() + " (map.getNumberofMappings() how come that this no bigger than the cash size!!!)");
                System.out.println("Optimal map size:  " + this.datasetSize + " ( sourceCash.getAllInstances().size() )");
                System.out.println("mapping Accuricy:  " + this.computePrecision(map, this.datasetSize));
            }
            catch (InvalidConfigurationException e) {
                e.printStackTrace();
            }
        } else {
            logger.fatal((Object)("Input file " + fileName + " does not exist."));
            System.exit(1);
        }
        return map;
    }

    public Mapping getDeterministicUnsupervisedMappings(String fileName, String sourceDatasetFile, String targetDatasetFile) {
        Mapping map = new Mapping();
        if (new File(fileName).exists()) {
            HashMap<String, KBInfo> params = new HashMap<String, KBInfo>();
            ConfigReader cR = new ConfigReader();
            cR.validateAndRead(fileName);
            cR.sourceInfo.endpoint = sourceDatasetFile;
            cR.sourceInfo.id = sourceDatasetFile.substring(sourceDatasetFile.lastIndexOf("/") + 1, sourceDatasetFile.lastIndexOf("."));
            cR.targetInfo.endpoint = targetDatasetFile;
            cR.targetInfo.id = targetDatasetFile.substring(targetDatasetFile.lastIndexOf("/") + 1, targetDatasetFile.lastIndexOf("."));
            params.put("sourceInfo", cR.sourceInfo);
            params.put("targetInfo", cR.targetInfo);
            System.out.println("Source: " + cR.sourceInfo);
            System.out.println("Target: " + cR.targetInfo);
            HybridCache source = HybridCache.getData(cR.getSourceInfo());
            HybridCache target = HybridCache.getData(cR.getTargetInfo());
            this.datasetSize = source.getAllInstances().size();
            MeshBasedSelfConfigurator bsc = new MeshBasedSelfConfigurator(source, target, 0.6, 1.0);
            bsc.setMeasure("reference");
            ArrayList<SimpleClassifier> cp = new ArrayList<SimpleClassifier>();
            for (String property : cR.sourceInfo.properties) {
                cp.add(new SimpleClassifier("levenshtein", 1.0, property, property));
                cp.add(new SimpleClassifier("trigrams", 1.0, property, property));
            }
            ComplexClassifier cc = bsc.getZoomedHillTop(5, 5, cp);
            logger.info((Object)("Mapping size is " + cc.mapping.getNumberofMappings()));
            map = cc.mapping;
        } else {
            logger.fatal((Object)("Input file " + fileName + " does not exist."));
            System.exit(1);
        }
        return map;
    }

    public double computeRecall(Mapping mapping, long optimalMapSize) {
        long currentMappingSize = 0L;
        for (String s : mapping.map.keySet()) {
            for (String t : mapping.map.get(s).keySet()) {
                if (!s.equals(t)) continue;
                ++currentMappingSize;
            }
        }
        if (optimalMapSize == 0L) {
            return 0.0;
        }
        return (double)currentMappingSize / (double)optimalMapSize;
    }

    public double computePrecision(Mapping mapping, long optimalMapSize) {
        long currentMappingSize = 0L;
        for (String s : mapping.map.keySet()) {
            for (String t : mapping.map.get(s).keySet()) {
                if (!s.equals(t)) continue;
                ++currentMappingSize;
            }
        }
        if (optimalMapSize == 0L) {
            return 0.0;
        }
        return (double)currentMappingSize / (double)mapping.getNumberofMappings();
    }

    public double computeFMeasure(Mapping mapping, long optimalSize) {
        double p = this.computePrecision(mapping, optimalSize);
        double r = this.computeRecall(mapping, optimalSize);
        if (p == 0.0 || r == 0.0) {
            return 0.0;
        }
        return 2.0 * p * r / (p + r);
    }

    public Model loadModel(String fileNameOrUri) {
        Model model = ModelFactory.createDefaultModel();
        InputStream in = FileManager.get().open(fileNameOrUri);
        if (in == null) {
            throw new IllegalArgumentException("File/URI: " + fileNameOrUri + " not found");
        }
        if (fileNameOrUri.endsWith(".ttl")) {
            System.out.println("Opening Turtle file");
            model.read(in, null, "TTL");
        } else if (fileNameOrUri.endsWith(".rdf")) {
            System.out.println("Opening RDFXML file");
            model.read(in, null);
        } else if (fileNameOrUri.endsWith(".nt")) {
            System.out.println("Opening N-Triples file");
            model.read(in, null, "N-TRIPLE");
        } else {
            System.out.println("Content negotiation to get RDFXML from " + fileNameOrUri);
            model.read(fileNameOrUri);
        }
        System.out.println("loading " + fileNameOrUri + " is done!!");
        System.out.println();
        return model;
    }

    @Test
    public void getPeelTestBenchmarks() throws IOException {
        String peelFile = "/media/lod2/datasetsMapping/Musik/peelTest.ttl";
        ArrayList<Property> props = new ArrayList<Property>();
        props.add(ResourceFactory.createProperty((String)"http://www.w3.org/2000/01/rdf-schema#label"));
        props.add(ResourceFactory.createProperty((String)"http://xmlns.com/foaf/0.1/name"));
        props.add(ResourceFactory.createProperty((String)"http://purl.org/dc/elements/1.1/title"));
        ArrayList<Double> destructionValues = new ArrayList<Double>();
        destructionValues.add(0.25);
        destructionValues.add(0.5);
    }

    @Test
    public void multilinkPeelTest() {
    }

    @Test
    public void getPeelBenchmarks() throws IOException {
        String peelFile = "/mypartition2/musicDatasets/peel.ttl";
        ArrayList<Property> props = new ArrayList<Property>();
        props.add(ResourceFactory.createProperty((String)"http://www.w3.org/2000/01/rdf-schema#label"));
        props.add(ResourceFactory.createProperty((String)"http://xmlns.com/foaf/0.1/name"));
        props.add(ResourceFactory.createProperty((String)"http://purl.org/dc/elements/1.1/title"));
        ArrayList<Double> destructionValues = new ArrayList<Double>();
        destructionValues.add(0.1);
        destructionValues.add(0.1);
        destructionValues.add(0.1);
        destructionValues.add(0.1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void multilinkPeel() {
        String datasetPath = "E:/Work/Data/Peel/musicDatasets/";
        String peelSpec = datasetPath + "peelSpecs.xml";
        String[] datasetFiles = new String[]{"peel.ttl", "peel_0.1.ttl", "peel_0.2.ttl", "peel_0.3.ttl", "peel_0.4.ttl"};
        for (int i = 0; i < datasetFiles.length; ++i) {
            datasetFiles[i] = datasetPath.concat(datasetFiles[i]);
        }
        Model tmpModel = this.loadModel(datasetFiles[0]);
        String queryString = "SELECT DISTINCT ?x ?v0 WHERE { ?x a <http://xmlns.com/foaf/0.1/Person> . ?x <http://xmlns.com/foaf/0.1/name> ?v0 . }";
        Query query = QueryFactory.create((String)queryString);
        QueryExecution qexec = QueryExecutionFactory.create((Query)query, (Model)tmpModel);
        try {
            ResultSet queryResults = qexec.execSelect();
            while (queryResults.hasNext()) {
                QuerySolution soln = queryResults.nextSolution();
                RDFNode uri = soln.get("?x");
                this.optimalMap.add(uri.toString(), uri.toString(), 1.0);
            }
        }
        finally {
            qexec.close();
        }
        Mapping[][] m = new Mapping[5][5];
        for (int i = 0; i < m.length; ++i) {
            for (int j = i + 1; j < m.length; ++j) {
                m[i][j] = this.getDeterministicUnsupervisedMappings(peelSpec, datasetFiles[i], datasetFiles[j]);
                m[j][i] = m[i][j].reverseSourceTarget();
                this.results.put("Precision of M[" + i + "][" + j + "]", this.computePrecision(m[i][j], this.datasetSize));
                this.results.put("Recall of M[" + i + "][" + j + "]", this.computeRecall(m[i][j], this.datasetSize));
                this.results.put("F1 of M[" + i + "][" + j + "]", this.computeFMeasure(m[i][j], this.datasetSize));
            }
        }
        int sourceMapIndex = 1;
        int targetMapIndex = 2;
        long ExampleCount = Long.MAX_VALUE;
        int datasetsCount = 5;
        int acceptanceThreshold = 1;
        Mapping votingMatrix = this.getScores(m, sourceMapIndex, targetMapIndex);
        Mapping posNegExamlpes = this.getNPosNegExamples(votingMatrix, ExampleCount, datasetsCount, acceptanceThreshold);
        for (int i = 1; i < 5; ++i) {
            Mapping posExamples = this.getPosExamples(votingMatrix, ExampleCount, datasetsCount, i);
            this.results.put("Precision of votingMatrix with k=" + i, this.computePrecision(posExamples, this.datasetSize));
            this.results.put("Recall of votingMatrix with k=" + i, this.computeRecall(posExamples, this.datasetSize));
            this.results.put("F1 of votingMatrix with k=" + i, this.computeFMeasure(posExamples, this.datasetSize));
        }
        System.out.println(this.results);
        System.exit(1);
        Mapping GeneticActiveLearnerMapping = this.getGeneticActiveLearner(peelSpec, datasetFiles[sourceMapIndex], datasetFiles[targetMapIndex], posNegExamlpes);
        this.results.put("GeneticActiveLearner final mapping", this.computeFMeasure(GeneticActiveLearnerMapping, this.datasetSize));
    }

    private Mapping getScores(Mapping[][] m, int sourceMapIndex, int targetMapIndex) {
        Mapping votingMatrix = new Mapping();
        votingMatrix = m[sourceMapIndex][targetMapIndex];
        for (int j = 0; j < m.length; ++j) {
            if (j == sourceMapIndex || j == targetMapIndex) continue;
            votingMatrix = MappingMath.add(votingMatrix, MappingMath.multiply(m[sourceMapIndex][j], m[j][targetMapIndex], true), true);
        }
        return votingMatrix;
    }

    private Mapping getNPosNegExamples(Mapping votingMap, int exampleCount) {
        if (votingMap.size() < exampleCount) {
            exampleCount = votingMap.size() / 2;
        }
        int posExCount = exampleCount;
        int negExCount = exampleCount;
        Mapping result = new Mapping();
        MultiHashMap errMap = new MultiHashMap();
        for (String mapSourceUri : votingMap.map.keySet()) {
            for (String mapTargetUri : votingMap.map.get(mapSourceUri).keySet()) {
                HashMap<String, String> value = new HashMap<String, String>();
                value.put(mapSourceUri, mapTargetUri);
                Double key = votingMap.getSimilarity(mapSourceUri, mapTargetUri);
                errMap.put((Object)key, value);
            }
        }
        Mapping negExMap = this.getNNegExamples((MultiHashMap<Double, Map<String, String>>)errMap, negExCount);
        Mapping posExMap = this.getNPosExamples((MultiHashMap<Double, Map<String, String>>)errMap, posExCount);
        result.map.putAll(posExMap.map);
        result.map.putAll(negExMap.map);
        result.size = posExMap.map.size() + negExMap.map.size();
        return result;
    }

    private Mapping getNNegExamples(MultiHashMap<Double, Map<String, String>> votingMap, int negExCount) {
        Mapping result = new Mapping();
        TreeSet sortedErrValues = new TreeSet(votingMap.keySet());
        Iterator i$ = sortedErrValues.iterator();
        while (i$.hasNext()) {
            double errValue = (Double)i$.next();
            System.out.println(errValue);
            Collection m = votingMap.get((Object)errValue);
            for (Map row : m) {
                for (String sourceURI : row.keySet()) {
                    String targetURI = (String)row.get(sourceURI);
                    result.add(sourceURI, targetURI, 0.0);
                    if (--negExCount != 0) continue;
                    return result;
                }
            }
        }
        return result;
    }

    private Mapping getNPosExamples(MultiHashMap<Double, Map<String, String>> votingMap, int negExCount) {
        Mapping result = new Mapping();
        TreeSet sortedErrValues = new TreeSet(Collections.reverseOrder());
        sortedErrValues.addAll(votingMap.keySet());
        Iterator i$ = sortedErrValues.iterator();
        while (i$.hasNext()) {
            double errValue = (Double)i$.next();
            System.out.println(errValue);
            Collection m = votingMap.get((Object)errValue);
            for (Map row : m) {
                for (String sourceURI : row.keySet()) {
                    String targetURI = (String)row.get(sourceURI);
                    result.add(sourceURI, targetURI, 1.0);
                    if (--negExCount != 0) continue;
                    return result;
                }
            }
        }
        return result;
    }

    private Mapping getNPosNegExamples(Mapping votingMap, long exampleCount, int n, int k) {
        long posExCount = exampleCount;
        long negExCount = exampleCount;
        Mapping result = new Mapping();
        for (String mapSourceUri : votingMap.map.keySet()) {
            for (String mapTargetUri : votingMap.map.get(mapSourceUri).keySet()) {
                Double sim = votingMap.getSimilarity(mapSourceUri, mapTargetUri);
                if (posExCount > 0L && sim >= (double)(n - k)) {
                    result.add(mapSourceUri, mapTargetUri, 1.0);
                    --posExCount;
                } else if (negExCount > 0L && sim <= (double)(k + 1)) {
                    result.add(mapSourceUri, mapTargetUri, 0.0);
                    --negExCount;
                }
                if (posExCount != 0L || negExCount != 0L) continue;
                return result;
            }
        }
        return result;
    }

    private Mapping getPosExamples(Mapping votingMap, long exampleCount, int n, int k) {
        Mapping result = new Mapping();
        for (String mapSourceUri : votingMap.map.keySet()) {
            for (String mapTargetUri : votingMap.map.get(mapSourceUri).keySet()) {
                Double sim = votingMap.getSimilarity(mapSourceUri, mapTargetUri);
                if (!(sim >= (double)(n - k))) continue;
                result.add(mapSourceUri, mapTargetUri, 1.0);
            }
        }
        return result;
    }

    public Mapping _getGeneticActiveLearner(String configFile, String sourceDatasetFile, String targetDatasetFile, Mapping unsupervisedResultMapping) {
        Mapping resultMapping = new Mapping();
        System.out.println("\n Mapping = " + unsupervisedResultMapping);
        Mapping posMap = new Mapping();
        for (String s : unsupervisedResultMapping.map.keySet()) {
            for (String t : unsupervisedResultMapping.map.get(s).keySet()) {
                if (unsupervisedResultMapping.getSimilarity(s, t) != 1.0) continue;
                posMap.add(s, t, 1.0);
            }
        }
        SimpleOracle o = new SimpleOracle();
        o.loadData(posMap);
        int size = 10;
        ConfigReader cR = new ConfigReader();
        cR.validateAndRead(configFile);
        cR.sourceInfo.endpoint = sourceDatasetFile;
        cR.sourceInfo.id = sourceDatasetFile.substring(sourceDatasetFile.lastIndexOf("/") >= 0 ? sourceDatasetFile.lastIndexOf("/") + 1 : 0, sourceDatasetFile.lastIndexOf(".") >= 0 ? sourceDatasetFile.lastIndexOf(".") : sourceDatasetFile.length() - 1);
        cR.targetInfo.endpoint = targetDatasetFile;
        cR.targetInfo.id = targetDatasetFile.substring(targetDatasetFile.lastIndexOf("/") >= 0 ? targetDatasetFile.lastIndexOf("/") + 1 : 0, targetDatasetFile.lastIndexOf(".") >= 0 ? targetDatasetFile.lastIndexOf(".") : targetDatasetFile.length() - 1);
        PropertyMapping propMap = new PropertyMapping();
        int max = Math.max(cR.sourceInfo.properties.size(), cR.targetInfo.properties.size());
        for (int i = 0; i < max; ++i) {
            propMap.addStringPropertyMatch(cR.sourceInfo.properties.get(i), cR.targetInfo.properties.get(i));
        }
        System.out.println("propMap: " + propMap);
        LinkSpecificationLearner learner = LinkSpecificationLearnerFactory.getLinkSpecificationLearner("geneticactivelearner");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("populationSize", 20);
        param.put("generations", 100);
        param.put("mutationRate", Float.valueOf(0.5f));
        param.put("preserveFittest", false);
        param.put("propertyMapping", propMap);
        param.put("trainingDataSize", 100);
        param.put("granularity", 2);
        param.put("config", cR);
        propMap.numberPropPairs = new ArrayList<Pair<String>>();
        propMap.sourceNumberProps = new HashSet();
        propMap.targetNumberProps = new HashSet();
        try {
            learner.init(cR.getSourceInfo(), cR.getTargetInfo(), param);
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
        Mapping answer = learner.learn(new Mapping());
        Mapping oracleAnswer = new Mapping();
        for (Map.Entry<String, HashMap<String, Double>> e1 : answer.map.entrySet()) {
            for (Map.Entry<String, Double> e2 : e1.getValue().entrySet()) {
                if (o.ask(e1.getKey(), e2.getKey())) {
                    oracleAnswer.add(e1.getKey(), e2.getKey(), 1.0);
                    continue;
                }
                oracleAnswer.add(e1.getKey(), e2.getKey(), 0.0);
            }
        }
        for (int cycle = 0; cycle < 10; ++cycle) {
            System.out.println("Performing learning cycle " + cycle);
            answer = learner.learn(oracleAnswer);
            Metric answerMetric = learner.terminate();
            if (answerMetric.isValid()) {
                resultMapping = learner.getFitnessFunction().getMapping(answerMetric.getExpression(), answerMetric.getThreshold(), true);
                System.out.println("Cycle " + cycle + " Accuracy = " + this.computePrecision(resultMapping, this.datasetSize));
                this.results.put("Cycle(" + cycle + ") Metric: " + answerMetric.toString() + " Accuracy: ", this.computePrecision(resultMapping, this.datasetSize));
            } else {
                Logger.getLogger((String)"Limes").warn((Object)"Method returned no valid metric!");
            }
            System.out.println("Gathering more data from user ... ");
            oracleAnswer = new Mapping();
            for (Map.Entry<String, HashMap<String, Double>> e1 : answer.map.entrySet()) {
                for (Map.Entry<String, Double> e2 : e1.getValue().entrySet()) {
                    if (o.ask(e1.getKey(), e2.getKey())) {
                        oracleAnswer.add(e1.getKey(), e2.getKey(), 1.0);
                        continue;
                    }
                    oracleAnswer.add(e1.getKey(), e2.getKey(), 0.0);
                }
            }
        }
        return resultMapping;
    }

    public Mapping getGeneticActiveLearner(String configFile, String sourceDatasetFile, String targetDatasetFile, Mapping unsupervisedResultMapping) {
        int cyclesCount = 10;
        Mapping resultMapping = new Mapping();
        System.out.println("\n Mapping = " + unsupervisedResultMapping);
        ConfigReader cR = new ConfigReader();
        cR.validateAndRead(configFile);
        cR.sourceInfo.endpoint = sourceDatasetFile;
        cR.sourceInfo.id = sourceDatasetFile.substring(sourceDatasetFile.lastIndexOf("/") >= 0 ? sourceDatasetFile.lastIndexOf("/") + 1 : 0, sourceDatasetFile.lastIndexOf(".") >= 0 ? sourceDatasetFile.lastIndexOf(".") : sourceDatasetFile.length() - 1);
        cR.targetInfo.endpoint = targetDatasetFile;
        cR.targetInfo.id = targetDatasetFile.substring(targetDatasetFile.lastIndexOf("/") >= 0 ? targetDatasetFile.lastIndexOf("/") + 1 : 0, targetDatasetFile.lastIndexOf(".") >= 0 ? targetDatasetFile.lastIndexOf(".") : targetDatasetFile.length() - 1);
        PropertyMapping propMap = new PropertyMapping();
        int max = Math.max(cR.sourceInfo.properties.size(), cR.targetInfo.properties.size());
        for (int i = 0; i < max; ++i) {
            propMap.addStringPropertyMatch(cR.sourceInfo.properties.get(i), cR.targetInfo.properties.get(i));
        }
        System.out.println("propMap: " + propMap);
        GeneticActiveLearner learner = new GeneticActiveLearner();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("populationSize", 20);
        param.put("generations", 10);
        param.put("mutationRate", Float.valueOf(0.5f));
        param.put("preserveFittest", false);
        param.put("propertyMapping", propMap);
        param.put("trainingDataSize", 100);
        param.put("granularity", 2);
        param.put("config", cR);
        propMap.numberPropPairs = new ArrayList<Pair<String>>();
        propMap.sourceNumberProps = new HashSet();
        propMap.targetNumberProps = new HashSet();
        try {
            learner.init(cR.getSourceInfo(), cR.getTargetInfo(), param);
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
        for (int cycle = 0; cycle < cyclesCount; ++cycle) {
            System.out.println("********************************");
            System.out.println("Performing learning cycle ( " + cycle + " )");
            System.out.println("********************************");
            Mapping answer = learner.learn(unsupervisedResultMapping);
            Metric answerMetric = learner.terminate();
            if (answerMetric.isValid()) {
                resultMapping = learner.getFitnessFunction().getMapping(answerMetric.getExpression(), answerMetric.getThreshold(), true);
                System.out.println("Cycle " + cycle + " Accuracy = " + this.computePrecision(resultMapping, this.datasetSize));
                this.results.put("Cycle(" + cycle + ")", this.computePrecision(resultMapping, this.datasetSize));
                this.results.put("Cycle(" + cycle + ") Mitric: " + answerMetric.toString(), null);
                PRFComputer prfC = new PRFComputer();
                this.results.put("Cycle(" + cycle + ") F-Score", prfC.computeFScore(resultMapping, this.optimalMap));
                continue;
            }
            Logger.getLogger((String)"Limes").warn((Object)"Method returned no valid metric!");
        }
        PRFComputer prfC = new PRFComputer();
        return resultMapping;
    }

    public Mapping getGeneticBatchLearner(String configFile, String sourceDatasetFile, String targetDatasetFile, Mapping unsupervisedResultMapping) {
        Mapping resultMapping = new Mapping();
        System.out.println("\n Mapping = " + unsupervisedResultMapping);
        Mapping posMap = new Mapping();
        for (String s : unsupervisedResultMapping.map.keySet()) {
            for (String t : unsupervisedResultMapping.map.get(s).keySet()) {
                if (unsupervisedResultMapping.getSimilarity(s, t) != 1.0) continue;
                posMap.add(s, t, 1.0);
            }
        }
        SimpleOracle o = new SimpleOracle();
        o.loadData(posMap);
        ConfigReader cR = new ConfigReader();
        cR.validateAndRead(configFile);
        cR.sourceInfo.endpoint = sourceDatasetFile;
        cR.sourceInfo.id = sourceDatasetFile.substring(sourceDatasetFile.lastIndexOf("/") >= 0 ? sourceDatasetFile.lastIndexOf("/") + 1 : 0, sourceDatasetFile.lastIndexOf(".") >= 0 ? sourceDatasetFile.lastIndexOf(".") : sourceDatasetFile.length() - 1);
        cR.targetInfo.endpoint = targetDatasetFile;
        cR.targetInfo.id = targetDatasetFile.substring(targetDatasetFile.lastIndexOf("/") >= 0 ? targetDatasetFile.lastIndexOf("/") + 1 : 0, targetDatasetFile.lastIndexOf(".") >= 0 ? targetDatasetFile.lastIndexOf(".") : targetDatasetFile.length() - 1);
        PropertyMapping propMap = new PropertyMapping();
        int max = Math.max(cR.sourceInfo.properties.size(), cR.targetInfo.properties.size());
        for (int i = 0; i < max; ++i) {
            propMap.addStringPropertyMatch(cR.sourceInfo.properties.get(i), cR.targetInfo.properties.get(i));
        }
        System.out.println("propMap: " + propMap);
        LinkSpecificationLearner learner = LinkSpecificationLearnerFactory.getLinkSpecificationLearner("geneticbatchlearner");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("populationSize", 20);
        param.put("generations", 100);
        param.put("mutationRate", Float.valueOf(0.5f));
        param.put("preserveFittest", true);
        param.put("propertyMapping", propMap);
        param.put("trainingDataSize", 50);
        param.put("granularity", 2);
        param.put("config", cR);
        try {
            learner.init(cR.getSourceInfo(), cR.getTargetInfo(), param);
        }
        catch (InvalidConfigurationException e) {
            e.printStackTrace();
        }
        Mapping answer = learner.learn(new Mapping());
        Mapping oracleAnswer = new Mapping();
        for (Map.Entry<String, HashMap<String, Double>> e1 : answer.map.entrySet()) {
            for (Map.Entry<String, Double> e2 : e1.getValue().entrySet()) {
                if (o.ask(e1.getKey(), e2.getKey())) {
                    oracleAnswer.add(e1.getKey(), e2.getKey(), 1.0);
                    continue;
                }
                oracleAnswer.add(e1.getKey(), e2.getKey(), 0.0);
            }
        }
        for (int cycle = 0; cycle < 10; ++cycle) {
            System.out.println("");
            learner.learn(oracleAnswer);
            logger.info((Object)("Learned Cycle " + cycle + " now terminating..."));
            Metric answerMetric = learner.terminate();
            PRFComputer prfC = new PRFComputer();
            resultMapping = learner.getFitnessFunction().getMapping(answerMetric.getExpression(), answerMetric.getThreshold(), true);
            resultMapping = learner.getFitnessFunction().getMapping(answerMetric.getExpression(), answerMetric.getThreshold(), true);
            System.out.println("Cycle " + cycle + " Accuracy = " + this.computePrecision(resultMapping, this.datasetSize));
            this.results.put("Cycle(" + cycle + ")", this.computePrecision(resultMapping, this.datasetSize));
            this.results.put("Cycle(" + cycle + ") Mitric: " + answerMetric.toString(), null);
        }
        return resultMapping;
    }

    public static void main(String[] args) {
        MultiInterlinker multInterlinker = new MultiInterlinker();
        multInterlinker.multilinkPeel();
        System.out.println("=========== RESULTS ACCURACY ===========");
        for (Map.Entry<String, Double> entry : multInterlinker.results.entrySet()) {
            if (entry.getValue() == null) {
                System.out.println(entry.getKey());
                continue;
            }
            System.out.println(entry.getKey() + ": " + entry.getValue());
        }
    }
}

