/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.multilinker;

import de.uni_leipzig.simba.data.Mapping;
import java.util.HashSet;

public class MappingMath {
    public static Mapping multiply(Mapping m1, Mapping m2, boolean useScores) {
        Mapping result = new Mapping();
        HashSet<String> allM2TargetUris = new HashSet<String>();
        for (String m2SourceUri : m2.map.keySet()) {
            for (String m2TargetUri : m2.map.get(m2SourceUri).keySet()) {
                allM2TargetUris.add(m2TargetUri);
            }
        }
        for (String m1SourceUri : m1.map.keySet()) {
            for (String m2TargetUri : allM2TargetUris) {
                double value = 0.0;
                for (String m1TargetUri : m1.map.get(m1SourceUri).keySet()) {
                    if (!m2.contains(m1TargetUri, m2TargetUri)) continue;
                    if (useScores) {
                        value += m1.getSimilarity(m1SourceUri, m1TargetUri) * m2.getSimilarity(m1TargetUri, m2TargetUri);
                        continue;
                    }
                    value += 1.0;
                }
                result.add(m1SourceUri, m2TargetUri, value);
            }
        }
        return result;
    }

    public static Mapping subtract(Mapping m1, Mapping m2, boolean useScores) {
        Mapping result = new Mapping();
        double value = 0.0;
        for (String m1SourceUri : m1.map.keySet()) {
            for (String m1TargetUri : m1.map.get(m1SourceUri).keySet()) {
                if (m2.contains(m1SourceUri, m1TargetUri)) {
                    value = Math.abs(result.getSimilarity(m1SourceUri, m1TargetUri) - m2.getSimilarity(m1SourceUri, m1TargetUri));
                    result.add(m1SourceUri, m1TargetUri, value);
                    continue;
                }
                result.add(m1SourceUri, m1TargetUri, m2.getSimilarity(m1SourceUri, m1TargetUri));
            }
        }
        return result;
    }

    public static Mapping add(Mapping m1, Mapping m2, boolean useScores) {
        Mapping result = new Mapping();
        double simValue = 0.0;
        for (String m1SourceUri : m1.map.keySet()) {
            for (String m1TargetUri : m1.map.get(m1SourceUri).keySet()) {
                simValue = 0.0;
                simValue = m2.contains(m1SourceUri, m1TargetUri) ? (useScores ? m1.getSimilarity(m1SourceUri, m1TargetUri) + m2.getSimilarity(m1SourceUri, m1TargetUri) : Math.ceil(m1.getSimilarity(m1SourceUri, m1TargetUri)) + Math.ceil(m2.getSimilarity(m1SourceUri, m1TargetUri))) : (useScores ? m1.getSimilarity(m1SourceUri, m1TargetUri) : Math.ceil(m1.getSimilarity(m1SourceUri, m1TargetUri)));
                result.add(m1SourceUri, m1TargetUri, simValue);
            }
        }
        for (String m2SourceUri : m2.map.keySet()) {
            for (String m2TargetUri : m2.map.get(m2SourceUri).keySet()) {
                if (result.contains(m2SourceUri, m2TargetUri)) continue;
                if (useScores) {
                    result.add(m2SourceUri, m2TargetUri, m2.getSimilarity(m2SourceUri, m2TargetUri));
                    continue;
                }
                result.add(m2SourceUri, m2TargetUri, Math.ceil(m2.getSimilarity(m2SourceUri, m2TargetUri)));
            }
        }
        return result;
    }

    public static void main(String[] args) {
        Mapping m1 = new Mapping();
        Mapping m2 = new Mapping();
        m1.add("a1", "a2", 0.1);
        m1.add("b1", "b2", 0.1);
        m2.add("b1", "b2", 0.1);
        m2.add("c1", "c2", 0.1);
        System.out.println(MappingMath.add(m1, m2, false));
    }
}

