/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.metricfactory;

import de.uni_leipzig.simba.data.Instance;
import de.uni_leipzig.simba.metricfactory.MetricFactory;
import de.uni_leipzig.simba.metricfactory.simGIC;
import org.apache.log4j.Logger;
import uk.ac.shef.wit.simmetrics.similaritymetrics.AbstractStringMetric;
import uk.ac.shef.wit.simmetrics.similaritymetrics.BlockDistance;
import uk.ac.shef.wit.simmetrics.similaritymetrics.EuclideanDistance;
import uk.ac.shef.wit.simmetrics.similaritymetrics.Levenshtein;
import uk.ac.shef.wit.simmetrics.similaritymetrics.QGramsDistance;

public class SimpleMetricFactory
implements MetricFactory {
    AbstractStringMetric metric = null;
    String property1;
    String property2;
    String sourceVar;
    String targetVar;
    Logger logger = Logger.getLogger((String)"LIMES");
    int counter = 0;

    public SimpleMetricFactory(String sourceVariable, String targetVariable) {
        this.sourceVar = sourceVariable;
        this.targetVar = targetVariable;
    }

    public void setExpression(String expression) {
        this.metric = new Levenshtein();
        if (expression.toLowerCase().startsWith("blockdistance")) {
            this.metric = new BlockDistance();
        } else if (expression.toLowerCase().startsWith("euclidean")) {
            this.metric = new EuclideanDistance();
        } else if (expression.toLowerCase().startsWith("qgrams")) {
            this.metric = new QGramsDistance();
        } else if (expression.toLowerCase().startsWith("levenshtein")) {
            this.metric = new Levenshtein();
        } else if (expression.toLowerCase().startsWith("simgic")) {
            this.metric = new simGIC();
        }
        this.logger.info((Object)("Expression = " + expression));
        expression = expression.substring(expression.indexOf("(") + 1, expression.indexOf(")"));
        this.logger.info((Object)("Variables = " + expression));
        String[] split = expression.split(",");
        if (split[0].contains(this.sourceVar.replaceAll("\\?", ""))) {
            this.property1 = split[0].substring(split[0].indexOf(".") + 1);
            this.property2 = split[1].substring(split[1].indexOf(".") + 1);
        } else {
            this.property2 = split[0].substring(split[0].indexOf(".") + 1);
            this.property1 = split[1].substring(split[1].indexOf(".") + 1);
        }
    }

    public float getSimilarity(String a, String b) {
        return this.metric.getSimilarity(a, b);
    }

    public float getSimilarity(Instance a, Instance b) {
        float max = 0.0f;
        float metricValue = 0.0f;
        for (String value1 : a.getProperty(this.property1)) {
            for (String value2 : b.getProperty(this.property2)) {
                metricValue = this.metric.getSimilarity(value1, value2);
                ++this.counter;
                if (!(metricValue > max)) continue;
                max = metricValue;
            }
        }
        return max;
    }

    public int getComparisons() {
        return this.counter;
    }

    public String foldExpression(String expression, String var1, String var2) {
        String copy = expression + "";
        String props = expression.substring(expression.indexOf("(") + 1, expression.indexOf(")"));
        String[] split = props.split(",");
        split[0] = split[0].trim();
        split[1] = split[1].trim();
        copy = split[0].startsWith(var1) ? copy.replaceAll(split[1], split[0]) : copy.replaceAll(split[0], split[1]);
        return copy;
    }
}

