/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.metricfactory;

public class Parser {
    String expression;
    public String term1;
    public String term2;
    public String op;
    public double threshold;
    public double threshold1;
    public double threshold2;

    public Parser(String input, double theta) {
        this.expression = input.replaceAll(" ", "");
        this.expression = this.expression.toLowerCase();
        this.threshold = theta;
        this.getTerms();
    }

    public boolean isAtomic() {
        return !this.expression.contains("max(") && !this.expression.contains("min(") && !this.expression.contains("and(") && !this.expression.contains("or(") && !this.expression.contains("add(") && !this.expression.contains("xor(");
    }

    public String getTerm1() {
        return this.term1;
    }

    public String getOperation() {
        return this.op;
    }

    public String getTerm2() {
        return this.term2;
    }

    public double getCoef1() {
        if (!this.term1.contains("*")) {
            return 1.0;
        }
        String[] split = this.term1.split("\\*");
        try {
            double coef = Double.parseDouble(split[0]);
            this.term1 = split[1];
            return coef;
        }
        catch (Exception e) {
            return 1.0;
        }
    }

    public double getCoef2() {
        if (!this.term2.contains("*")) {
            return 1.0;
        }
        String[] split = this.term2.split("\\*");
        try {
            double coef = Double.parseDouble(split[0]);
            this.term2 = split[1];
            return coef;
        }
        catch (Exception e) {
            return 1.0;
        }
    }

    public void getTerms() {
        if (!this.isAtomic()) {
            int counter = 1;
            boolean found = false;
            this.op = this.expression.substring(0, this.expression.indexOf("("));
            String noOpExpression = this.expression.substring(this.expression.indexOf("(") + 1, this.expression.lastIndexOf(")"));
            for (int i = 0; i < noOpExpression.length(); ++i) {
                if (noOpExpression.charAt(i) == '(') {
                    ++counter;
                    found = true;
                    continue;
                }
                if (noOpExpression.charAt(i) == ')') {
                    --counter;
                    found = true;
                    continue;
                }
                if (counter != 1 || !found || noOpExpression.charAt(i) != ',') continue;
                this.term1 = noOpExpression.substring(0, i);
                this.term2 = noOpExpression.substring(i + 1);
            }
            if (this.op.equals("min") || this.op.equals("max")) {
                this.threshold1 = this.threshold;
                this.threshold2 = this.threshold;
            } else if (this.op.equals("add")) {
                this.op = "add";
                double coef1 = this.getCoef1();
                double coef2 = this.getCoef2();
                System.out.println(coef1 + " " + coef2);
                this.threshold1 = (this.threshold - coef2) / coef1;
                this.threshold2 = (this.threshold - coef1) / coef2;
            } else {
                String set1 = this.term1.split("\\|")[0];
                this.threshold1 = Double.parseDouble(this.term1.split("\\|")[1]);
                this.term1 = set1;
                String set2 = this.term2.split("\\|")[0];
                this.threshold2 = Double.parseDouble(this.term2.split("\\|")[1]);
                this.term2 = set2;
            }
        } else {
            this.op = this.expression.substring(0, this.expression.indexOf("("));
            String noOpExpression = this.expression.substring(this.expression.indexOf("(") + 1, this.expression.lastIndexOf(")"));
            String[] split = noOpExpression.split(",");
            this.term1 = split[0];
            this.term2 = split[1];
        }
    }

    public static void testParsing(String s, double threshold) {
        Parser p = new Parser(s, threshold);
        if (p.isAtomic()) {
            System.out.println("-->" + s + " with threshold " + threshold + " will be carried out.");
        } else {
            Parser.testParsing(p.term1, p.threshold1);
            Parser.testParsing(p.term2, p.threshold2);
            System.out.println("--> <" + p.op + "> will be carried out on " + p.term1 + " and " + p.term2 + " with " + "threshold " + threshold);
        }
    }

    public static void main(String[] args) {
        String m = "levenshtein(x.http://www.okkam.org/ontology_person1.owl#surname, y.http://www.okkam.org/ontology_person2.owl#surname)";
        Parser.testParsing(m, 0.5);
        Parser p = new Parser(m, 0.5);
        System.out.println(p.isAtomic());
        System.out.println(p.op);
        System.out.println(p.term1);
        System.out.println(p.term2);
    }
}

