/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.metricfactory;

import de.uni_leipzig.simba.data.Instance;
import de.uni_leipzig.simba.metricfactory.MetricFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import uk.ac.shef.wit.simmetrics.similaritymetrics.BlockDistance;
import uk.ac.shef.wit.simmetrics.similaritymetrics.EuclideanDistance;
import uk.ac.shef.wit.simmetrics.similaritymetrics.Levenshtein;
import uk.ac.shef.wit.simmetrics.similaritymetrics.QGramsDistance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplexMetricFactory
implements MetricFactory {
    String metricExpression = null;
    Logger logger = Logger.getLogger((String)"LIMES");
    int counter = 0;
    private Stacklist stacklist;
    private String output = "";
    private String var1 = "x";
    private String var2 = "y";

    public void setSourceVar(String s) {
        this.var1 = s;
    }

    public void setTargerVar(String s) {
        this.var2 = s;
    }

    @Override
    public void setExpression(String expression) {
        this.metricExpression = expression;
        expression = expression.replaceAll(".", "_");
        expression = expression.replaceAll(" ", "?");
        int stacklistSize = expression.length();
        this.stacklist = new Stacklist(stacklistSize);
        this.metricExpression = this.metricExpression.toLowerCase();
        this.logger.info((Object)("Transforming " + this.metricExpression));
        this.metricExpression = this.metricExpression.replaceAll("max", "xam");
        this.metricExpression = this.metricExpression.replaceAll("euclidean", "naedilcuE");
        this.metricExpression = this.metricExpression.replaceAll("blockdistance", "ecnatsidkcolb");
        this.metricExpression = this.metricExpression.replaceAll("avg", "gva");
        this.metricExpression = this.metricExpression.replaceAll("min", "nim");
        this.metricExpression = this.metricExpression.replaceAll("levenshtein", "niethsnevel");
        this.metricExpression = this.metricExpression.replaceAll("qgrams", "smargq");
        this.metricExpression = this.toPostfix(this.metricExpression);
        String localExpression = this.metricExpression = this.metricExpression.replaceAll("MAX", " MAX");
        String[] split = localExpression.split(" ");
        for (int i = 0; i < split.length; ++i) {
            if (!split[i].contains("_")) continue;
            String reverse = new StringBuffer(split[i]).reverse().toString();
            this.logger.info((Object)(split[i] + " reversed to " + reverse));
            this.metricExpression = this.metricExpression.replaceAll(split[i], reverse);
        }
        this.logger.info((Object)("The reversed Input is " + this.metricExpression + '\n'));
    }

    public float evaluateExpression(String s) {
        StringTokenizer st = new StringTokenizer(s);
        Stack<Object> stack = new Stack<Object>();
        block7: while (st.hasMoreTokens()) {
            String token = st.nextToken();
            try {
                stack.push(Float.valueOf(Float.parseFloat(token)));
                stack.push(new Float(token));
                System.out.println("New Number Processed " + token);
            }
            catch (NumberFormatException e) {
                float f1;
                String s2;
                String s1;
                double v1;
                double v2;
                String tmp = "";
                switch (token.charAt(0)) {
                    case '*': {
                        v2 = Double.valueOf(stack.pop().toString());
                        v1 = Double.valueOf(stack.pop().toString());
                        System.out.println("Multiplying " + v1 + " * " + v2);
                        System.out.println("Product Processed " + v1 * v2);
                        stack.push(new Float(v1 * v2));
                        continue block7;
                    }
                    case '+': {
                        v2 = Double.valueOf(stack.pop().toString());
                        v1 = Double.valueOf(stack.pop().toString());
                        System.out.println("Adding " + v1 + " + " + v2);
                        System.out.println("Sum Processed " + (v1 + v2));
                        stack.push(new Double(v1 + v2));
                        continue block7;
                    }
                    case '-': {
                        v2 = Double.valueOf(stack.pop().toString());
                        v1 = Double.valueOf(stack.pop().toString());
                        System.out.println("Subtracting " + v1 + " - " + v2);
                        System.out.println("Difference Processed " + (v1 - v2));
                        stack.push(new Double(v1 - v2));
                        continue block7;
                    }
                }
                tmp = token.toString();
                String decimalPattern = "(\\d{1,3})?(.)?(\\d{1,3})?";
                if (tmp.toLowerCase().matches("euclidean")) {
                    s1 = stack.pop().toString();
                    s2 = stack.pop().toString();
                    System.out.println("Euclidean of " + s1 + " and " + s2);
                    v1 = new EuclideanDistance().getEuclidDistance(s1, s2);
                    System.out.println("Euclidean Processed " + v1);
                    stack.push(v1);
                    tmp = "";
                    continue;
                }
                if (tmp.toLowerCase().matches("blockdistance")) {
                    s2 = stack.pop().toString();
                    s1 = stack.pop().toString();
                    System.out.println("Blockdistance of " + s1 + " and " + s2);
                    f1 = new BlockDistance().getSimilarity(s1, s2);
                    System.out.println("Blockdistance Processed " + f1);
                    stack.push(Float.valueOf(f1));
                    tmp = "";
                    continue;
                }
                if (tmp.toLowerCase().matches("qgrams")) {
                    s1 = stack.pop().toString();
                    s2 = stack.pop().toString();
                    System.out.println("Qgrams of " + s1 + " and " + s2);
                    f1 = new QGramsDistance().getSimilarity(s1, s2);
                    System.out.println("Qgrams Processed " + f1);
                    stack.push(Float.valueOf(f1));
                    tmp = "";
                    continue;
                }
                if (tmp.toLowerCase().matches("max")) {
                    v2 = (Double)stack.pop();
                    v1 = (Double)stack.pop();
                    System.out.println("MAX of " + v1 + " and " + v2);
                    stack.push(new Double(Math.max(v1, v2)));
                    tmp = "";
                    continue;
                }
                if (tmp.toLowerCase().matches("avg")) {
                    v2 = (Double)stack.pop();
                    v1 = (Double)stack.pop();
                    System.out.println("AVG of " + v1 + " and " + v2);
                    System.out.println("AVG Processed " + (v1 + v2));
                    stack.push(new Double(v1 + v2) / 2.0);
                    tmp = "";
                    continue;
                }
                if (tmp.toLowerCase().matches("min")) {
                    v2 = (Double)stack.pop();
                    v1 = (Double)stack.pop();
                    System.out.println("MIN of " + v1 + " and " + v2);
                    System.out.println("MIN Processed " + (v1 + v2));
                    stack.push(new Double(Math.min(v1, v2)));
                    tmp = "";
                    continue;
                }
                if (tmp.toLowerCase().matches("levenshtein")) {
                    s1 = stack.pop().toString();
                    s2 = stack.pop().toString();
                    System.out.println("Levenshtein of " + s1 + " and " + s2);
                    f1 = new Levenshtein().getSimilarity(s1, s2);
                    System.out.println("Levenshtein Processed " + f1);
                    stack.push(Float.valueOf(f1));
                    tmp = "";
                    continue;
                }
                stack.push(tmp.toLowerCase().toString());
                System.out.println("String " + tmp + " to be processed.");
            }
        }
        return new Float((Double)stack.pop()).floatValue();
    }

    static List<Token> tokenize(String source, List<Rule> rules) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        int end = source.length();
        Matcher m = Pattern.compile("dummy").matcher(source);
        m.useTransparentBounds(false).useAnchoringBounds(false);
        block0: for (int pos = 0; pos < end; ++pos) {
            m.region(pos, end);
            for (Rule r : rules) {
                if (!m.usePattern(r.pattern).lookingAt()) continue;
                tokens.add(new Token(r.name, m.start(), m.end()));
                pos = m.end();
                continue block0;
            }
        }
        return tokens;
    }

    @Override
    public float getSimilarity(Instance a, Instance b) {
        String localExpression = this.metricExpression;
        String[] expression = localExpression.split(" ");
        float similarity = 0.0f;
        try {
            for (int i = 0; i < expression.length; ++i) {
                String value;
                String property;
                if (!expression[i].contains("_")) continue;
                if (expression[i].startsWith(this.var1)) {
                    property = expression[i].substring(expression[i].indexOf("_") + 1);
                    value = a.getProperty(property).first();
                    value = this.removeExtraCharacters(value);
                    localExpression = localExpression.replaceAll(expression[i], value);
                    this.logger.info((Object)("New local expression = " + localExpression));
                    continue;
                }
                if (!expression[i].startsWith(this.var2)) continue;
                property = expression[i].substring(expression[i].indexOf("_") + 1);
                value = b.getProperty(property).first();
                value = this.removeExtraCharacters(value);
                localExpression = localExpression.replaceAll(expression[i], value);
                this.logger.info((Object)("New local expression = " + localExpression));
            }
            this.logger.info((Object)("New expression is " + localExpression));
            similarity = this.evaluateExpression(localExpression);
        }
        catch (Exception e) {
            this.logger.warn((Object)e.getMessage());
        }
        return similarity;
    }

    public String removeExtraCharacters(String value) {
        this.logger.info((Object)("Input = " + value));
        value = value.replaceAll(" ", "?");
        value = value.replaceAll("\\.", "_");
        value = value.replaceAll("\\*", "_");
        value = value.replaceAll("\\+", "_");
        value = value.replaceAll("-", "_");
        this.logger.info((Object)("Output = " + value));
        return value;
    }

    @Override
    public String foldExpression(String expression, String var1, String var2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String toPostfix(String input) {
        block9: for (int j = 0; j < input.length(); ++j) {
            char ch = input.charAt(j);
            switch (ch) {
                case '+': 
                case '-': {
                    this.gotOperator(ch, 1);
                    continue block9;
                }
                case '*': 
                case '/': {
                    this.gotOperator(ch, 2);
                    continue block9;
                }
                case '(': {
                    this.stacklist.push(ch);
                    continue block9;
                }
                case ')': {
                    this.gotParenthesis(ch);
                    continue block9;
                }
                case ',': {
                    this.gotSeparator(ch);
                    continue block9;
                }
                case '.': {
                    this.output = this.output + ch;
                    continue block9;
                }
                case ' ': {
                    this.output = this.output + ch;
                    continue block9;
                }
                default: {
                    if (Character.isDigit(ch)) {
                        this.output = this.output + ch;
                        continue block9;
                    }
                    this.stacklist.push(ch);
                }
            }
        }
        while (!this.stacklist.isEmpty()) {
            this.output = this.output + this.stacklist.pop();
        }
        System.out.println(this.output);
        return this.output;
    }

    public void gotOperator(char opThis, int prec1) {
        this.stacklist.push(' ');
        while (!this.stacklist.isEmpty()) {
            char opTop = this.stacklist.pop();
            if (opTop == '(') {
                this.stacklist.push(opTop);
                break;
            }
            int prec2 = opTop == '+' || opTop == '-' ? 1 : 2;
            if (prec2 < prec1) {
                this.stacklist.push(opTop);
                break;
            }
            this.output = this.output + opTop;
        }
        this.stacklist.push(' ');
        this.stacklist.push(opThis);
        this.stacklist.push(' ');
    }

    public void gotParenthesis(char ch) {
        char chx;
        while (!this.stacklist.isEmpty() && (chx = this.stacklist.pop()) != '(') {
            this.output = this.output + chx;
        }
        this.output = this.output + " ";
    }

    public void gotSeparator(char ch) {
        this.output = this.output + " ";
        while (!this.stacklist.isEmpty()) {
            char chx = this.stacklist.pop();
            if (chx == '(') {
                this.stacklist.push(chx);
                break;
            }
            this.output = this.output + chx;
        }
        this.output = this.output + " ";
    }

    public static void main(String[] args) {
        ComplexMetricFactory cmf = new ComplexMetricFactory();
        cmf.setExpression("0.5 *Euclidean (x_title, y_title)+0.5*QGrams (y_name, x_familyName)");
        Instance a = new Instance("uri1");
        Instance b = new Instance("uri2");
        a.addProperty("title", "Dr. rer. nat");
        a.addProperty("familyname", "NgongaNgomo");
        b.addProperty("name", "AxelNgonga");
        b.addProperty("title", "Dr.");
        System.out.println("Similarity is " + cmf.getSimilarity(a, b));
    }

    class Stacklist {
        private int maxSize;
        private char[] stacklistArray;
        private int top;

        public Stacklist(int max) {
            this.maxSize = max;
            this.stacklistArray = new char[this.maxSize];
            this.top = -1;
        }

        public void push(char j) {
            this.stacklistArray[++this.top] = j;
        }

        public char pop() {
            return this.stacklistArray[this.top--];
        }

        public char peek() {
            return this.stacklistArray[this.top];
        }

        public boolean isEmpty() {
            return this.top == -1;
        }
    }

    static class Token {
        final String name;
        final int startPos;
        final int endPos;

        Token(String name, int startPos, int endPos) {
            this.name = name;
            this.startPos = startPos;
            this.endPos = endPos;
        }

        public String toString() {
            return String.format("Token [%2d, %2d, %s]", this.startPos, this.endPos, this.name);
        }
    }

    private static class Rule {
        final String name;
        final Pattern pattern;

        public Rule(String name, String regex) {
            this.name = name;
            this.pattern = Pattern.compile(regex);
        }
    }
}

