/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.measures.string;

import de.uni_leipzig.simba.cache.MemoryCache;
import de.uni_leipzig.simba.data.Instance;
import de.uni_leipzig.simba.measures.string.StringMeasure;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrigramMeasure
implements StringMeasure {
    @Override
    public double getSimilarity(int overlap, int lengthA, int lengthB) {
        return 2.0 * (double)overlap / (double)(lengthA + lengthB);
    }

    @Override
    public String getType() {
        return "string";
    }

    @Override
    public double getSimilarity(Instance a, Instance b, String property1, String property2) {
        double sim = 0.0;
        double max = 0.0;
        for (String p1 : a.getProperty(property1)) {
            for (String p2 : b.getProperty(property2)) {
                sim = this.getSimilarity(p1, p2);
                if (!(max < sim)) continue;
                max = sim;
            }
        }
        return max;
    }

    @Override
    public String getName() {
        return "Trigram";
    }

    @Override
    public double getSimilarity(Object a, Object b) {
        String p1 = "  " + a + "  ";
        String p2 = "  " + b + "  ";
        if (p1.length() == 4 && p2.length() == 4) {
            return 1.0;
        }
        if (p1.length() == 4 && p2.length() > 4 || p2.length() == 4 && p1.length() > 4) {
            return 0.0;
        }
        TreeSet<String> t1 = this.getTrigrams(p1);
        TreeSet<String> t2 = this.getTrigrams(p2);
        double counter = 0.0;
        for (String s : t1) {
            if (!t2.contains(s)) continue;
            counter += 1.0;
        }
        return 2.0 * counter / (double)(t1.size() + t2.size());
    }

    public TreeSet<String> getTrigrams(String a) {
        TreeSet<String> result = new TreeSet<String>();
        String copy = a;
        for (int i = 2; i < copy.length(); ++i) {
            result.add(copy.substring(i - 2, i));
        }
        return result;
    }

    @Override
    public int getPrefixLength(int tokensNumber, double threshold) {
        int k = 1;
        if (threshold == 0.0) {
            k = 0;
        }
        return tokensNumber - (int)Math.ceil((float)((double)tokensNumber * threshold / (2.0 - threshold))) + k;
    }

    @Override
    public int getMidLength(int tokensNumber, double threshold) {
        int k = 1;
        if (threshold == 0.0) {
            k = 0;
        }
        return tokensNumber - (int)Math.ceil((float)((double)tokensNumber * threshold)) + k;
    }

    @Override
    public double getSizeFilteringThreshold(int tokensNumber, double threshold) {
        return threshold / (2.0 - threshold) * (double)tokensNumber;
    }

    @Override
    public int getAlpha(int xTokensNumber, int yTokensNumber, double threshold) {
        return (int)Math.ceil((float)(threshold / 2.0 * (double)(xTokensNumber + yTokensNumber)));
    }

    public static void main(String[] args) {
        MemoryCache source = new MemoryCache();
        MemoryCache target = new MemoryCache();
        source.addTriple("S1", "pub", "Perth Airport");
        source.addTriple("S1", "conf", "conf1");
        source.addTriple("S2", "pub", "test2");
        source.addTriple("S2", "conf", "conf2");
        target.addTriple("S1", "pub", "Perth International Airport");
        target.addTriple("S1", "conf", "conf1");
        target.addTriple("S3", "pub", "test3");
        target.addTriple("S3", "conf", "conf3");
        System.out.println(new TrigramMeasure().getSimilarity(source.getInstance("S1"), target.getInstance("S3"), "pub", "pub"));
    }

    @Override
    public boolean computableViaOverlap() {
        return true;
    }

    @Override
    public double getRuntimeApproximation(double mappingSize) {
        return mappingSize / 10000.0;
    }
}

