/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.measures.string;

import de.uni_leipzig.simba.data.Instance;
import de.uni_leipzig.simba.mapper.atomic.fastngram.NGramTokenizer;
import de.uni_leipzig.simba.mapper.atomic.fastngram.Tokenizer;
import de.uni_leipzig.simba.measures.string.StringMeasure;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QGramSimilarity
implements StringMeasure {
    Tokenizer tokenizer = new NGramTokenizer();
    int q = 3;

    public QGramSimilarity(int q) {
    }

    public QGramSimilarity() {
    }

    public double getSimilarity(String x, String y) {
        Set<String> yTokens = this.tokenizer.tokenize(y, this.q);
        Set<String> xTokens = this.tokenizer.tokenize(x, this.q);
        return this.getSimilarity(xTokens, yTokens);
    }

    public double getSimilarity(Set<String> X, Set<String> Y) {
        double x = X.size();
        double y = Y.size();
        HashSet<String> K = new HashSet<String>();
        for (String s : X) {
            K.add(s);
        }
        K.retainAll(Y);
        double z = K.size();
        return z / (x + y - z);
    }

    public static void main(String[] args) {
        System.out.println(new QGramSimilarity().getSimilarity("abcd", "abcde"));
    }

    @Override
    public int getPrefixLength(int tokensNumber, double threshold) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getMidLength(int tokensNumber, double threshold) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double getSizeFilteringThreshold(int tokensNumber, double threshold) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getAlpha(int xTokensNumber, int yTokensNumber, double threshold) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double getSimilarity(int overlap, int lengthA, int lengthB) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean computableViaOverlap() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public double getSimilarity(Object a, Object b) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getType() {
        return "string";
    }

    @Override
    public double getSimilarity(Instance a, Instance b, String property1, String property2) {
        double value = 0.0;
        double sim = 0.0;
        for (String source : a.getProperty(property1)) {
            for (String target : b.getProperty(property2)) {
                sim = this.getSimilarity(source, target);
                if (!(sim > value)) continue;
                value = sim;
            }
        }
        return sim;
    }

    @Override
    public String getName() {
        return "qgrams";
    }

    @Override
    public double getRuntimeApproximation(double mappingSize) {
        return mappingSize / 10000.0;
    }
}

