/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.measures.string;

import de.uni_leipzig.simba.data.Instance;
import de.uni_leipzig.simba.measures.string.StringMeasure;
import uk.ac.shef.wit.simmetrics.similaritymetrics.JaccardSimilarity;

public class JaccardMeasure
implements StringMeasure {
    public double getSimilarityChar(Object a, Object b) {
        String p1 = a + "";
        String p2 = b + "";
        String r1 = "";
        for (int i = 0; i < p1.length(); ++i) {
            r1 = r1 + " " + p1.charAt(i);
        }
        r1 = r1.trim();
        String r2 = "";
        for (int i = 0; i < p2.length(); ++i) {
            r2 = r2 + " " + p2.charAt(i);
        }
        r2 = r2.trim();
        return new JaccardSimilarity().getSimilarity(r1, r2);
    }

    public double getSimilarity(Object a, Object b) {
        return new JaccardSimilarity().getSimilarity(a + "", b + "");
    }

    public String getType() {
        return "string";
    }

    public double getSimilarity(Instance a, Instance b, String property1, String property2) {
        double sim = 0.0;
        double max = 0.0;
        for (String p1 : a.getProperty(property1)) {
            for (String p2 : b.getProperty(property2)) {
                sim = this.getSimilarity(p1, p2);
                if (!(max < sim)) continue;
                max = sim;
            }
        }
        return max;
    }

    public String getName() {
        return "Jaccard";
    }

    public double getSimilarity(int overlap, int lengthA, int lengthB) {
        return (double)overlap / (double)(lengthA + lengthA - overlap);
    }

    public int getPrefixLength(int tokensNumber, double threshold) {
        int k = 1;
        if (threshold == 0.0) {
            k = 0;
        }
        return tokensNumber - (int)Math.ceil((float)((double)tokensNumber * threshold)) + k;
    }

    public int getMidLength(int tokensNumber, double threshold) {
        int k = 1;
        if (threshold == 0.0) {
            k = 0;
        }
        return tokensNumber - (int)Math.ceil((float)((double)(tokensNumber * 2) * threshold / (1.0 + threshold))) + k;
    }

    public double getSizeFilteringThreshold(int tokensNumber, double threshold) {
        return threshold * (double)tokensNumber;
    }

    public int getAlpha(int xTokensNumber, int yTokensNumber, double threshold) {
        return (int)Math.ceil((float)(threshold / (1.0 + threshold) * (double)(xTokensNumber + yTokensNumber)));
    }

    public boolean computableViaOverlap() {
        return true;
    }

    public double getRuntimeApproximation(double mappingSize) {
        return mappingSize / 10000.0;
    }
}

