/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.measures.space.blocking;

import de.uni_leipzig.simba.data.Instance;
import de.uni_leipzig.simba.measures.space.SpaceMeasure;
import de.uni_leipzig.simba.measures.space.SpaceMeasureFactory;
import de.uni_leipzig.simba.measures.space.blocking.BlockingModule;
import java.util.ArrayList;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoBlockingModule
implements BlockingModule {
    static Logger logger = Logger.getLogger((String)"LIMES");
    int dim = 2;
    ArrayList<Double> thresholds = new ArrayList();
    ArrayList<String> properties = new ArrayList();
    SpaceMeasure measure;
    Instance zero;
    int latLimit;
    int longLimit;

    public GeoBlockingModule(String props, String measureName, double threshold) {
        String[] split = props.split("\\|");
        this.dim = split.length;
        if (this.dim > 2) {
            logger.warn((Object)("Dimensions higher than 2. Hope we are on a " + (this.dim + 1) + "D planet."));
        }
        this.measure = SpaceMeasureFactory.getMeasure(measureName, this.dim);
        for (int i = 0; i < this.dim; ++i) {
            this.thresholds.add(this.measure.getThreshold(i, threshold));
            this.properties.add(split[i]);
            if (split[i].toLowerCase().startsWith("la")) {
                this.latLimit = (int)(90.0 / this.thresholds.get(i));
            }
            if (!split[i].toLowerCase().startsWith("lo")) continue;
            this.longLimit = (int)(180.0 / this.thresholds.get(i));
        }
    }

    @Override
    public ArrayList<ArrayList<Integer>> getBlocksToCompare(ArrayList<Integer> blockId) {
        int dim = blockId.size();
        if (dim == 0) {
            return new ArrayList<ArrayList<Integer>>();
        }
        ArrayList<ArrayList<Integer>> result = new ArrayList<ArrayList<Integer>>();
        ArrayList buffer = new ArrayList();
        result.add(blockId);
        ArrayList<Integer> minus = new ArrayList<Integer>();
        ArrayList<Integer> plus = new ArrayList<Integer>();
        ArrayList<Integer> copy = new ArrayList<Integer>();
        for (int i = 0; i < dim; ++i) {
            minus.add(0);
            copy.add(0);
            plus.add(0);
        }
        for (int i = 0; i < dim; ++i) {
            int j = 0;
            while ((double)j < Math.pow(3.0, i)) {
                ArrayList<Integer> id = result.get(j);
                minus = new ArrayList();
                plus = new ArrayList();
                for (int k = 0; k < dim; ++k) {
                    if (k != i) {
                        minus.add(id.get(k));
                        plus.add(id.get(k));
                        continue;
                    }
                    minus.add(id.get(k) - 1);
                    plus.add(id.get(k) + 1);
                }
                result.add(minus);
                result.add(plus);
                ++j;
            }
        }
        for (int i = 0; i < result.size(); ++i) {
            for (int j = 0; j < dim; ++j) {
                int value = result.get(i).get(j);
                if (this.properties.get(i).startsWith("la")) {
                    if (value > this.latLimit) {
                        result.get(i).set(j, value - 2 * this.latLimit);
                    } else if (value < this.latLimit) {
                        result.get(i).set(j, value + 2 * this.latLimit);
                    }
                }
                if (!this.properties.get(i).startsWith("lo")) continue;
                if (value > this.longLimit) {
                    result.get(i).set(j, value - 2 * this.longLimit);
                    continue;
                }
                if (value >= this.longLimit) continue;
                result.get(i).set(j, value + 2 * this.longLimit);
            }
        }
        return result;
    }

    @Override
    public ArrayList<Integer> getBlockId(Instance a) {
        ArrayList<Integer> blockIds = new ArrayList<Integer>();
        for (int i = 0; i < this.dim; ++i) {
            double value = Double.parseDouble(a.getProperty(this.properties.get(i)).first());
            if (this.properties.get(i).startsWith("la")) {
                if (value > (double)this.latLimit) {
                    value -= (double)(2 * this.latLimit);
                } else if (value < (double)this.latLimit) {
                    value += (double)(2 * this.latLimit);
                }
            }
            if (this.properties.get(i).startsWith("lo")) {
                if (value > (double)this.longLimit) {
                    value -= (double)(2 * this.longLimit);
                } else if (value < (double)this.longLimit) {
                    value += (double)(2 * this.longLimit);
                }
            }
            int blockId = (int)Math.floor(value / this.thresholds.get(i));
            blockIds.add(blockId);
        }
        return blockIds;
    }

    @Override
    public ArrayList<ArrayList<Integer>> getAllBlockIds(Instance a) {
        ArrayList<ArrayList<Integer>> list = new ArrayList<ArrayList<Integer>>();
        list.add(this.getBlockId(a));
        return list;
    }

    @Override
    public ArrayList<ArrayList<Integer>> getAllSourceIds(Instance a, String props) {
        String[] sourceProps = props.split("\\|");
        ArrayList<ArrayList<Integer>> list = new ArrayList<ArrayList<Integer>>();
        ArrayList<Integer> blockIds = new ArrayList<Integer>();
        for (int i = 0; i < this.dim; ++i) {
            double value = Double.parseDouble(a.getProperty(sourceProps[i]).first());
            if (sourceProps[i].startsWith("la")) {
                if (value > (double)this.latLimit) {
                    value -= (double)(2 * this.latLimit);
                } else if (value < (double)this.latLimit) {
                    value += (double)(2 * this.latLimit);
                }
            }
            if (sourceProps[i].startsWith("lo")) {
                if (value > (double)this.longLimit) {
                    value -= (double)(2 * this.longLimit);
                } else if (value < (double)this.longLimit) {
                    value += (double)(2 * this.longLimit);
                }
            }
            int blockId = (int)Math.floor(value / this.thresholds.get(i));
            blockIds.add(blockId);
        }
        return list;
    }
}

