/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.measures.space.blocking;

import de.uni_leipzig.simba.cache.MemoryCache;
import de.uni_leipzig.simba.data.Instance;
import de.uni_leipzig.simba.measures.space.SpaceMeasure;
import de.uni_leipzig.simba.measures.space.SpaceMeasureFactory;
import de.uni_leipzig.simba.measures.space.blocking.BlockingModule;
import java.util.ArrayList;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EuclideanBlockingModule
implements BlockingModule {
    int dim = 2;
    ArrayList<Double> thresholds = new ArrayList();
    ArrayList<String> properties = new ArrayList();
    SpaceMeasure measure;
    Instance zero;

    public EuclideanBlockingModule(String props, String measureName, double threshold) {
        String[] split = props.split("\\|");
        this.dim = split.length;
        this.measure = SpaceMeasureFactory.getMeasure(measureName, this.dim);
        for (int i = 0; i < this.dim; ++i) {
            this.thresholds.add(this.measure.getThreshold(i, threshold));
            this.properties.add(split[i]);
        }
    }

    @Override
    public ArrayList<Integer> getBlockId(Instance a) {
        ArrayList<Integer> blockIds = new ArrayList<Integer>();
        for (int i = 0; i < this.dim; ++i) {
            double value = Double.parseDouble(a.getProperty(this.properties.get(i)).first());
            int blockId = (int)Math.floor(value / this.thresholds.get(i));
            blockIds.add(blockId);
        }
        return blockIds;
    }

    @Override
    public ArrayList<ArrayList<Integer>> getBlocksToCompare(ArrayList<Integer> blockId) {
        int dim = blockId.size();
        if (dim == 0) {
            return new ArrayList<ArrayList<Integer>>();
        }
        ArrayList<ArrayList<Integer>> result = new ArrayList<ArrayList<Integer>>();
        ArrayList buffer = new ArrayList();
        result.add(blockId);
        ArrayList<Integer> minus = new ArrayList<Integer>();
        ArrayList<Integer> plus = new ArrayList<Integer>();
        ArrayList copy = new ArrayList();
        for (int i = 0; i < dim; ++i) {
            int j = 0;
            while ((double)j < Math.pow(3.0, i)) {
                ArrayList<Integer> id = result.get(j);
                minus = new ArrayList();
                plus = new ArrayList();
                for (int k = 0; k < dim; ++k) {
                    if (k != i) {
                        minus.add(id.get(k));
                        plus.add(id.get(k));
                        continue;
                    }
                    minus.add(id.get(k) - 1);
                    plus.add(id.get(k) + 1);
                }
                result.add(minus);
                result.add(plus);
                ++j;
            }
        }
        return result;
    }

    @Override
    public ArrayList<ArrayList<Integer>> getAllBlockIds(Instance a) {
        int i;
        ArrayList<ArrayList<Integer>> blockIds = new ArrayList<ArrayList<Integer>>();
        ArrayList<ArrayList<Double>> combinations = new ArrayList<ArrayList<Double>>();
        for (i = 0; i < this.dim; ++i) {
            combinations = EuclideanBlockingModule.addIdsToList(combinations, a.getProperty(this.properties.get(i)));
        }
        for (i = 0; i < combinations.size(); ++i) {
            ArrayList<Double> combination = combinations.get(i);
            ArrayList<Integer> block = new ArrayList<Integer>();
            for (int j = 0; j < combination.size(); ++j) {
                int blockId = (int)Math.floor(combination.get(j) / this.thresholds.get(j));
                block.add(blockId);
            }
            blockIds.add(block);
        }
        return blockIds;
    }

    @Override
    public ArrayList<ArrayList<Integer>> getAllSourceIds(Instance a, String sourceProps) {
        int i;
        String[] props = sourceProps.split("\\|");
        ArrayList<ArrayList<Integer>> blockIds = new ArrayList<ArrayList<Integer>>();
        ArrayList<ArrayList<Double>> combinations = new ArrayList<ArrayList<Double>>();
        for (i = 0; i < this.dim; ++i) {
            combinations = EuclideanBlockingModule.addIdsToList(combinations, a.getProperty(props[i]));
        }
        for (i = 0; i < combinations.size(); ++i) {
            ArrayList<Double> combination = combinations.get(i);
            ArrayList<Integer> block = new ArrayList<Integer>();
            for (int j = 0; j < combination.size(); ++j) {
                int blockId = (int)Math.floor(combination.get(j) / this.thresholds.get(j));
                block.add(blockId);
            }
            blockIds.add(block);
        }
        return blockIds;
    }

    public static ArrayList<Double> copyList(ArrayList<Double> list) {
        ArrayList<Double> copy = new ArrayList<Double>();
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                copy.add(list.get(i));
            }
        }
        return copy;
    }

    public static ArrayList<ArrayList<Double>> addIdsToList(ArrayList<ArrayList<Double>> keys, TreeSet<String> propValues) {
        ArrayList<ArrayList<Double>> result = new ArrayList<ArrayList<Double>>();
        ArrayList<Double> values = new ArrayList<Double>();
        for (String s : propValues) {
            System.out.println("----------------------------------------------------------------------S: " + s);
            values.add(Double.parseDouble(s));
        }
        if (keys.size() == 0) {
            for (int j = 0; j < values.size(); ++j) {
                ArrayList list = new ArrayList();
                list.add(values.get(j));
                result.add(list);
            }
        } else {
            for (int i = 0; i < keys.size(); ++i) {
                for (int j = 0; j < values.size(); ++j) {
                    ArrayList<Double> copy = EuclideanBlockingModule.copyList(keys.get(i));
                    copy.add((Double)values.get(j));
                    result.add(copy);
                }
            }
        }
        return result;
    }

    public static void main(String[] args) {
        MemoryCache cache = new MemoryCache();
        cache.addTriple("A", "lon", "1");
        cache.addTriple("A", "lat", "1");
        cache.addTriple("B", "lon", "2");
        cache.addTriple("B", "lat", "1");
        EuclideanBlockingModule blocker = new EuclideanBlockingModule("lon|lat", "euclidean", 0.25);
        System.out.println(blocker.getBlockId(cache.getInstance("A")));
        System.out.println(blocker.getBlockId(cache.getInstance("B")));
        ArrayList<Integer> blockId = new ArrayList<Integer>();
        ArrayList blockId2 = new ArrayList();
        blockId.add(0);
        blockId.add(0);
        System.out.println(new EuclideanBlockingModule("", "", 0.5).getBlocksToCompare(blockId));
        System.out.println(blockId.equals(blockId2));
    }
}

