/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.measures.space;

import de.uni_leipzig.simba.data.Instance;
import de.uni_leipzig.simba.measures.space.SpaceMeasure;

public class GeoDistance
implements SpaceMeasure {
    int dimension = 2;
    private static double D2R = Math.PI / 180;
    private static double radius = 6367.0;

    public void setDimension(int n) {
        this.dimension = n;
    }

    public double getThreshold(int dimension, double simThreshold) {
        return (1.0 - simThreshold) / (radius * simThreshold);
    }

    public double getSimilarity(Object a, Object b) {
        String[] p1 = ((String)a).split("\\|");
        String[] p2 = ((String)b).split("\\|");
        double lat1 = Double.parseDouble(p1[0]);
        double lon1 = Double.parseDouble(p1[1]);
        double lat2 = Double.parseDouble(p1[0]);
        double lon2 = Double.parseDouble(p2[1]);
        double value1 = Math.pow(Math.sin((lat1 - lat2) / 2.0), 2.0) + Math.cos(lat1 * D2R) * Math.cos(lat2 * D2R) * Math.pow(Math.sin((lon1 - lon2) / 2.0), 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(value1), Math.sqrt(1.0 - value1));
        double d = radius * c;
        return 1.0 / (1.0 + d);
    }

    public String getType() {
        return "spatial";
    }

    public double getSimilarity(Instance a, Instance b, String property1, String property2) {
        double lat2;
        double lon2;
        double lat1;
        double lon1;
        String[] p1 = property1.split("\\|");
        String[] p2 = property1.split("\\|");
        if (p1[0].toLowerCase().startsWith("lo")) {
            lon1 = Double.parseDouble(a.getProperty(p1[0]).first());
            lat1 = Double.parseDouble(a.getProperty(p1[1]).first());
        } else {
            lat1 = Double.parseDouble(a.getProperty(p1[0]).first());
            lon1 = Double.parseDouble(a.getProperty(p1[1]).first());
        }
        if (p2[0].toLowerCase().startsWith("lo")) {
            lon2 = Double.parseDouble(a.getProperty(p2[0]).first());
            lat2 = Double.parseDouble(a.getProperty(p2[1]).first());
        } else {
            lat2 = Double.parseDouble(a.getProperty(p2[0]).first());
            lon2 = Double.parseDouble(a.getProperty(p2[1]).first());
        }
        double value1 = Math.pow(Math.sin((lat1 - lat2) / 2.0), 2.0) + Math.cos(lat1 * D2R) * Math.cos(lat2 * D2R) * Math.pow(Math.sin((lon1 - lon2) / 2.0), 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(value1), Math.sqrt(1.0 - value1));
        double d = radius * c;
        return 1.0 / (1.0 + d);
    }

    public String getName() {
        return "geodistance";
    }

    public double getRuntimeApproximation(double mappingSize) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

