/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.measures.space;

import de.uni_leipzig.simba.data.Instance;
import de.uni_leipzig.simba.measures.space.SpaceMeasure;
import org.apache.log4j.Logger;

public class EuclideanMetric
implements SpaceMeasure {
    static Logger logger = Logger.getLogger((String)"LIMES");
    public double dim = 2.0;

    public void setDimension(int dimension) {
        this.dim = dimension;
    }

    public double getSimilarity(Object a, Object b) {
        String[] split1 = ((String)a).split("\\|");
        String[] split2 = ((String)b).split("\\|");
        double sim = 0.0;
        int i = 0;
        while ((double)i < this.dim) {
            double entry = new Double(split1[i]) - new Double(split2[i]);
            sim += entry * entry;
            ++i;
        }
        return 1.0 / (1.0 + Math.sqrt(sim));
    }

    public String getType() {
        return "spatial";
    }

    public double getSimilarity(Instance a, Instance b, String properties1, String properties2) {
        String[] p1 = properties1.split("\\|");
        String[] p2 = properties2.split("\\|");
        double sim = 0.0;
        for (int i = 0; i < p1.length; ++i) {
            double min = 2.147483647E9;
            for (String value1 : a.getProperty(p1[i])) {
                for (String value2 : b.getProperty(p2[i])) {
                    try {
                        double entry = new Double(value1) - new Double(value2);
                        if (!(min > (entry *= entry))) continue;
                        min = entry;
                    }
                    catch (Exception e) {}
                }
            }
            sim += min;
        }
        return 1.0 / (1.0 + Math.sqrt(sim));
    }

    public String getName() {
        return "euclidean";
    }

    public double getThreshold(int dimension, double simThreshold) {
        return (1.0 - simThreshold) / simThreshold;
    }

    public double getRuntimeApproximation(double mappingSize) {
        return mappingSize / 1000.0;
    }
}

