/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.measures;

import de.uni_leipzig.simba.cache.MemoryCache;
import de.uni_leipzig.simba.controller.Parser;
import de.uni_leipzig.simba.data.Instance;
import de.uni_leipzig.simba.measures.Measure;
import de.uni_leipzig.simba.measures.MeasureFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasureProcessor {
    static Logger logger = Logger.getLogger((String)"LIMES");

    public static List<String> getMeasures(String expression) {
        ArrayList<String> results = new ArrayList<String>();
        Parser p = new Parser(expression, 0.0);
        if (p.isAtomic()) {
            results.add(p.getOperation());
        } else {
            results.addAll(MeasureProcessor.getMeasures(p.getTerm1()));
            results.addAll(MeasureProcessor.getMeasures(p.getTerm2()));
        }
        return results;
    }

    public static double getSimilarity(Instance sourceInstance, Instance targetInstance, String expression, String sourceVar, String targetVar) {
        Parser p = new Parser(expression, 0.0);
        if (p.isAtomic()) {
            int i;
            String var;
            String[] split;
            Measure measure = MeasureFactory.getMeasure(p.getOperation());
            String property1 = null;
            String property2 = null;
            String term1 = "?" + p.getTerm1();
            String term2 = "?" + p.getTerm2();
            String property = "";
            if (term1.contains(".")) {
                split = term1.split("\\.");
                var = split[0];
                property = split[1];
                if (split.length >= 2) {
                    for (i = 2; i < split.length; ++i) {
                        property = property + "." + split[i];
                    }
                }
                if (var.equals(sourceVar)) {
                    property1 = property;
                } else {
                    property2 = property;
                }
            } else {
                property1 = term1;
            }
            if (term2.contains(".")) {
                split = term2.split("\\.");
                var = split[0];
                property = split[1];
                if (split.length >= 2) {
                    for (i = 2; i < split.length; ++i) {
                        property = property + "." + split[i];
                    }
                }
                if (var.equals(sourceVar)) {
                    property1 = property;
                } else {
                    property2 = property;
                }
            } else {
                property2 = term2;
            }
            if (property1 != null && property2 != null) {
                return measure.getSimilarity(sourceInstance, targetInstance, property1, property2);
            }
        } else {
            if (p.op.equalsIgnoreCase("MAX") | p.op.equalsIgnoreCase("OR") | p.op.equalsIgnoreCase("XOR")) {
                return Math.max(MeasureProcessor.getSimilarity(sourceInstance, targetInstance, p.getTerm1(), sourceVar, targetVar), MeasureProcessor.getSimilarity(sourceInstance, targetInstance, p.getTerm2(), sourceVar, targetVar));
            }
            if (p.op.equalsIgnoreCase("MIN") | p.op.equalsIgnoreCase("AND")) {
                return Math.min(MeasureProcessor.getSimilarity(sourceInstance, targetInstance, p.getTerm1(), sourceVar, targetVar), MeasureProcessor.getSimilarity(sourceInstance, targetInstance, p.getTerm2(), sourceVar, targetVar));
            }
            if (p.op.equalsIgnoreCase("ADD")) {
                return p.coef1 * MeasureProcessor.getSimilarity(sourceInstance, targetInstance, p.getTerm1(), sourceVar, targetVar) + p.coef2 * MeasureProcessor.getSimilarity(sourceInstance, targetInstance, p.getTerm2(), sourceVar, targetVar);
            }
            logger.warn((Object)("Not sure what to do with operator " + p.op + ". Using MAX."));
            return Math.max(MeasureProcessor.getSimilarity(sourceInstance, targetInstance, p.getTerm1(), sourceVar, targetVar), MeasureProcessor.getSimilarity(sourceInstance, targetInstance, p.getTerm2(), sourceVar, targetVar));
        }
        logger.fatal((Object)"Property values could not be read. Exiting");
        return 0.0;
    }

    public static void main(String[] args) {
        MemoryCache source = new MemoryCache();
        MemoryCache target = new MemoryCache();
        source.addTriple("S1", "pub", "test");
        source.addTriple("S1", "conf", "conf one");
        source.addTriple("S2", "pub", "test2");
        source.addTriple("S2", "conf", "conf2");
        target.addTriple("S1", "pub", "test");
        target.addTriple("S1", "conf", "conf one");
        target.addTriple("S3", "pub", "test1");
        target.addTriple("S3", "conf", "conf three");
        System.out.println(MeasureProcessor.getSimilarity(source.getInstance("S1"), target.getInstance("S3"), "ADD(0.5*trigram(x.conf, y.conf),0.5*cosine(y.conf, x.conf))", "?x", "?y"));
        System.out.println(MeasureProcessor.getMeasures("AND(jaccard(x.authors,y.authors)|0.4278,overlap(x.authors,y.authors)|0.4278)"));
        System.out.println(MeasureProcessor.getMeasures("trigrams(x.conf, y.conf)"));
    }

    public static double getCosts(String measureExpression, double mappingSize) {
        List<String> measures = MeasureProcessor.getMeasures(measureExpression);
        double runtime = 0.0;
        for (int i = 0; i < measures.size(); ++i) {
            runtime += MeasureFactory.getMeasure(measures.get(i)).getRuntimeApproximation(mappingSize);
        }
        return runtime;
    }
}

