/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.measures;

import de.uni_leipzig.simba.mapper.AtomicMapper;
import de.uni_leipzig.simba.mapper.atomic.EDJoin;
import de.uni_leipzig.simba.mapper.atomic.ExactMatchMapper;
import de.uni_leipzig.simba.mapper.atomic.PPJoinPlusPlus;
import de.uni_leipzig.simba.mapper.atomic.TotalOrderBlockingMapper;
import de.uni_leipzig.simba.mapper.atomic.fastngram.FastNGram;
import de.uni_leipzig.simba.measures.Measure;
import de.uni_leipzig.simba.measures.space.EuclideanMetric;
import de.uni_leipzig.simba.measures.space.GeoDistance;
import de.uni_leipzig.simba.measures.string.CosineMeasure;
import de.uni_leipzig.simba.measures.string.ExactMatch;
import de.uni_leipzig.simba.measures.string.JaccardMeasure;
import de.uni_leipzig.simba.measures.string.Levenshtein;
import de.uni_leipzig.simba.measures.string.QGramSimilarity;
import de.uni_leipzig.simba.measures.string.TrigramMeasure;
import org.apache.log4j.Logger;

public class MeasureFactory {
    static Logger logger = Logger.getLogger((String)"LIMES");

    public static Measure getMeasure(String name) {
        if (name.toLowerCase().startsWith("cosine")) {
            return new CosineMeasure();
        }
        if (name.toLowerCase().startsWith("jaccard")) {
            return new JaccardMeasure();
        }
        if (name.toLowerCase().startsWith("euclidean")) {
            return new EuclideanMetric();
        }
        if (name.toLowerCase().startsWith("levens")) {
            return new Levenshtein();
        }
        if (name.toLowerCase().startsWith("qgrams")) {
            return new QGramSimilarity();
        }
        if (name.toLowerCase().startsWith("exactmatch")) {
            return new ExactMatch();
        }
        return new TrigramMeasure();
    }

    public static Measure getMeasure(String name, String type) {
        if (type.equals("string")) {
            if (name.toLowerCase().startsWith("cosine")) {
                return new CosineMeasure();
            }
            if (name.toLowerCase().startsWith("jaccard")) {
                return new JaccardMeasure();
            }
            return new TrigramMeasure();
        }
        if (type.equals("spatial")) {
            if (name.toLowerCase().startsWith("geo")) {
                return new GeoDistance();
            }
            if (name.toLowerCase().startsWith("euclidean")) {
                return new EuclideanMetric();
            }
            return new EuclideanMetric();
        }
        return new TrigramMeasure();
    }

    public static AtomicMapper getMapper(String measure) {
        if (measure.toLowerCase().startsWith("leven")) {
            return new EDJoin();
        }
        if (measure.toLowerCase().startsWith("qgrams")) {
            return new FastNGram();
        }
        if (measure.toLowerCase().startsWith("trigrams")) {
            return new PPJoinPlusPlus();
        }
        if (measure.toLowerCase().startsWith("exactmatch")) {
            return new ExactMatchMapper();
        }
        if (measure.toLowerCase().startsWith("euclid")) {
            return new TotalOrderBlockingMapper();
        }
        if (measure.toLowerCase().startsWith("jaccard")) {
            return new PPJoinPlusPlus();
        }
        logger.warn((Object)("Could not find mapper for " + measure + ". Using default mapper."));
        return new PPJoinPlusPlus();
    }
}

