/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.mapper.atomic.fastngram;

import de.uni_leipzig.simba.mapper.atomic.fastngram.NGramTokenizer;
import de.uni_leipzig.simba.mapper.atomic.fastngram.Tokenizer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Index {
    private Map<Integer, Map<String, Set<String>>> sizeTokenIndex = new HashMap<Integer, Map<String, Set<String>>>();
    private Tokenizer tokenizer = new NGramTokenizer();
    private int q = 3;

    public Index() {
    }

    public Index(int _q) {
        this.q = _q;
    }

    public Set<String> addString(String s) {
        Set<String> tokens = this.tokenizer.tokenize(s, this.q);
        int size = tokens.size();
        if (!this.sizeTokenIndex.containsKey(size)) {
            this.sizeTokenIndex.put(size, new HashMap());
        }
        Map<String, Set<String>> tokenIndex = this.sizeTokenIndex.get(size);
        for (String token : tokens) {
            if (!tokenIndex.containsKey(token)) {
                tokenIndex.put(token, new HashSet());
            }
            tokenIndex.get(token).add(s);
        }
        return tokens;
    }

    public Set<String> getStrings(int size, String token) {
        if (this.sizeTokenIndex.containsKey(size)) {
            if (this.sizeTokenIndex.get(size).containsKey(token)) {
                return this.sizeTokenIndex.get(size).get(token);
            }
            return new HashSet<String>();
        }
        return new HashSet<String>();
    }

    public Map<String, Set<String>> getStrings(int size) {
        if (this.sizeTokenIndex.containsKey(size)) {
            return this.sizeTokenIndex.get(size);
        }
        return new HashMap<String, Set<String>>();
    }

    public Set<Integer> getAllSizes() {
        return this.sizeTokenIndex.keySet();
    }
}

