/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.mapper.atomic.fastngram;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.controller.Parser;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.mapper.AtomicMapper;
import de.uni_leipzig.simba.mapper.atomic.fastngram.Index;
import de.uni_leipzig.simba.mapper.atomic.fastngram.NGramTokenizer;
import de.uni_leipzig.simba.measures.string.QGramSimilarity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastNGram
implements AtomicMapper {
    static Logger logger = Logger.getLogger((String)"LIMES");
    static int q = 3;

    @Override
    public String getName() {
        return "FastNGram";
    }

    public static Mapping compute(Set<String> source, Set<String> target, int q, double threshold) {
        Index index = new Index(q);
        double kappa = (1.0 + threshold) / threshold;
        QGramSimilarity sim = new QGramSimilarity(q);
        NGramTokenizer tokenizer = new NGramTokenizer();
        HashMap<String, Set<String>> targetTokens = new HashMap<String, Set<String>>();
        Mapping result = new Mapping();
        for (String t : target) {
            targetTokens.put(t, index.addString(t));
        }
        for (String s : source) {
            Set<Integer> allSizes = index.getAllSizes();
            Set<String> sourceTokens = tokenizer.tokenize(s, q);
            double sourceSize = sourceTokens.size();
            for (int size = (int)Math.ceil(sourceSize * threshold); size <= (int)Math.floor(sourceSize / threshold); ++size) {
                if (!allSizes.contains(size)) continue;
                Map<String, Set<String>> stringsOfSize = index.getStrings(size);
                HashMap<String, Integer> countMap = new HashMap<String, Integer>();
                for (String token : sourceTokens) {
                    if (!stringsOfSize.containsKey(token)) continue;
                    Set<String> candidates = stringsOfSize.get(token);
                    for (String candidate : candidates) {
                        if (!countMap.containsKey(candidate)) {
                            countMap.put(candidate, 0);
                        }
                        countMap.put(candidate, (Integer)countMap.get(candidate) + 1);
                    }
                }
                for (String candidate : countMap.keySet()) {
                    double similarity;
                    double count = ((Integer)countMap.get(candidate)).intValue();
                    if (!(kappa * count >= sourceSize + (double)size) || !((similarity = sim.getSimilarity((Set)targetTokens.get(candidate), sourceTokens)) >= threshold)) continue;
                    result.add(s, candidate, similarity);
                }
            }
        }
        return result;
    }

    @Override
    public Mapping getMapping(Cache source, Cache target, String sourceVar, String targetVar, String expression, double threshold) {
        TreeSet<String> values;
        int i;
        String var;
        String[] split;
        Mapping mapping = new Mapping();
        if (threshold <= 0.0) {
            logger.warn((Object)"Wrong threshold setting. Returning empty mapping.");
            return mapping;
        }
        String property1 = null;
        String property2 = null;
        Parser p = new Parser(expression, threshold);
        String term1 = "?" + p.getTerm1();
        String term2 = "?" + p.getTerm2();
        String property = "";
        if (term1.contains(".")) {
            split = term1.split("\\.");
            var = split[0];
            property = split[1];
            if (split.length >= 2) {
                for (i = 2; i < split.length; ++i) {
                    property = property + "." + split[i];
                }
            }
            if (var.equals(sourceVar)) {
                property1 = property;
            } else {
                property2 = property;
            }
        } else {
            property1 = term1;
        }
        if (term2.contains(".")) {
            split = term2.split("\\.");
            var = split[0];
            property = split[1];
            if (split.length >= 2) {
                for (i = 2; i < split.length; ++i) {
                    property = property + "." + split[i];
                }
            }
            if (var.equals(sourceVar)) {
                property1 = property;
            } else {
                property2 = property;
            }
        } else {
            property2 = term2;
        }
        if (property1 == null || property2 == null) {
            logger.fatal((Object)("Property 1 = " + property1 + ", Property 2 = " + property2));
            logger.fatal((Object)"Property values could not be read. Exiting");
            System.exit(1);
        }
        if (!p.isAtomic()) {
            logger.fatal((Object)"Mappers can only deal with atomic expression");
            logger.fatal((Object)("Expression " + expression + " was given to a mapper to process"));
            System.exit(1);
        }
        HashMap sourceMap = new HashMap();
        ArrayList<String> sourceUris = source.getAllUris();
        HashMap targetMap = new HashMap();
        ArrayList<String> targetUris = target.getAllUris();
        for (String s : sourceUris) {
            values = source.getInstance(s).getProperty(property1);
            for (String v : values) {
                if (!sourceMap.containsKey(v)) {
                    sourceMap.put(v, new HashSet());
                }
                ((Set)sourceMap.get(v)).add(s);
            }
        }
        for (String t : targetUris) {
            values = target.getInstance(t).getProperty(property2);
            for (String v : values) {
                if (!targetMap.containsKey(v)) {
                    targetMap.put(v, new HashSet());
                }
                ((Set)targetMap.get(v)).add(t);
            }
        }
        Mapping m = FastNGram.compute(sourceMap.keySet(), targetMap.keySet(), q, threshold);
        Mapping result = new Mapping();
        for (String s : m.map.keySet()) {
            for (String t : m.map.get(s).keySet()) {
                for (String sourceUri : (Set)sourceMap.get(s)) {
                    for (String targetUri : (Set)targetMap.get(t)) {
                        result.add(sourceUri, targetUri, m.getSimilarity(s, t));
                    }
                }
            }
        }
        return result;
    }

    @Override
    public double getRuntimeApproximation(int sourceSize, int targetSize, double threshold, AtomicMapper.Language language) {
        if (language.equals((Object)AtomicMapper.Language.DE)) {
            return 492.9 + 0.09 * (double)sourceSize + 0.09 * (double)targetSize - 1032.3 * threshold;
        }
        return 59.82 + 0.01 * (double)sourceSize + 0.01 * (double)targetSize - 114.2 * threshold;
    }

    @Override
    public double getMappingSizeApproximation(int sourceSize, int targetSize, double threshold, AtomicMapper.Language language) {
        if (language.equals((Object)AtomicMapper.Language.DE)) {
            return 727.2 + 0.063 * (double)sourceSize + 0.063 * (double)targetSize - 1305.1 * threshold;
        }
        return 8.2 + 0.001 * (double)sourceSize + 0.001 * (double)targetSize - 16.75 * threshold;
    }
}

