/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.mapper.atomic;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.controller.Parser;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.mapper.AtomicMapper;
import de.uni_leipzig.simba.metricfactory.SimpleMetricFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TotalOrderMapper
implements AtomicMapper {
    @Override
    public String getName() {
        return "TotalOrderMapper";
    }

    @Override
    public Mapping getMapping(Cache source, Cache target, String sourceVar, String targetVar, String expression, double threshold) {
        Mapping mapping = new Mapping();
        ArrayList<Double> valueList = new ArrayList<Double>();
        Parser p = new Parser(expression, threshold);
        String term1 = p.getTerm1();
        String property1 = term1.contains(".") ? term1.split("\\.")[1] : term1;
        String term2 = p.getTerm2();
        String property2 = term2.contains(".") ? term2.split("\\.")[1] : term2;
        HashMap<Double, String> valueToUri = new HashMap<Double, String>();
        for (String key : target.getAllUris()) {
            for (String value : target.getInstance(key).getProperty(property2)) {
                valueToUri.put(new Double(value), key);
                valueList.add(new Double(value));
            }
        }
        SimpleMetricFactory factory = new SimpleMetricFactory("", "");
        factory.setExpression(expression);
        Comparator comparator = Collections.reverseOrder();
        Collections.sort(valueList, comparator);
        for (String key : source.getAllUris()) {
            for (String value : source.getInstance(key).getProperty(property1)) {
                int index;
                int i;
                for (i = index = TotalOrderMapper.binarySearch(valueList, new Double(value)); i >= 0; --i) {
                    StringBuilder stringBuilder = new StringBuilder();
                    if (!((double)factory.getSimilarity(key, stringBuilder.append(valueList.get(i)).append("").toString()) >= threshold)) continue;
                }
                for (i = index + 1; i < valueList.size(); ++i) {
                }
            }
        }
        return new Mapping();
    }

    public static int binarySearch(ArrayList<Double> a, Double x) {
        int low = 0;
        int high = a.size() - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            if (a.get(mid).compareTo(x) < 0) {
                low = mid + 1;
                continue;
            }
            if (a.get(mid).compareTo(x) > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return low;
    }

    @Override
    public double getRuntimeApproximation(int sourceSize, int targetSize, double threshold, AtomicMapper.Language language) {
        if (language.equals((Object)AtomicMapper.Language.DE)) {
            return 16.27 + 5.1 * (double)sourceSize + 4.9 * (double)targetSize - 23.44 * threshold;
        }
        return 0.62 + 0.001 * (double)sourceSize + 0.001 * (double)targetSize - 0.53 * threshold;
    }

    @Override
    public double getMappingSizeApproximation(int sourceSize, int targetSize, double threshold, AtomicMapper.Language language) {
        if (language.equals((Object)AtomicMapper.Language.DE)) {
            return 2333.0 + 0.14 * (double)sourceSize + 0.14 * (double)targetSize - 3905.0 * threshold;
        }
        return -1.84 + 6.0E-4 * (double)sourceSize + 6.0E-4 * (double)targetSize;
    }

    public double getSelectivity(int sourceSize, int targetSize, double threshold, AtomicMapper.Language language) {
        return this.getMappingSizeApproximation(sourceSize, targetSize, threshold, language) / (double)(sourceSize * targetSize);
    }
}

