/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.mapper.atomic;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.cache.MemoryCache;
import de.uni_leipzig.simba.controller.Parser;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.mapper.AtomicMapper;
import de.uni_leipzig.simba.measures.space.SpaceMeasure;
import de.uni_leipzig.simba.measures.space.SpaceMeasureFactory;
import de.uni_leipzig.simba.measures.space.blocking.BlockingFactory;
import de.uni_leipzig.simba.measures.space.blocking.BlockingModule;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;

public class TotalOrderBlockingMapper
implements AtomicMapper {
    public int granularity = 4;
    static Logger logger = Logger.getLogger((String)"LIMES");

    public String getName() {
        return "TotalOrderBlockingMapper";
    }

    public Mapping getMapping(Cache source, Cache target, String sourceVar, String targetVar, String expression, double threshold) {
        ArrayList<ArrayList<Integer>> blockIds;
        String property2;
        String term2;
        String property1;
        Mapping mapping = new Mapping();
        HashMap targetBlocks = new HashMap();
        Parser p = new Parser(expression, threshold);
        String term1 = p.getTerm1();
        if (term1.contains(".")) {
            String[] split = term1.split("\\.");
            property1 = split[1];
            if (split.length >= 2) {
                for (int part = 2; part < split.length; ++part) {
                    property1 = property1 + "." + split[part];
                }
            }
        } else {
            property1 = term1;
        }
        if ((term2 = p.getTerm2()).contains(".")) {
            String[] split = term2.split("\\.");
            property2 = split[1];
            if (split.length >= 2) {
                for (int part = 2; part < split.length; ++part) {
                    property2 = property2 + "." + split[part];
                }
            }
        } else {
            property2 = term2;
        }
        int dimensions = property2.split("\\|").length;
        BlockingModule generator = BlockingFactory.getBlockingModule(property2, p.op, threshold, this.granularity);
        SpaceMeasure measure = SpaceMeasureFactory.getMeasure(p.op, dimensions);
        for (String key : target.getAllUris()) {
            blockIds = generator.getAllBlockIds(target.getInstance(key));
            for (int ids = 0; ids < blockIds.size(); ++ids) {
                if (!targetBlocks.containsKey(blockIds.get(ids))) {
                    targetBlocks.put(blockIds.get(ids), new TreeSet());
                }
                ((TreeSet)targetBlocks.get(blockIds.get(ids))).add(key);
            }
        }
        int comparisons = 0;
        int necessaryComparisons = 0;
        int counter = 0;
        int size = source.getAllUris().size();
        for (String sourceInstanceUri : source.getAllUris()) {
            if (++counter % 1000 == 0) {
                // empty if block
            }
            blockIds = generator.getAllSourceIds(source.getInstance(sourceInstanceUri), property1);
            for (int ids = 0; ids < blockIds.size(); ++ids) {
                ArrayList<ArrayList<Integer>> blocksToCompare = generator.getBlocksToCompare(blockIds.get(ids));
                for (int index = 0; index < blocksToCompare.size(); ++index) {
                    if (!targetBlocks.containsKey(blocksToCompare.get(index))) continue;
                    TreeSet uris = (TreeSet)targetBlocks.get(blocksToCompare.get(index));
                    for (String targetInstanceUri : uris) {
                        double sim = measure.getSimilarity(source.getInstance(sourceInstanceUri), target.getInstance(targetInstanceUri), property1, property2);
                        ++comparisons;
                        if (!(sim >= threshold)) continue;
                        mapping.add(sourceInstanceUri, targetInstanceUri, sim);
                        ++necessaryComparisons;
                    }
                }
            }
        }
        return mapping;
    }

    public static void main(String[] args) {
        MemoryCache source = new MemoryCache();
        MemoryCache target = new MemoryCache();
        target.addTriple("0", "lat", "0");
        target.addTriple("0", "lon", "0");
        target.addTriple("1", "lat", "4");
        target.addTriple("1", "lon", "4");
        target.addTriple("2", "lat", "4");
        target.addTriple("2", "lon", "3");
        target.addTriple("3", "lat", "3");
        target.addTriple("3", "lon", "4");
        source.addTriple("4", "lat", "2");
        source.addTriple("4", "lon", "2");
        source.addTriple("5", "lat", "5");
        source.addTriple("5", "lon", "2");
        TotalOrderBlockingMapper bm = new TotalOrderBlockingMapper();
    }

    public double getRuntimeApproximation(int sourceSize, int targetSize, double threshold, AtomicMapper.Language language) {
        if (language.equals((Object)AtomicMapper.Language.DE)) {
            return 16.27 + 5.1 * (double)sourceSize + 4.9 * (double)targetSize - 23.44 * threshold;
        }
        return 200.0 + 0.005 * (double)(sourceSize + targetSize) - 56.4 * threshold;
    }

    public double getMappingSizeApproximation(int sourceSize, int targetSize, double threshold, AtomicMapper.Language language) {
        if (language.equals((Object)AtomicMapper.Language.DE)) {
            return 2333.0 + 0.14 * (double)sourceSize + 0.14 * (double)targetSize - 3905.0 * threshold;
        }
        return 0.006 * (double)(sourceSize + targetSize) - 134.2 * threshold;
    }
}

