/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.mapper.atomic;

import algorithms.StoppUhr;
import algorithms.Token;
import algorithms.ppjoinplus.Record;
import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.controller.Parser;
import de.uni_leipzig.simba.data.Instance;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.mapper.AtomicMapper;
import de.uni_leipzig.simba.mapper.atomic.CandidateInfo;
import de.uni_leipzig.simba.mapper.atomic.PartitionResult;
import de.uni_leipzig.simba.mapper.atomic.Position;
import de.uni_leipzig.simba.measures.MeasureFactory;
import de.uni_leipzig.simba.measures.string.StringMeasure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PPJoinPlusPlus
implements AtomicMapper {
    static Logger logger = Logger.getLogger((String)"LIMES");
    private static int MAX_DEPTH;
    private static Mapping mapping;
    private static HashMap<Integer, String> sourceMap;
    private static HashMap<Integer, String> targetMap;
    private StringMeasure measure;
    private int comparisons = 0;

    @Override
    public String getName() {
        return "PPJoinPlusPlus";
    }

    @Override
    public Mapping getMapping(Cache source, Cache target, String sourceVar, String targetVar, String expression, double threshold) {
        Instance instance;
        int i;
        int i2;
        String var;
        String[] split;
        this.comparisons = 0;
        MAX_DEPTH = 2;
        mapping = new Mapping();
        int candidatesCount = 0;
        if (threshold <= 0.0) {
            return mapping;
        }
        String property1 = null;
        String property2 = null;
        Parser p = new Parser(expression, threshold);
        String term1 = "?" + p.getTerm1();
        String term2 = "?" + p.getTerm2();
        String property = "";
        if (term1.contains(".")) {
            split = term1.split("\\.");
            var = split[0];
            property = split[1];
            if (split.length >= 2) {
                for (i2 = 2; i2 < split.length; ++i2) {
                    property = property + "." + split[i2];
                }
            }
            if (var.equals(sourceVar)) {
                property1 = property;
            } else {
                property2 = property;
            }
        } else {
            property1 = term1;
        }
        if (term2.contains(".")) {
            split = term2.split("\\.");
            var = split[0];
            property = split[1];
            if (split.length >= 2) {
                for (i2 = 2; i2 < split.length; ++i2) {
                    property = property + "." + split[i2];
                }
            }
            if (var.equals(sourceVar)) {
                property1 = property;
            } else {
                property2 = property;
            }
        } else {
            property2 = term2;
        }
        if (property1 == null || property2 == null) {
            logger.fatal((Object)("Property 1 = " + property1 + ", Property 2 = " + property2));
            logger.fatal((Object)"Property values could not be read. Exiting");
        }
        if (!p.isAtomic()) {
            logger.fatal((Object)"Mappers can only deal with atomic expression");
            logger.fatal((Object)("Expression " + expression + " was given to a mapper to process"));
        }
        sourceMap = new HashMap();
        ArrayList<String> uris = source.getAllUris();
        ArrayList<String> entries = new ArrayList<String>();
        int counter = 0;
        int border = 0;
        for (i = 0; i < uris.size(); ++i) {
            instance = source.getInstance(uris.get(i));
            for (String s : instance.getProperty(property1)) {
                sourceMap.put(counter, uris.get(i));
                entries.add(s);
                ++counter;
            }
        }
        targetMap = new HashMap();
        border = counter - 1;
        uris = target.getAllUris();
        for (i = 0; i < uris.size(); ++i) {
            instance = target.getInstance(uris.get(i));
            for (String s : instance.getProperty(property2)) {
                targetMap.put(counter, uris.get(i));
                entries.add(s);
                ++counter;
            }
        }
        String[] entryArray = new String[entries.size()];
        for (int i3 = 0; i3 < entries.size(); ++i3) {
            entryArray[i3] = (String)entries.get(i3);
        }
        Record[] records = PPJoinPlusPlus.tokenizer(entryArray);
        HashMap index = new HashMap();
        boolean k = threshold != 0.0;
        this.measure = (StringMeasure)MeasureFactory.getMeasure(p.op, "string");
        if (this.measure == null) {
            logger.fatal((Object)"Metric is null. Exiting.");
            System.exit(1);
        }
        for (int i4 = 0; i4 < records.length; ++i4) {
            HashMap<Record, CandidateInfo> candidates = new HashMap<Record, CandidateInfo>();
            Record currentRec = records[i4];
            int tokensNumber = currentRec.tokens.length;
            currentRec.prefixLength = this.measure.getPrefixLength(tokensNumber, threshold);
            currentRec.midPrefix = this.measure.getMidLength(tokensNumber, threshold);
            for (int j = 0; j < currentRec.tokens.length && j < currentRec.prefixLength; ++j) {
                Integer tokenID = currentRec.tokens[j].id;
                LinkedList l = (LinkedList)index.get(tokenID);
                if (l != null) {
                    Iterator iter = l.iterator();
                    while (iter.hasNext()) {
                        Position pos = (Position)iter.next();
                        int tokensNumber2 = pos.record.tokens.length;
                        double sizeFilteringThreshold = this.measure.getSizeFilteringThreshold(tokensNumber, threshold);
                        if ((double)tokensNumber2 >= sizeFilteringThreshold) {
                            int H;
                            int H_max;
                            int alpha = this.measure.getAlpha(tokensNumber, tokensNumber2, threshold);
                            int ubound = 1 + Math.min(tokensNumber - j - 1, tokensNumber2 - pos.position - 1);
                            CandidateInfo cf = candidates.get(pos.record);
                            if (cf == null) {
                                if (ubound < alpha) continue;
                                H_max = tokensNumber + tokensNumber2 - 2 * alpha - j - pos.position;
                                H = PPJoinPlusPlus.suffixFilter(currentRec, j + 1, currentRec.tokens.length - 1, pos.record, pos.position + 1, pos.record.tokens.length - 1, H_max, 1);
                                if (H <= H_max) {
                                    candidates.put(pos.record, new CandidateInfo(1, alpha));
                                    continue;
                                }
                                candidates.put(pos.record, new CandidateInfo(Integer.MIN_VALUE, alpha));
                                continue;
                            }
                            if (cf.currentOverlap + ubound >= alpha) {
                                if (cf.currentOverlap == 0) {
                                    H_max = tokensNumber + tokensNumber2 - 2 * alpha - j - pos.position;
                                    H = PPJoinPlusPlus.suffixFilter(currentRec, j + 1, currentRec.tokens.length - 1, pos.record, pos.position + 1, pos.record.tokens.length - 1, H_max, 1);
                                    if (H <= H_max) {
                                        ++cf.currentOverlap;
                                        continue;
                                    }
                                    cf.currentOverlap = Integer.MIN_VALUE;
                                    continue;
                                }
                                ++cf.currentOverlap;
                                continue;
                            }
                            cf.currentOverlap = 0;
                            continue;
                        }
                        iter.remove();
                    }
                    if (j >= currentRec.midPrefix) continue;
                    l.add(new Position(currentRec, j));
                    continue;
                }
                if (j >= currentRec.midPrefix) continue;
                LinkedList<Position> temp = new LinkedList<Position>();
                temp.add(new Position(currentRec, j));
                index.put(tokenID, temp);
            }
            candidatesCount += this.verification(currentRec, candidates);
        }
        return mapping;
    }

    private int verification(Record currentRec, HashMap<Record, CandidateInfo> candidates) {
        int count = 0;
        for (Map.Entry<Record, CandidateInfo> e : candidates.entrySet()) {
            String id2;
            String id1;
            int ubound;
            CandidateInfo value = e.getValue();
            if (value.currentOverlap <= 0) continue;
            Record key = e.getKey();
            int overlap = value.currentOverlap;
            Token wx = currentRec.tokens[currentRec.prefixLength - 1];
            Token wy = key.tokens[key.midPrefix - 1];
            int compRes = wx.compareTo(wy);
            if (compRes < 0) {
                ubound = value.currentOverlap + currentRec.tokens.length - currentRec.prefixLength;
                if (ubound >= value.alpha) {
                    overlap += PPJoinPlusPlus.overlap(currentRec, currentRec.prefixLength, key, value.currentOverlap);
                }
            } else if (compRes > 0) {
                ubound = value.currentOverlap + key.tokens.length - key.midPrefix;
                if (ubound >= value.alpha) {
                    overlap += PPJoinPlusPlus.overlap(currentRec, value.currentOverlap, key, key.midPrefix);
                }
            } else {
                ubound = value.currentOverlap + Math.min(currentRec.tokens.length - currentRec.prefixLength, key.tokens.length - key.midPrefix);
                if (ubound >= value.alpha) {
                    overlap += PPJoinPlusPlus.overlap(currentRec, currentRec.prefixLength, key, key.midPrefix);
                }
            }
            if (overlap < value.alpha) continue;
            double similarity = this.measure.getSimilarity(overlap, currentRec.tokens.length, key.tokens.length);
            ++this.comparisons;
            if (sourceMap.containsKey(currentRec.id) && targetMap.containsKey(key.id)) {
                id1 = sourceMap.get(currentRec.id);
                id2 = targetMap.get(key.id);
                mapping.add(id1, id2, similarity);
                continue;
            }
            if (!targetMap.containsKey(currentRec.id) || !sourceMap.containsKey(key.id)) continue;
            id1 = sourceMap.get(key.id);
            id2 = targetMap.get(currentRec.id);
            mapping.add(id1, id2, similarity);
            ++count;
        }
        return count;
    }

    public static int overlap(Record x, int beginnX, Record y, int beginnY) {
        int overlap = 0;
        block0: for (int i = beginnX; i < x.tokens.length; ++i) {
            for (int j = beginnY; j < y.tokens.length; ++j) {
                if (x.tokens[i].id != y.tokens[j].id) continue;
                ++overlap;
                beginnY = j + 1;
                continue block0;
            }
        }
        return overlap;
    }

    private static int suffixFilter(Record x, int xBeginn, int xEnd, Record y, int yBeginn, int yEnd, int H_max, int depth) {
        int xSize = xEnd - xBeginn + 1;
        int ySize = yEnd - yBeginn + 1;
        if (depth > MAX_DEPTH) {
            return Math.abs(xSize - ySize);
        }
        if (ySize <= 0 || xSize <= 0) {
            return Math.max(Math.max(ySize, xSize), 0);
        }
        int mid = yBeginn + (int)Math.ceil(1.0 * (double)ySize / 2.0) - 1;
        Token w = y.tokens[mid];
        PartitionResult pr = PPJoinPlusPlus.partition(x, w, xBeginn, xEnd);
        int xlSize = pr.l - xBeginn + 1;
        int xrSize = xEnd - pr.r + 1;
        int ylSize = mid - yBeginn;
        int yrSize = yEnd - mid;
        int H = Math.abs(xlSize - ylSize) + Math.abs(xrSize - yrSize) + pr.diff;
        if (H > H_max) {
            return H;
        }
        int Hl = PPJoinPlusPlus.suffixFilter(x, xBeginn, pr.l, y, yBeginn, mid - 1, H_max - Math.abs(xrSize - yrSize) - pr.diff, depth + 1);
        H = Hl + Math.abs(xrSize - yrSize) + pr.diff;
        if (H <= H_max) {
            int Hr = PPJoinPlusPlus.suffixFilter(x, pr.r, xEnd, y, mid + 1, yEnd, H_max - Hl - pr.diff, depth + 1);
            return Hl + Hr + pr.diff;
        }
        return H;
    }

    private static PartitionResult partition(Record s, Token w, int l, int r) {
        if (s.tokens[l].compareTo(w) > 0) {
            return new PartitionResult(l - 1, l, 1, 1);
        }
        if (s.tokens[r].compareTo(w) < 0) {
            return new PartitionResult(r, r + 1, 1, 1);
        }
        int p = PPJoinPlusPlus.binarySearch(s, l, r, w);
        if (s.tokens[p].compareTo(w) == 0) {
            return new PartitionResult(p - 1, p + 1, 1, 0);
        }
        return new PartitionResult(p - 1, p, 1, 1);
    }

    private static int binarySearch(Record x, int l, int r, Token w) {
        int p = (l + r) / 2;
        int c = x.tokens[p].compareTo(w);
        if (c == 0) {
            return p;
        }
        if (l == r) {
            if (c < 0) {
                return p + 1;
            }
            return p;
        }
        if (c < 0) {
            if (p < r) {
                return PPJoinPlusPlus.binarySearch(x, p + 1, r, w);
            }
            return p + 1;
        }
        if (p > l) {
            return PPJoinPlusPlus.binarySearch(x, l, p - 1, w);
        }
        return p;
    }

    private static Record[] tokenizer(String[] objects) {
        int i;
        StoppUhr s = new StoppUhr();
        s.Starten();
        HashMap<String, Token> allTokens = new HashMap<String, Token>();
        Object[] records = new Record[objects.length];
        for (i = 0; i < objects.length; ++i) {
            StringTokenizer st = new StringTokenizer(objects[i], " .,?!\t");
            int tokensNumber = st.countTokens();
            Record record = new Record(i, tokensNumber);
            HashMap<String, Integer> recordTokens = new HashMap<String, Integer>();
            for (int j = 0; j < tokensNumber; ++j) {
                Token t;
                String token = st.nextToken();
                if (recordTokens.containsKey(token)) {
                    Token t2;
                    Integer token_freq = (Integer)recordTokens.get(token) + 1;
                    recordTokens.put(token, token_freq);
                    if (allTokens.containsKey(token + "." + token_freq)) {
                        t2 = (Token)allTokens.get(token + "." + token_freq);
                        ++t2.df;
                        record.tokens[j] = t2;
                        continue;
                    }
                    t2 = new Token(allTokens.size(), 1);
                    allTokens.put(token + "." + token_freq, t2);
                    record.tokens[j] = t2;
                    continue;
                }
                if (allTokens.containsKey(token)) {
                    t = (Token)allTokens.get(token);
                    ++t.df;
                    recordTokens.put(token, new Integer(1));
                    record.tokens[j] = t;
                    continue;
                }
                t = new Token(allTokens.size(), 1);
                allTokens.put(token, t);
                recordTokens.put(token, new Integer(1));
                record.tokens[j] = t;
            }
            records[i] = record;
        }
        for (i = 0; i < records.length; ++i) {
            Arrays.sort(((Record)records[i]).tokens);
        }
        Arrays.sort(records);
        s.Stoppen();
        return records;
    }

    @Override
    public double getRuntimeApproximation(int sourceSize, int targetSize, double threshold, AtomicMapper.Language language) {
        if (language.equals((Object)AtomicMapper.Language.DE)) {
            return 16.27 + 5.1 * (double)sourceSize + 4.9 * (double)targetSize - 23.44 * threshold;
        }
        return 0.62 + 0.001 * (double)sourceSize + 0.001 * (double)targetSize - 0.53 * threshold;
    }

    @Override
    public double getMappingSizeApproximation(int sourceSize, int targetSize, double threshold, AtomicMapper.Language language) {
        if (language.equals((Object)AtomicMapper.Language.DE)) {
            return 2333.0 + 0.14 * (double)sourceSize + 0.14 * (double)targetSize - 3905.0 * threshold;
        }
        return -1.84 + 6.0E-4 * (double)sourceSize + 6.0E-4 * (double)targetSize;
    }

    static {
        mapping = null;
    }
}

