/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.mapper.atomic;

import algorithms.Correspondence;
import algorithms.ppjoinplus.PPJoinPlus;
import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.controller.Parser;
import de.uni_leipzig.simba.data.Instance;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.mapper.AtomicMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import org.apache.log4j.Logger;

public class PPJoinMapper
implements AtomicMapper {
    static Logger logger = Logger.getLogger((String)"LIMES");

    public String getName() {
        return "PPJoinMapper";
    }

    public Mapping getMapping(Cache source, Cache target, String sourceVar, String targetVar, String expression, double threshold) {
        Instance instance;
        String var;
        String[] split;
        logger.info((Object)"Starting PPJoinMapper");
        String property1 = null;
        String property2 = null;
        Parser p = new Parser(expression, threshold);
        String term1 = "?" + p.getTerm1();
        String term2 = "?" + p.getTerm2();
        if (term1.contains(".")) {
            split = term1.split("\\.");
            var = split[0];
            if (var.equals(sourceVar)) {
                property1 = split[1];
            } else {
                property2 = split[1];
            }
        } else {
            property1 = term1;
        }
        if (term2.contains(".")) {
            split = term2.split("\\.");
            var = split[0];
            if (var.equals(sourceVar)) {
                property1 = split[1];
            } else {
                property2 = split[1];
            }
        } else {
            property2 = term2;
        }
        if (property1 == null || property2 == null) {
            logger.fatal((Object)"Property values could not be read. Exiting");
            System.exit(1);
        }
        String info = "";
        info = info + "\nWill carry out mapping using the following parameter:\n";
        info = info + "Expression <" + expression + ">\n";
        info = info + "Source property <" + property1 + ">\n";
        info = info + "Target property <" + property2 + ">\n";
        info = info + "Threshold <" + threshold + ">\n";
        logger.info((Object)info);
        if (!p.isAtomic()) {
            logger.fatal((Object)"Mappers can only deal with atomic expression");
            logger.fatal((Object)("Expression " + expression + " was given to a mapper to process"));
            System.exit(1);
        }
        char metricName = expression.charAt(0);
        logger.info((Object)"Filling objects from source knowledge base.");
        HashMap<Integer, String> sourceMap = new HashMap<Integer, String>();
        ArrayList<String> uris = source.getAllUris();
        ArrayList<String> entries = new ArrayList<String>();
        int counter = 0;
        int border = 0;
        for (int i = 0; i < uris.size(); ++i) {
            instance = source.getInstance(uris.get(i));
            for (String s : instance.getProperty(property1)) {
                sourceMap.put(counter, uris.get(i));
                entries.add(s);
                ++counter;
            }
        }
        logger.info((Object)"Filling objects from target knowledge base.");
        HashMap<Integer, String> targetMap = new HashMap<Integer, String>();
        border = counter - 1;
        uris = target.getAllUris();
        for (int i = 0; i < uris.size(); ++i) {
            instance = target.getInstance(uris.get(i));
            for (String s : instance.getProperty(property2)) {
                targetMap.put(counter, uris.get(i));
                entries.add(s);
                ++counter;
            }
        }
        String[] entryArray = new String[entries.size()];
        for (int i = 0; i < entries.size(); ++i) {
            entryArray[i] = (String)entries.get(i);
        }
        logger.info((Object)"Launching PPJoin++");
        LinkedList result = PPJoinPlus.start((char)metricName, (double)threshold, (int)2, (String[])entryArray);
        logger.info((Object)"Reorganizing ...");
        Mapping map = new Mapping();
        for (int i = 0; i < result.size(); ++i) {
            Correspondence corr = (Correspondence)result.get(i);
            if ((corr.getFirstObject() > border || corr.getSecondObject() <= border) && (corr.getFirstObject() <= border || corr.getSecondObject() > border)) continue;
            if (corr.getFirstObject() <= border) {
                map.add((String)sourceMap.get(corr.getFirstObject()), (String)targetMap.get(corr.getSecondObject()), corr.getSimilarity());
                continue;
            }
            map.add((String)targetMap.get(corr.getFirstObject()), (String)sourceMap.get(corr.getSecondObject()), corr.getSimilarity());
        }
        logger.info((Object)"PPJoin++ complete.");
        return map;
    }

    public double getRuntimeApproximation(int sourceSize, int targetSize, double threshold, AtomicMapper.Language language) {
        if (language.equals((Object)AtomicMapper.Language.DE)) {
            return 16.27 + 5.1 * (double)sourceSize + 4.9 * (double)targetSize - 23.44 * threshold;
        }
        return 26.03 + 0.005 * (double)(sourceSize + targetSize) - 49.5 * threshold;
    }

    public double getMappingSizeApproximation(int sourceSize, int targetSize, double threshold, AtomicMapper.Language language) {
        if (language.equals((Object)AtomicMapper.Language.DE)) {
            return 2333.0 + 0.14 * (double)sourceSize + 0.14 * (double)targetSize - 3905.0 * threshold;
        }
        return 0.003 * (double)(sourceSize + targetSize);
    }

    public double getSelectivity(int sourceSize, int targetSize, double threshold, AtomicMapper.Language language) {
        return this.getMappingSizeApproximation(sourceSize, targetSize, threshold, language) / (double)(sourceSize * targetSize);
    }
}

