/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.mapper.atomic;

import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.controller.Parser;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.mapper.AtomicMapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExactMatchMapper
implements AtomicMapper {
    static Logger logger = Logger.getLogger((String)"LIMES");

    @Override
    public Mapping getMapping(Cache source, Cache target, String sourceVar, String targetVar, String expression, double threshold) {
        String var;
        String[] split;
        logger.info((Object)"Starting ExactMatchMapper");
        String property1 = null;
        String property2 = null;
        Parser p = new Parser(expression, threshold);
        String term1 = "?" + p.getTerm1();
        String term2 = "?" + p.getTerm2();
        if (term1.contains(".")) {
            split = term1.split("\\.");
            var = split[0];
            if (var.equals(sourceVar)) {
                property1 = split[1];
            } else {
                property2 = split[1];
            }
        } else {
            property1 = term1;
        }
        if (term2.contains(".")) {
            split = term2.split("\\.");
            var = split[0];
            if (var.equals(sourceVar)) {
                property1 = split[1];
            } else {
                property2 = split[1];
            }
        } else {
            property2 = term2;
        }
        if (property1 == null || property2 == null) {
            logger.fatal((Object)"Property values could not be read. Exiting");
            System.exit(1);
        }
        if (!p.isAtomic()) {
            logger.fatal((Object)"Mappers can only deal with atomic expression");
            logger.fatal((Object)("Expression " + expression + " was given to a mapper to process"));
            System.exit(1);
        }
        Map<String, Set<String>> sourceIndex = this.index(source, property1);
        Map<String, Set<String>> targetIndex = this.index(target, property2);
        Mapping m = new Mapping();
        if (sourceIndex.keySet().size() < targetIndex.keySet().size()) {
            for (String value : sourceIndex.keySet()) {
                if (!targetIndex.containsKey(value)) continue;
                for (String sourceUri : sourceIndex.get(value)) {
                    for (String targetUri : targetIndex.get(value)) {
                        m.add(sourceUri, targetUri, 1.0);
                    }
                }
            }
        } else {
            for (String value : targetIndex.keySet()) {
                if (!sourceIndex.containsKey(value)) continue;
                for (String sourceUri : sourceIndex.get(value)) {
                    for (String targetUri : targetIndex.get(value)) {
                        m.add(sourceUri, targetUri, 1.0);
                    }
                }
            }
        }
        return m;
    }

    public Map<String, Set<String>> index(Cache c, String property) {
        HashMap<String, Set<String>> index = new HashMap<String, Set<String>>();
        for (String uri : c.getAllUris()) {
            TreeSet<String> values = c.getInstance(uri).getProperty(property);
            for (String v : values) {
                if (!index.containsKey(v)) {
                    index.put(v, new HashSet());
                }
                ((Set)index.get(v)).add(uri);
            }
        }
        return index;
    }

    @Override
    public String getName() {
        return "exactMatch";
    }

    @Override
    public double getRuntimeApproximation(int sourceSize, int targetSize, double theta, AtomicMapper.Language language) {
        return (sourceSize + targetSize) / 1000;
    }

    @Override
    public double getMappingSizeApproximation(int sourceSize, int targetSize, double theta, AtomicMapper.Language language) {
        return (sourceSize + targetSize) / 1000;
    }
}

