/*
 * Decompiled with CFR 0.152.
 */
package de.uni_leipzig.simba.mapper.atomic;

import algorithms.StoppUhr;
import algorithms.Token;
import algorithms.edjoin.MismatchingQGram;
import algorithms.edjoin.QGram;
import algorithms.edjoin.Record;
import de.uni_leipzig.simba.cache.Cache;
import de.uni_leipzig.simba.controller.Parser;
import de.uni_leipzig.simba.data.Instance;
import de.uni_leipzig.simba.data.Mapping;
import de.uni_leipzig.simba.mapper.AtomicMapper;
import de.uni_leipzig.simba.mapper.atomic.EdPosition;
import de.uni_leipzig.simba.mapper.atomic.Frequency;
import de.uni_leipzig.simba.mapper.atomic.SuffixSumListEntry;
import de.uni_leipzig.simba.mapper.atomic.compareQGramsResult;
import de.uni_leipzig.simba.measures.string.StringMeasure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EDJoin
implements AtomicMapper {
    static Logger logger = Logger.getLogger((String)"LIMES");
    private static int Q = -1;
    private static Mapping mapping = null;
    private static HashMap<Integer, String> sourceMap;
    private static HashMap<Integer, String> targetMap;
    private StringMeasure measure;
    private int comparisons = 0;

    @Override
    public String getName() {
        return "EDJoin";
    }

    @Override
    public Mapping getMapping(Cache source, Cache target, String sourceVar, String targetVar, String expression, double threshold) {
        Instance instance;
        int i;
        int i2;
        String var;
        String[] split;
        if (Q <= 1) {
            Q = 3;
        }
        threshold = (1.0 - threshold) / threshold;
        this.comparisons = 0;
        mapping = new Mapping();
        boolean candidatesCount = false;
        if (threshold < 0.0) {
            logger.info((Object)"Wrong threshold setting. Returning empty mapping.");
            return mapping;
        }
        String property1 = null;
        String property2 = null;
        Parser p = new Parser(expression, threshold);
        String term1 = "?" + p.getTerm1();
        String term2 = "?" + p.getTerm2();
        String property = "";
        if (term1.contains(".")) {
            split = term1.split("\\.");
            var = split[0];
            property = split[1];
            if (split.length >= 2) {
                for (i2 = 2; i2 < split.length; ++i2) {
                    property = property + "." + split[i2];
                }
            }
            if (var.equals(sourceVar)) {
                property1 = property;
            } else {
                property2 = property;
            }
        } else {
            property1 = term1;
        }
        if (term2.contains(".")) {
            split = term2.split("\\.");
            var = split[0];
            property = split[1];
            if (split.length >= 2) {
                for (i2 = 2; i2 < split.length; ++i2) {
                    property = property + "." + split[i2];
                }
            }
            if (var.equals(sourceVar)) {
                property1 = property;
            } else {
                property2 = property;
            }
        } else {
            property2 = term2;
        }
        if (property1 == null || property2 == null) {
            logger.fatal((Object)("Property 1 = " + property1 + ", Property 2 = " + property2));
            logger.fatal((Object)"Property values could not be read. Exiting");
            System.exit(1);
        }
        if (!p.isAtomic()) {
            logger.fatal((Object)"Mappers can only deal with atomic expression");
            logger.fatal((Object)("Expression " + expression + " was given to a mapper to process"));
            System.exit(1);
        }
        sourceMap = new HashMap();
        ArrayList<String> uris = source.getAllUris();
        ArrayList<String> entries = new ArrayList<String>();
        int counter = 0;
        int border = 0;
        for (i = 0; i < uris.size(); ++i) {
            instance = source.getInstance(uris.get(i));
            for (String s : instance.getProperty(property1)) {
                sourceMap.put(counter, uris.get(i));
                entries.add(s);
                ++counter;
            }
        }
        targetMap = new HashMap();
        border = counter - 1;
        uris = target.getAllUris();
        for (i = 0; i < uris.size(); ++i) {
            instance = target.getInstance(uris.get(i));
            for (String s : instance.getProperty(property2)) {
                targetMap.put(counter, uris.get(i));
                entries.add(s);
                ++counter;
            }
        }
        String[] entryArray = new String[entries.size()];
        for (int i3 = 0; i3 < entries.size(); ++i3) {
            entryArray[i3] = (String)entries.get(i3);
        }
        Record[] records = EDJoin.qTokenizer(entryArray, Q);
        HashMap index = new HashMap();
        int count = 0;
        int percentage = records.length / 100;
        block7: for (int i4 = 0; i4 < records.length; ++i4) {
            if (records[i4].qGrams.length == 0 && records[i4].s.length() > 0) {
                String x = records[i4].s;
                for (int j = i4 + 1; j < records.length; ++j) {
                    String id2;
                    String id1;
                    if ((!sourceMap.containsKey(records[i4].id) || !targetMap.containsKey(records[j].id)) && (!targetMap.containsKey(records[i4].id) || !sourceMap.containsKey(records[j].id))) continue;
                    String y = records[j].s;
                    if (!((double)Math.abs(x.length() - y.length()) <= threshold)) continue block7;
                    int ed = EDJoin.editDistance(x, y);
                    if (!((double)ed <= threshold)) continue;
                    if (sourceMap.containsKey(records[i4].id) && targetMap.containsKey(records[j].id)) {
                        id1 = sourceMap.get(records[i4].id);
                        id2 = targetMap.get(records[j].id);
                        mapping.add(id1, id2, 1.0 / (1.0 + (double)ed));
                    } else {
                        id1 = sourceMap.get(records[j].id);
                        id2 = targetMap.get(records[i4].id);
                        mapping.add(id1, id2, 1.0 / (1.0 + (double)ed));
                    }
                    ++count;
                }
                continue;
            }
            HashMap<Integer, Record> candidates = new HashMap<Integer, Record>();
            Record currentRec = records[i4];
            int prefixLength = EDJoin.calcPrefixLen(currentRec, (int)threshold, Q);
            for (int j = 0; j < prefixLength; ++j) {
                Integer tokenID = currentRec.qGrams[j].token.id;
                Integer loc = currentRec.qGrams[j].loc;
                LinkedList<EdPosition> l = (LinkedList<EdPosition>)index.get(tokenID);
                if (l != null) {
                    for (EdPosition pos : l) {
                        if (!((double)pos.record.qGrams.length >= (double)currentRec.qGrams.length - threshold) || candidates.get(pos.record.id) != null || !((double)Math.abs(loc - pos.EdPosition) <= threshold)) continue;
                        candidates.put(pos.record.id, pos.record);
                    }
                    l.add(new EdPosition(currentRec, loc));
                    continue;
                }
                l = new LinkedList<EdPosition>();
                l.add(new EdPosition(currentRec, loc));
                index.put(tokenID, l);
            }
            if (candidates.size() <= 0) continue;
            count += EDJoin.verification(currentRec, candidates, entries, Q, (int)threshold);
        }
        return mapping;
    }

    private static Record[] qTokenizer(String[] objects, int q) {
        int i;
        StoppUhr s = new StoppUhr();
        s.Starten();
        HashMap<String, Token> allTokens = new HashMap<String, Token>();
        Object[] records = new Record[objects.length];
        for (i = 0; i < objects.length; ++i) {
            int qGramsNumber = objects[i].length() - q + 1;
            Record record = new Record(i, Math.max(0, qGramsNumber), objects[i]);
            for (int j = 0; j < qGramsNumber; ++j) {
                Token t;
                String token = objects[i].substring(j, j + q);
                if (allTokens.containsKey(token)) {
                    t = (Token)allTokens.get(token);
                    ++t.df;
                    record.qGrams[j] = new QGram(t, j);
                    continue;
                }
                t = new Token(allTokens.size(), 1);
                allTokens.put(token, t);
                record.qGrams[j] = new QGram(t, j);
            }
            records[i] = record;
        }
        for (i = 0; i < records.length; ++i) {
            Arrays.sort(((Record)records[i]).qGrams);
        }
        Arrays.sort(records);
        s.Stoppen();
        return records;
    }

    private static int verification(Record currentRec, HashMap<Integer, Record> candidates, ArrayList<String> objects, int q, int threshold) {
        int count = 0;
        for (Record y : candidates.values()) {
            String id2;
            String id1;
            int ed;
            int e3;
            int e2;
            compareQGramsResult compResult = EDJoin.compareQGrams(currentRec, y, threshold);
            if (compResult.e1 > q * threshold || (e2 = EDJoin.minEditErrors(compResult.Q, q)) > threshold || (e3 = EDJoin.contentFilter(objects.get(currentRec.id), objects.get(y.id), compResult.Q, threshold, q)) > 2 * threshold || (ed = EDJoin.editDistance(objects.get(currentRec.id), objects.get(y.id))) > threshold) continue;
            if (sourceMap.containsKey(currentRec.id) && targetMap.containsKey(y.id)) {
                id1 = sourceMap.get(currentRec.id);
                id2 = targetMap.get(y.id);
                mapping.add(id1, id2, 1.0 / (1.0 + (double)ed));
                continue;
            }
            if (!targetMap.containsKey(currentRec.id) || !sourceMap.containsKey(y.id)) continue;
            id1 = sourceMap.get(y.id);
            id2 = targetMap.get(currentRec.id);
            mapping.add(id1, id2, 1.0 / (1.0 + (double)ed));
            ++count;
        }
        return count;
    }

    private static int calcPrefixLen(Record x, int tau, int q) {
        if (x.qGrams.length <= tau + 1) {
            return x.qGrams.length;
        }
        int left = tau + 1;
        int right = x.qGrams.length < q * tau + 1 ? x.qGrams.length : q * tau + 1;
        while (left < right) {
            int mid = (left + right) / 2;
            MismatchingQGram[] temp = new MismatchingQGram[mid];
            for (int i = 0; i < mid; ++i) {
                temp[i] = new MismatchingQGram(x.qGrams[i]);
            }
            int err = EDJoin.minEditErrors(temp, q);
            if (err <= tau) {
                left = mid + 1;
                continue;
            }
            right = mid;
        }
        return left;
    }

    private static compareQGramsResult compareQGrams(Record x, Record y, int tau) {
        LinkedList<MismatchingQGram> mismatchingQgrams = new LinkedList<MismatchingQGram>();
        QGram[] xQGrams = x.qGrams;
        QGram[] yQGrams = y.qGrams;
        int i = 0;
        int j = 0;
        int epsilon = 0;
        while (i < xQGrams.length && j < yQGrams.length) {
            if (xQGrams[i].token.id == yQGrams[j].token.id) {
                if (Math.abs(xQGrams[i].loc - yQGrams[j].loc) <= tau) {
                    ++i;
                    ++j;
                    continue;
                }
                if (xQGrams[i].loc < yQGrams[j].loc) {
                    if (i == 0 || xQGrams[i].token.id != xQGrams[i - 1].token.id || j == 0 || xQGrams[i].token.id != yQGrams[j - 1].token.id || Math.abs(xQGrams[i].loc - yQGrams[j - 1].loc) > tau) {
                        mismatchingQgrams.add(new MismatchingQGram(xQGrams[i]));
                    }
                    ++epsilon;
                    ++i;
                    continue;
                }
                ++j;
                continue;
            }
            if (xQGrams[i].compareTo(yQGrams[j]) < 0) {
                if (i == 0 || xQGrams[i].token.id != xQGrams[i - 1].token.id || j == 0 || xQGrams[i].token.id != yQGrams[j - 1].token.id || Math.abs(xQGrams[i].loc - yQGrams[j - 1].loc) > tau) {
                    mismatchingQgrams.add(new MismatchingQGram(xQGrams[i]));
                }
                ++epsilon;
                ++i;
                continue;
            }
            ++j;
        }
        while (i < xQGrams.length) {
            if (i == 0 || xQGrams[i].token.id != xQGrams[i - 1].token.id || j == 0 || xQGrams[i].token.id != yQGrams[j - 1].token.id || Math.abs(xQGrams[i].loc - yQGrams[j - 1].loc) > tau) {
                mismatchingQgrams.add(new MismatchingQGram(xQGrams[i]));
            }
            ++epsilon;
            ++i;
        }
        return new compareQGramsResult(mismatchingQgrams.toArray(new MismatchingQGram[mismatchingQgrams.size()]), epsilon);
    }

    private static int minEditErrors(MismatchingQGram[] Q, int q) {
        Arrays.sort(Q);
        int cnt = 0;
        int loc = 0;
        for (int i = 0; i < Q.length; ++i) {
            if (Q[i].loc <= loc) continue;
            ++cnt;
            loc = Q[i].loc + q - 1;
        }
        return cnt;
    }

    private static int contentFilter(String x, String y, MismatchingQGram[] Q, int tau, int q) {
        int i;
        if (Q.length == 0) {
            return 0;
        }
        LinkedList<SuffixSumListEntry> condensedSuffixSumList = new LinkedList<SuffixSumListEntry>();
        int cnt = 1;
        int loc = Q[Q.length - 1].loc + 1;
        for (int i2 = Q.length - 1; i2 >= 0; --i2) {
            if (Q[i2].loc > loc) continue;
            condensedSuffixSumList.addFirst(new SuffixSumListEntry(Q[i2].loc, cnt++));
            loc = Q[i2].loc - q;
        }
        Iterator<SuffixSumListEntry> iter = condensedSuffixSumList.iterator();
        int j = 0;
        for (i = 1; i < Q.length; ++i) {
            if (Q[i].loc - Q[i - 1].loc <= 1) continue;
            int epsilon = EDJoin.L1Distance(x, y, Q[j].loc, Q[i - 1].loc + q - 1) + EDJoin.sumRightErrs(Q[i - 1].loc + q, iter);
            if (epsilon > 2 * tau) {
                return 2 * tau + 1;
            }
            j = i;
        }
        return EDJoin.L1Distance(x, y, Q[j].loc, Q[i - 1].loc + q - 1) + EDJoin.sumRightErrs(Q[i - 1].loc + q, iter);
    }

    private static int L1Distance(String x, String y, int lo, int hi) {
        Frequency f;
        char c;
        int i;
        HashMap<Character, Frequency> frequencyTable = new HashMap<Character, Frequency>();
        for (i = lo; i <= hi; ++i) {
            c = x.charAt(i);
            f = (Frequency)frequencyTable.get(Character.valueOf(c));
            if (f != null) {
                ++f.value;
                continue;
            }
            frequencyTable.put(Character.valueOf(c), new Frequency(1));
        }
        for (i = lo; i < y.length() && i <= hi; ++i) {
            c = y.charAt(i);
            f = (Frequency)frequencyTable.get(Character.valueOf(c));
            if (f != null) {
                --f.value;
                continue;
            }
            frequencyTable.put(Character.valueOf(c), new Frequency(-1));
        }
        Iterator iter = frequencyTable.values().iterator();
        int L1 = 0;
        while (iter.hasNext()) {
            L1 += Math.abs(((Frequency)iter.next()).value);
        }
        return L1;
    }

    private static int sumRightErrs(int loc, Iterator<SuffixSumListEntry> iter) {
        while (iter.hasNext()) {
            SuffixSumListEntry entry = iter.next();
            if (entry.loc < loc) continue;
            return entry.errors;
        }
        return 0;
    }

    public static int editDistance(String x, String y) {
        int j;
        int i;
        int n = x.length();
        int m = y.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        int[][] d = new int[n + 1][m + 1];
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (i = 1; i <= n; ++i) {
            for (j = 1; j <= m; ++j) {
                int cost = x.charAt(i - 1) == y.charAt(j - 1) ? 0 : 1;
                d[i][j] = EDJoin.min(d[i - 1][j] + 1, d[i][j - 1] + 1, d[i - 1][j - 1] + cost);
            }
        }
        return d[n][m];
    }

    private static int min(int a, int b, int c) {
        int min = a;
        if (b < min) {
            min = b;
        }
        if (c < min) {
            min = c;
        }
        return min;
    }

    @Override
    public double getRuntimeApproximation(int sourceSize, int targetSize, double theta, AtomicMapper.Language language) {
        if (language.equals((Object)AtomicMapper.Language.DE)) {
            return 20.06 + 0.0064 * (double)sourceSize + 0.0052 * (double)targetSize - 22.65 * theta;
        }
        return 30.5 + 0.009 * (double)(sourceSize + targetSize) - 57.8 * theta;
    }

    @Override
    public double getMappingSizeApproximation(int sourceSize, int targetSize, double theta, AtomicMapper.Language language) {
        if (language.equals((Object)AtomicMapper.Language.DE)) {
            return 0.69 + 0.005 * (double)sourceSize + 0.005 * (double)targetSize - 22.58 * theta;
        }
        return 0.008 * (double)(sourceSize + targetSize) - 67.7 * theta;
    }

    public double getSelectivity(int sourceSize, int targetSize, double threshold, AtomicMapper.Language language) {
        return this.getMappingSizeApproximation(sourceSize, targetSize, threshold, language) / (double)(sourceSize * targetSize);
    }
}

